/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.changepoints.views.MultipleRunSeriesPanel;
import org.rhwlab.DAG.changepoints.views.RunTreePanel;

public class MultiEmbryoFrame
extends JFrame
implements ChangeListener {
    JCheckBox fixedScaleBox;
    JCheckBox logSpaceBox;
    JCheckBox filterOnsetsBox;
    MultipleRunSeriesPanel mainPanel;
    RunTreePanel runTree;

    public MultiEmbryoFrame() throws Exception {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.runTree = new RunTreePanel();
        this.runTree.addListener(this);
        content.add((Component)this.runTree.getPanel(), "West");
        this.mainPanel = new MultipleRunSeriesPanel();
        content.add((Component)this.mainPanel, "Center");
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BoxLayout(boxPanel, 0));
        this.logSpaceBox = new JCheckBox("Display in log space");
        this.logSpaceBox.setSelected(true);
        boxPanel.add(this.logSpaceBox);
        this.fixedScaleBox = new JCheckBox("Fixed Scale");
        this.fixedScaleBox.setSelected(true);
        boxPanel.add(Box.createHorizontalStrut(30));
        boxPanel.add(this.fixedScaleBox);
        this.filterOnsetsBox = new JCheckBox("Onsets only");
        this.filterOnsetsBox.setSelected(true);
        boxPanel.add(Box.createHorizontalStrut(30));
        boxPanel.add(this.filterOnsetsBox);
        content.add((Component)boxPanel, "North");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MultiEmbryoFrame frame = new MultiEmbryoFrame();
                    frame.setDefaultCloseOperation(3);
                    frame.setSize(1000, 500);
                    frame.setVisible(true);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object selected = this.runTree.getSelected();
        try {
            if (selected instanceof ChangePointRun) {
                this.mainPanel.useRun((ChangePointRun)selected, this.logSpaceBox.isSelected(), this.fixedScaleBox.isSelected(), this.filterOnsetsBox.isSelected());
                this.mainPanel.validate();
                this.mainPanel.repaint();
            } else {
                this.mainPanel.useSeries((String)selected, this.logSpaceBox.isSelected(), this.fixedScaleBox.isSelected());
                this.mainPanel.validate();
                this.mainPanel.repaint();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

