/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints.views;

import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.DAG.changepoints.CP_Parameter;
import org.rhwlab.DAG.changepoints.ChangePointTreeRegion;
import org.rhwlab.DAG.changepoints.LineageCPModel;
import org.rhwlab.DAG.models.ReversibleJump;
import org.rhwlab.beans.EmbryoCell;

public class LineageView
implements ChangeListener {
    ReversibleJump alg;
    EmbryoCell lineage;
    boolean logSpace = true;
    JFreeChart chart;
    JPanel panel;
    XYSeriesCollection collect;
    XYSeries xyTimeSeries;
    XYSeries xyRegionsSeries;

    public LineageView(ReversibleJump alg, EmbryoCell lineage) {
        this.lineage = lineage;
        this.alg = alg;
        this.collect = new XYSeriesCollection();
        this.chart = ChartFactory.createScatterPlot((String)(lineage.fromSeries() + "_" + lineage.getName()), (String)"Time", (String)"Expression", (XYDataset)this.collect, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        this.panel = new ChartPanel(this.chart);
        this.drawTimeSeries(lineage);
    }

    private void drawTimeSeries(EmbryoCell lineage) {
        int minExp = lineage.getEmbryo().minExpression();
        this.xyTimeSeries = new XYSeries((Comparable)((Object)"TimeSeries"));
        this.addCellExpressionValues(lineage, minExp);
        this.collect.addSeries(this.xyTimeSeries);
    }

    private void addCellExpressionValues(EmbryoCell cell, double minExp) {
        EmbryoCell great;
        int[] exps = cell.getExpressionValues();
        int index = 0;
        for (int i = cell.getStartTime(); i < cell.getEndTime(); ++i) {
            double y = exps[index];
            if (this.logSpace) {
                y = Math.log(1.0 + y - minExp);
            }
            this.xyTimeSeries.add((double)i, y);
            ++index;
        }
        EmbryoCell less = (EmbryoCell)cell.getLessDaughter();
        if (less != null) {
            this.addCellExpressionValues(less, minExp);
        }
        if ((great = (EmbryoCell)cell.getGreaterDaughter()) != null) {
            this.addCellExpressionValues(great, minExp);
        }
    }

    private void drawRegions(ChangePointTreeRegion region) {
        if (this.xyRegionsSeries != null) {
            this.collect.removeSeries(this.xyRegionsSeries);
        }
        this.xyRegionsSeries = new XYSeries((Comparable)((Object)"Regions"));
        this.addRegionsValues(region);
        this.collect.addSeries(this.xyRegionsSeries);
    }

    private void addRegionsValues(ChangePointTreeRegion region) {
        for (int i = region.getStarted(); i <= region.getEnded(); ++i) {
            double x = i;
            double y = region.regressionValueAt(x);
            this.xyRegionsSeries.add(x, y);
        }
        for (ChangePointTreeRegion childRegion : region.getChildrenRegions().values()) {
            this.addRegionsValues(childRegion);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.alg == null) {
            return;
        }
        LineageCPModel model = (LineageCPModel)this.alg.getModel();
        if (model == null) {
            return;
        }
        Map<String, CP_Parameter> cpMap = model.getChangePointMap();
        try {
            ChangePointTreeRegion region = new ChangePointTreeRegion(this.lineage, cpMap);
            this.drawRegions(region);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

