/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.changepoints.LineageCPModel;
import org.rhwlab.DAG.changepoints.LineageChangePoint;
import org.rhwlab.DAG.changepoints.views.LineageView;
import org.rhwlab.DAG.models.ReversibleJump;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Imaged;
import org.rhwlab.universalimaging.Embryo;

public class ChangePointSteppingFrame
extends JFrame {
    static String[] lineages = new String[]{"E"};

    public ChangePointSteppingFrame(String gene, String construct) throws Exception {
        ChangePointRun run = new ChangePointRun(gene, construct, new ArrayList<String>());
        File dir = new File(run.getRunID());
        dir.mkdir();
        ArrayList allseriesList = Imaged.publishedByGeneConstruct((String)gene, (String)construct);
        SulstonEmbryo sulston = new SulstonEmbryo(MySql.getMySql());
        ArrayList<String[]> embryoList = new ArrayList<String[]>();
        for (String series : allseriesList) {
            String[] embryo = new SeriesEmbryo(MySql.getMySql(), series, "zblot");
            if (!sulston.sulstonize((Embryo)embryo)) continue;
            embryoList.add(embryo);
        }
        SeriesEmbryo[] embryos = embryoList.toArray(new SeriesEmbryo[0]);
        TreeMap<String, LineageCPModel> modelMap = new TreeMap<String, LineageCPModel>();
        for (String lineage : lineages) {
            LineageCPModel model = new LineageCPModel(true, run.getRunID(), embryos, lineage);
            modelMap.put(lineage, model);
        }
        TreeMap<String, LineageChangePoint> algorithmMap = new TreeMap<String, LineageChangePoint>();
        for (String lineage : lineages) {
            LineageCPModel model = new LineageCPModel(true, run.getRunID(), embryos, lineage);
            model.logProb();
            LineageChangePoint algorithm = new LineageChangePoint(run, model);
            algorithm.setBurnIn(0);
            algorithm.setIterations(5000);
            algorithm.setThining(0);
            algorithmMap.put(lineage, algorithm);
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        for (String lineage : lineages) {
            JPanel lineagePanel = new JPanel();
            lineagePanel.setLayout(new BoxLayout(lineagePanel, 0));
            for (SeriesEmbryo seriesEmbryo : embryoList) {
                EmbryoCell lineageCell = seriesEmbryo.getCell(lineage);
                LineageView view = new LineageView((ReversibleJump)algorithmMap.get(lineage), lineageCell);
                ((ReversibleJump)algorithmMap.get(lineage)).addListener(view);
                lineagePanel.add(view.getPanel());
            }
            mainPanel.add(lineagePanel);
        }
        JScrollPane scroll = new JScrollPane(mainPanel);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)scroll, "Center");
        JButton step = new JButton("Step");
        for (ReversibleJump alg : algorithmMap.values()) {
            step.addActionListener(alg);
        }
        content.add((Component)step, "South");
        this.pack();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ChangePointSteppingFrame frame = new ChangePointSteppingFrame(args[0], args[1]);
                    frame.setDefaultCloseOperation(3);
                    frame.setSize(1000, 500);
                    frame.setVisible(true);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }
}

