/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.rhwlab.DAG.changepoints.CP_Segment;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.changepoints.TreeOnset;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.db.MySql;
import org.rhwlab.expression.ExpressionTimeSeries;
import org.rhwlab.universalimaging.Embryo;

public class TreeChangePoint {
    String cell;
    double time;
    double prob;

    public TreeChangePoint(String cell, double time, double prob) {
        this.cell = cell;
        this.time = time;
        this.prob = prob;
    }

    public static Map<String, Map<String, TreeOnset>> plasmidOnsets(SulstonEmbryo sulston, EmbryoCell[] sulstonLeafCells, double threshold) throws Exception {
        List<ChangePointRun> runs = ChangePointRun.latestPlasmidRuns();
        TreeMap<String, Map<String, TreeOnset>> ret = new TreeMap<String, Map<String, TreeOnset>>();
        for (ChangePointRun run : runs) {
            ArrayList<SeriesEmbryo> embryoList = new ArrayList<SeriesEmbryo>();
            for (String series : run.getSeriesList()) {
                SeriesEmbryo embryo = new SeriesEmbryo(MySql.getMySql(), series, "zblot");
                sulston.sulstonize((Embryo)embryo);
                embryoList.add(embryo);
            }
            TreeMap<String, TreeOnset> cellMap = new TreeMap<String, TreeOnset>();
            for (EmbryoCell sulstonLeafCell : sulstonLeafCells) {
                TreeOnset onset = TreeChangePoint.leafOnset(sulstonLeafCell, threshold, embryoList, run);
                if (onset == null) continue;
                cellMap.put(sulstonLeafCell.getName(), onset);
            }
            ret.put(run.getGene(), cellMap);
        }
        return ret;
    }

    public double getTime() {
        return this.time;
    }

    public String getCell() {
        return this.cell;
    }

    public static TreeOnset leafOnset(EmbryoCell sulstonLeaf, double thresh, List<SeriesEmbryo> embryoList, ChangePointRun run) throws Exception {
        TreeChangePoint treeCP;
        ArrayList sulstonAncestors = sulstonLeaf.getAncestorsInclusive();
        Map cpMap = run.getChangePoints(thresh);
        boolean isOnset = true;
        double avgRatio = 0.0;
        for (SeriesEmbryo embryo : embryoList) {
            double minExp = embryo.minExpression();
            double maxExp = embryo.maxExpression();
            for (int i = sulstonAncestors.size() - 1; i >= 0; --i) {
                EmbryoCell sulstonAncestor = (EmbryoCell)sulstonAncestors.get(i);
                EmbryoCell embryoLeaf = embryo.getCell(sulstonAncestor.getName());
                if (embryoLeaf == null || !embryoLeaf.isLeaf()) continue;
                ExpressionTimeSeries timeSeries = ExpressionTimeSeries.factory((EmbryoCell)embryoLeaf, (String)"zblot");
                CP_Segment[] segs = ChangePointRun.changePointSegments(timeSeries.getLogAll(minExp), embryoLeaf, cpMap);
                double leafMaxExp = timeSeries.getMax();
                avgRatio += leafMaxExp / maxExp;
                isOnset = TreeChangePoint.segmentsHaveOnset(segs);
                break;
            }
            if (isOnset) continue;
            break;
        }
        if (isOnset && (treeCP = TreeChangePoint.mostProximal(sulstonLeaf, thresh, run)) != null) {
            TreeOnset treeOnset = new TreeOnset(treeCP.cell, treeCP.time, treeCP.prob, avgRatio / (double)embryoList.size());
            return treeOnset;
        }
        return null;
    }

    public static boolean segmentsHaveOnset(CP_Segment[] segs) {
        boolean isOnset = true;
        if (segs.length >= 2) {
            double firstSlope = segs[0].reg.getSlope();
            double secondSlope = 0.0;
            try {
                secondSlope = segs[1].reg.getSlope();
            }
            catch (Exception exc) {
                boolean bl = false;
            }
            if (secondSlope <= 0.0 || secondSlope < firstSlope) {
                isOnset = false;
            }
        } else {
            isOnset = false;
        }
        return isOnset;
    }

    public static TreeChangePoint mostProximal(EmbryoCell cell, double probThreshold, ChangePointRun run) {
        TreeChangePoint parentCP;
        TreeChangePoint ret = run.getChangePoint(cell.getName(), probThreshold);
        EmbryoCell parent = cell.getParentCell();
        if (parent != null && (parentCP = TreeChangePoint.mostProximal(parent, probThreshold, run)) != null) {
            ret = parentCP;
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        PrintStream stream = System.out;
        if (args.length > 2) {
            stream = new PrintStream(args[2]);
        }
        SulstonEmbryo sulston = new SulstonEmbryo(MySql.getMySql());
        String lineage = args[0];
        EmbryoCell lineageCell = sulston.getEmbryo().getCell(lineage);
        EmbryoCell[] leaves = lineageCell.getLeaves();
        double threshold = Double.valueOf(args[1]);
        Map<String, Map<String, TreeOnset>> onsets = TreeChangePoint.plasmidOnsets(sulston, leaves, threshold);
        stream.print("Gene");
        for (EmbryoCell cell : leaves) {
            stream.printf("\t%s\t%s", cell.getName(), cell.getName());
        }
        stream.println();
        for (String gene : onsets.keySet()) {
            stream.printf("%s", gene);
            Map<String, TreeOnset> onsetMap = onsets.get(gene);
            for (EmbryoCell leaf : leaves) {
                TreeOnset onset = onsetMap.get(leaf.getName());
                if (onset != null) {
                    stream.printf("\t%.2f\t%.2f", onset.time, onset.expRatio);
                    continue;
                }
                stream.printf("\t%.2f\t%.2f", 0.0, 0.0);
            }
            stream.println();
        }
    }
}

