/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.changepoints.LineageCPModel;
import org.rhwlab.DAG.changepoints.LineageChangePoint;
import org.rhwlab.DAG.models.ReversibleJump;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Imaged;
import org.rhwlab.universalimaging.Embryo;

public class MultiEmbryo
implements Runnable {
    int burnIn = 10000;
    int iter = 20000;
    int thin = 0;
    String[] lineages = new String[]{"MS"};
    Map<String, ReversibleJump> algorithmMap = new TreeMap<String, ReversibleJump>();

    public MultiEmbryo(ChangePointRun cpRun, SeriesEmbryo[] embryos, boolean logSpace) throws Exception {
        for (String lineage : this.lineages) {
            LineageCPModel model = new LineageCPModel(logSpace, cpRun.getRunID(), embryos, lineage);
            model.logProb();
            LineageChangePoint algorithm = new LineageChangePoint(cpRun, model);
            algorithm.setBurnIn(this.burnIn);
            algorithm.setIterations(this.iter);
            algorithm.setThining(this.thin);
            this.algorithmMap.put(lineage, algorithm);
        }
    }

    @Override
    public void run() {
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (ReversibleJump algorithm : this.algorithmMap.values()) {
            Thread thread = new Thread(algorithm);
            threadList.add(thread);
            thread.start();
        }
        boolean finished = false;
        block3: while (!finished) {
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            finished = true;
            for (Thread thread : threadList) {
                if (!thread.isAlive()) continue;
                finished = false;
                continue block3;
            }
        }
    }

    public ReversibleJump getAlgorithm(String lineage) {
        return this.algorithmMap.get(lineage);
    }

    public static void main(String[] args) throws Exception {
        SulstonEmbryo sulston = new SulstonEmbryo(MySql.getMySql());
        boolean logSpace = args[1].equals("Plasmid");
        File geneFile = new File(args[0]);
        ArrayList<String> geneList = new ArrayList<String>();
        if (geneFile.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(args[0]));
            String gene = reader.readLine();
            while (gene != null) {
                geneList.add(gene);
                gene = reader.readLine();
            }
        } else {
            geneList.add(args[0]);
        }
        for (String gene : geneList) {
            ArrayList allseriesList = Imaged.publishedByGeneConstruct((String)gene, (String)args[1]);
            ArrayList<SeriesEmbryo> embryoList = new ArrayList<SeriesEmbryo>();
            ArrayList<String> seriesList = new ArrayList<String>();
            for (int i = 0; i < allseriesList.size(); ++i) {
                String series = (String)allseriesList.get(i);
                boolean omit = false;
                for (int j = 2; j < args.length; ++j) {
                    if (!series.equals(args[j])) continue;
                    omit = true;
                    break;
                }
                if (omit) continue;
                SeriesEmbryo embryo = new SeriesEmbryo(MySql.getMySql(), series, "zblot");
                if (sulston.sulstonize((Embryo)embryo)) {
                    embryoList.add(embryo);
                    seriesList.add(series);
                    continue;
                }
                System.out.printf("Gene: %s   Series: %s cannot be sulstonized\n", gene, series);
            }
            SeriesEmbryo[] embryos = embryoList.toArray(new SeriesEmbryo[0]);
            ChangePointRun cpRun = new ChangePointRun(gene, args[1], seriesList);
            if (seriesList.isEmpty()) continue;
            cpRun.saveRunDef();
            File dir = new File(cpRun.getRunID());
            dir.mkdir();
            MultiEmbryo embryoChangePoints = new MultiEmbryo(cpRun, embryos, logSpace);
            embryoChangePoints.run();
        }
    }
}

