/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.util.Map;
import org.rhwlab.DAG.changepoints.CP_Parameter;
import org.rhwlab.DAG.changepoints.ChangePointTreeRegion;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.parameters.NonNegative;
import org.rhwlab.DAG.pipeline.Pipeline;
import org.rhwlab.beans.EmbryoCell;

public class LineageLikelihood
implements Distribution {
    double minExp;
    Map<String, CP_Parameter> cpMap;
    NonNegative variance;

    public LineageLikelihood(double minExp, Map<String, CP_Parameter> map, NonNegative variance) {
        this.cpMap = map;
        this.variance = variance;
        this.minExp = minExp;
    }

    @Override
    public Object sample() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double logDensity(Object o) throws Exception {
        EmbryoCell lineage = (EmbryoCell)o;
        int endTime = lineage.getEmbryo().getEndTime();
        double lineageLength = endTime - lineage.getStartTime();
        ChangePointTreeRegion region = new ChangePointTreeRegion(this.minExp, lineage, this.cpMap, this.variance);
        double p = region.logDensityRecursive();
        if (Pipeline.tracing) {
            System.out.printf("Likelihood: region prob=%f\n", p);
        }
        p += this.slopePenalty(region);
        if (Pipeline.tracing) {
            System.out.printf("Likelihood: region prob=%f\n", p);
        }
        return p += this.regionLengthPenalty(region, lineageLength);
    }

    private double regionLengthPenalty(ChangePointTreeRegion region, double length) {
        double pen = Math.log((double)(region.getEnded() - region.getStarted()) / length);
        for (ChangePointTreeRegion childRegion : region.childRegionMap.values()) {
            pen += 0.2 * this.regionLengthPenalty(childRegion, length);
        }
        return pen;
    }

    private double slopePenalty(ChangePointTreeRegion region) {
        double pen = 0.0;
        double m0 = region.regress.getSlope();
        for (ChangePointTreeRegion childRegion : region.childRegionMap.values()) {
            double m1 = childRegion.regress.getSlope();
            double delM = m1 - m0;
            if (Pipeline.tracing) {
                // empty if block
            }
            double p = -0.05 / Math.abs(delM);
            pen += p;
            if (Pipeline.tracing) {
                // empty if block
            }
            double childP = this.slopePenalty(childRegion);
            pen += childP;
        }
        if (Pipeline.tracing) {
            // empty if block
        }
        return pen;
    }

    @Override
    public Object getVariance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getMean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

