/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.changepoints.LineageCPModel;
import org.rhwlab.DAG.changepoints.TreeChangePoint;
import org.rhwlab.DAG.models.ReversibleJump;
import weka.estimators.KernelEstimator;

public class LineageChangePoint
extends ReversibleJump
implements Runnable {
    ChangePointRun cpRun;

    public LineageChangePoint(ChangePointRun cpRun, LineageCPModel model) {
        super(model);
        this.cpRun = cpRun;
    }

    @Override
    public void run() {
        super.run();
        LineageCPModel model = (LineageCPModel)this.getModel();
        model.closeStream();
        File dir = new File(this.cpRun.getRunID());
        File file = new File(dir, model.getLineage().getName());
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            String[] headers = line.split(",");
            KernelEstimator[] kdes = new KernelEstimator[headers.length];
            for (int i = 0; i < kdes.length; ++i) {
                kdes[i] = new KernelEstimator(0.01);
            }
            line = reader.readLine();
            int count = 0;
            while (line != null) {
                String[] tokens = line.split(",");
                ++count;
                for (int i = 0; i < tokens.length; ++i) {
                    if (tokens[i].equals("NA")) continue;
                    kdes[i].addValue(Double.valueOf(tokens[i]).doubleValue(), 1.0);
                }
                line = reader.readLine();
            }
            reader.close();
            for (int i = 0; i < kdes.length; ++i) {
                int n = kdes[i].getNumKernels();
                double[] means = kdes[i].getMeans();
                double[] weights = kdes[i].getWeights();
                double maxP = 0.0;
                int modeIndex = -1;
                double totalWeight = 0.0;
                for (int j = 0; j < n; ++j) {
                    totalWeight += weights[j];
                    double p = kdes[i].getProbability(means[j]);
                    if (!(p > maxP)) continue;
                    maxP = p;
                    modeIndex = j;
                }
                if (modeIndex == -1) continue;
                double sulstonTime = means[modeIndex];
                double prob = totalWeight / (double)count;
                if (headers[i].contains("Sigma")) continue;
                TreeChangePoint cp = new TreeChangePoint(headers[i], sulstonTime, prob);
                this.cpRun.addChangePoint(cp);
                ChangePointRun.saveChangePoint(this.cpRun.getRunID(), cp);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

