/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.DAG.Data;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.changepoints.CP_Parameter;
import org.rhwlab.DAG.changepoints.Count;
import org.rhwlab.DAG.changepoints.LeafChangePointCount;
import org.rhwlab.DAG.changepoints.LeafDataLikelihood;
import org.rhwlab.DAG.changepoints.LineageLikelihood;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.distributions.InverseGamma;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.models.ReversibleJumpModel;
import org.rhwlab.DAG.parameters.NonNegative;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.expression.ExpressionTimeSeries;

public class LineageCPModel
extends ReversibleJumpModel {
    boolean logSpace;
    String choice;
    EmbryoCell targetLeaf;
    SeriesEmbryo[] embryos;
    double[] minExp;
    TreeMap<String, EmbryoCell> lineageRoots;
    TreeMap<String, EmbryoCell>[] embryosLeaves;
    Map<String, ExpressionTimeSeries> leafTimeSeriesMap;
    EmbryoCell consensusRoot;
    EmbryoCell[] consensusLeaves;
    TreeSet<EmbryoCell> consensusCells;
    static String[] jumps = new String[]{"Add", "Del", "Chg"};
    static Random rand = null;
    NonNegative[] sigmas;
    Map<String, CP_Parameter> changePointMap;
    TreeMap<String, LeafDataLikelihood> likelihoodMap;
    boolean first = true;
    PrintStream stream;

    public LineageCPModel(boolean logSpace, String runID, SeriesEmbryo[] embryos, String lineage) throws Exception {
        int i;
        this.logSpace = logSpace;
        this.embryos = embryos;
        this.embryosLeaves = new TreeMap[embryos.length];
        this.minExp = new double[embryos.length];
        for (int i2 = 0; i2 < embryos.length; ++i2) {
            EmbryoCell[] leaves;
            this.embryosLeaves[i2] = new TreeMap();
            for (EmbryoCell leaf : leaves = embryos[i2].getCell(lineage).getLeaves()) {
                this.embryosLeaves[i2].put(leaf.getName(), leaf);
            }
            this.minExp[i2] = embryos[i2].minExpression();
        }
        this.lineageRoots = new TreeMap();
        for (SeriesEmbryo embryo : embryos) {
            String id = embryo.getID();
            EmbryoCell lineageCell = embryo.getCell(lineage);
            this.lineageRoots.put(id, lineageCell);
        }
        this.consensusRoot = EmbryoCell.ConsensusTree(this.lineageRoots.values());
        this.consensusCells = this.consensusRoot.getAllCells();
        this.consensusLeaves = this.consensusRoot.getLeaves();
        File dir = new File(runID);
        this.stream = new PrintStream(new File(dir, lineage));
        if (rand == null) {
            rand = new Random();
        }
        this.sigmas = new NonNegative[embryos.length];
        for (i = 0; i < embryos.length; ++i) {
            String sigmaName = String.format("Sigma_%s_%s", lineage, embryos[i].getID());
            this.sigmas[i] = new NonNegative(sigmaName, this, 0.2, 1.0);
            this.sigmas[i].setPrior(new InverseGamma(1.0, 1.0));
        }
        this.stream.print(this.sigmas[0].getName());
        for (i = 1; i < this.sigmas.length; ++i) {
            this.stream.printf(",%s", this.sigmas[i].getName());
        }
        for (EmbryoCell cell : this.consensusCells) {
            this.stream.printf(",%s", cell.getName());
        }
        this.stream.println();
        this.leafTimeSeriesMap = new HashMap<String, ExpressionTimeSeries>();
        for (int i3 = 0; i3 < embryos.length; ++i3) {
            String id = embryos[i3].getID();
            TreeMap<String, EmbryoCell> leafMap = this.embryosLeaves[i3];
            for (EmbryoCell leaf : leafMap.values()) {
                this.leafTimeSeriesMap.put(id + leaf.getName(), ExpressionTimeSeries.factory((EmbryoCell)leaf));
            }
        }
        this.changePointMap = new TreeMap<String, CP_Parameter>();
        this.likelihoodMap = new TreeMap();
        this.addLikelihoodsToModel();
    }

    public LineageCPModel(EmbryoCell consensus, boolean logSpace, SeriesEmbryo[] embryos, double[] minExp, TreeMap<String, EmbryoCell> lineageRoots, TreeMap<String, EmbryoCell>[] embryosLeaves, PrintStream stream, EmbryoCell lineage, EmbryoCell[] leaves, TreeSet<EmbryoCell> lineageCells, Map leafTimeSeriesMap, NonNegative[] sigs) {
        this.consensusRoot = consensus;
        this.logSpace = logSpace;
        this.embryos = embryos;
        this.minExp = minExp;
        this.lineageRoots = lineageRoots;
        this.embryosLeaves = embryosLeaves;
        this.stream = stream;
        this.consensusRoot = lineage;
        this.consensusLeaves = leaves;
        this.leafTimeSeriesMap = leafTimeSeriesMap;
        this.consensusCells = lineageCells;
        this.changePointMap = new TreeMap<String, CP_Parameter>();
        this.sigmas = new NonNegative[sigs.length];
        for (int i = 0; i < sigs.length; ++i) {
            this.sigmas[i] = (NonNegative)sigs[i].copy(this);
            this.sigmas[i].setPrior(new InverseGamma(1.0, 1.0));
        }
        this.likelihoodMap = new TreeMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReversibleJumpModel propose() throws Exception {
        void var3_8;
        this.targetLeaf = this.consensusLeaves[rand.nextInt(this.consensusLeaves.length)];
        ArrayList<CP_Parameter> leafChangePoints = this.getLeafChangePoints(this.targetLeaf);
        this.choice = "Add";
        if (!leafChangePoints.isEmpty()) {
            this.choice = jumps[rand.nextInt(jumps.length)];
        }
        for (CP_Parameter object : leafChangePoints) {
        }
        LineageCPModel nextModel = new LineageCPModel(this.consensusRoot, this.logSpace, this.embryos, this.minExp, this.lineageRoots, this.embryosLeaves, this.stream, this.consensusRoot, this.consensusLeaves, this.consensusCells, this.leafTimeSeriesMap, this.sigmas);
        nextModel.targetLeaf = this.targetLeaf;
        nextModel.choice = this.choice;
        for (CP_Parameter cp : this.changePointMap.values()) {
            boolean found = false;
            for (int i = 0; i < leafChangePoints.size(); ++i) {
                if (!((CP_Parameter)leafChangePoints.get(i)).getName().equals(cp.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            cp.copy(nextModel);
        }
        int n = leafChangePoints.size();
        if (this.choice.equals("Add")) {
            void var3_6;
            ++var3_6;
        } else if (this.choice.equals("Del")) {
            void var3_7;
            --var3_7;
        }
        ArrayList ancestors = this.targetLeaf.getAncestorsInclusive();
        int n2 = Math.min((int)var3_8, ancestors.size());
        int count = 0;
        while (count < n2) {
            CP_Parameter cp;
            int j = rand.nextInt(ancestors.size());
            EmbryoCell ancestor = (EmbryoCell)ancestors.get(j);
            if (!ancestor.isLeaf() || ancestors.size() == 1) {
                cp = new CP_Parameter(ancestor, nextModel);
                ancestors.remove(j);
                ++count;
                continue;
            }
            if (!(ancestor.getSulstonEnd() - ancestor.getSulstonStart() > 15.0)) continue;
            cp = new CP_Parameter(ancestor, nextModel, 15);
            ancestors.remove(j);
            ++count;
        }
        nextModel.addLikelihoodsToModel();
        Collection ps = nextModel.getParameters();
        return nextModel;
    }

    private void constructLikelihoods() {
        for (int i = 0; i < this.embryos.length; ++i) {
            SeriesEmbryo embryo = this.embryos[i];
            EmbryoCell embryoLineage = this.lineageRoots.get(embryo.getID());
            TreeMap<String, EmbryoCell> leafMap = this.embryosLeaves[i];
            for (EmbryoCell leaf : leafMap.values()) {
                Object object;
                String leafName = embryo.getID() + leaf.getName();
                double[] y = null;
                y = this.logSpace ? this.leafTimeSeriesMap.get(leafName).getLogAll(this.minExp[i]) : this.leafTimeSeriesMap.get(leafName).getAllDouble();
                LeafDataLikelihood like = new LeafDataLikelihood(this.changePointMap, leaf, embryoLineage, y, this.sigmas[i]);
                this.likelihoodMap.put(leafName, like);
                Data dataNode = new Data(leafName, this.changePointMap, (Model)this, like);
                dataNode.addParent(this.sigmas[i]);
                ArrayList<CP_Parameter> cps = like.getLeafChangePoints();
                for (CP_Parameter cp : cps) {
                    dataNode.addParent(cp);
                }
                if (cps == null) {
                    object = new Count("Count", (Model)this, 0);
                    continue;
                }
                object = new Count("Count", (Model)this, cps.size());
            }
        }
    }

    private void addLikelihoodsToModel() throws Exception {
        for (int i = 0; i < this.embryos.length; ++i) {
            EmbryoCell[] leaves;
            SeriesEmbryo embryo = this.embryos[i];
            EmbryoCell embryoLineage = this.lineageRoots.get(embryo.getID());
            LineageLikelihood like = new LineageLikelihood(this.minExp[i], this.changePointMap, this.sigmas[i]);
            ArrayList<Node> parentNodes = new ArrayList<Node>();
            parentNodes.addAll(this.changePointMap.values());
            parentNodes.add(this.sigmas[i]);
            Data dataNode = new Data(embryo.getID(), (Object)embryoLineage, (Model)this, parentNodes, (Distribution)like);
            for (EmbryoCell leaf : leaves = embryoLineage.getLeaves()) {
                LeafChangePointCount leafChangePointCount = new LeafChangePointCount("Count", this, this.changePointMap, leaf, leaves.length);
            }
        }
    }

    @Override
    public double logProposal(ReversibleJumpModel next) {
        double p = 0.0;
        try {
            if (!this.getLeafChangePoints(this.targetLeaf).isEmpty()) {
                p = -Math.log(3.0);
            }
            LineageCPModel nextModel = (LineageCPModel)next;
            ArrayList<CP_Parameter> cps = nextModel.getLeafChangePoints(this.targetLeaf);
            int n = this.targetLeaf.getAncestorsInclusive().size();
            for (CP_Parameter cp : cps) {
                EmbryoCell cell = cp.cell;
                double range = 1.0 + cell.getSulstonEnd() - cell.getSulstonStart();
                if (cell.isLeaf() && (range -= 15.0) < 0.0) {
                    p = Double.NEGATIVE_INFINITY;
                    return p;
                }
                p = p - Math.log(n) - Math.log(range);
                --n;
            }
            if (p == Double.NaN || p == Double.NEGATIVE_INFINITY) {
                boolean bl = false;
            }
        }
        catch (Exception exc) {
            boolean bl = false;
        }
        return p;
    }

    @Override
    public String getModelID() {
        return this.consensusRoot.getName();
    }

    public EmbryoCell getLineage() {
        return this.consensusRoot;
    }

    public ArrayList<CP_Parameter> getLeafChangePoints(EmbryoCell leaf) {
        EmbryoCell parent = leaf.getParentCell();
        ArrayList<CP_Parameter> cps = parent != null ? this.getLeafChangePoints(parent) : new ArrayList();
        CP_Parameter cp = this.changePointMap.get(leaf.getName());
        if (cp != null) {
            cps.add(cp);
        }
        return cps;
    }

    @Override
    public void record() {
        this.stream.printf("%.4f", (Double)this.sigmas[0].getValue());
        for (int i = 1; i < this.sigmas.length; ++i) {
            this.stream.printf(",%.4f", (Double)this.sigmas[i].getValue());
        }
        for (EmbryoCell cell : this.consensusCells) {
            CP_Parameter cp = this.changePointMap.get(cell.getName());
            if (cp != null) {
                this.stream.printf(",%.4f", (Double)cp.getValue());
                continue;
            }
            this.stream.print(",NA");
        }
        this.stream.println();
    }

    public void closeStream() {
        this.stream.close();
    }

    public EmbryoCell[] getLeaves() {
        return this.consensusLeaves;
    }

    public String getMove() {
        return String.format("%s %s", this.choice, this.targetLeaf.getName());
    }

    public Map<String, CP_Parameter> getChangePointMap() {
        return this.changePointMap;
    }
}

