/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.util.ArrayList;
import java.util.Map;
import org.rhwlab.DAG.changepoints.CP_Parameter;
import org.rhwlab.DAG.changepoints.CP_Segment;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.parameters.NonNegative;
import org.rhwlab.beans.EmbryoCell;

public class LeafDataLikelihood
implements Distribution {
    EmbryoCell lineage;
    CP_Segment[] segments;
    NonNegative variance;
    Map<String, CP_Parameter> cpMap;
    double[] y;
    ArrayList<CP_Parameter> cpList;
    static double minusBeta = Math.log(0.5) / 0.05;

    public LeafDataLikelihood(Map<String, CP_Parameter> map, EmbryoCell leaf, EmbryoCell lineage, double[] y, NonNegative variance) {
        this.cpMap = map;
        this.variance = variance;
        this.y = y;
        this.cpList = this.getAncestorChangePoints(leaf);
        this.lineage = lineage;
    }

    private ArrayList<CP_Parameter> getAncestorChangePoints(EmbryoCell cell) {
        EmbryoCell parent = cell.getParentCell();
        ArrayList<CP_Parameter> ret = parent != null ? this.getAncestorChangePoints(parent) : new ArrayList();
        CP_Parameter cp = this.cpMap.get(cell.getName());
        if (cp != null) {
            ret.add(cp);
        }
        return ret;
    }

    @Override
    public Object sample() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double logDensity(Object o) throws Exception {
        double[] dirichlet = CP_Segment.dirichletFromCPs(this.cpList, this.y, this.lineage);
        this.segments = CP_Segment.factory(this.y, dirichlet);
        double p = 0.0;
        double sig = (Double)this.variance.getValue();
        for (CP_Segment seg : this.segments) {
            for (int i = seg.getStart(); i <= seg.getEnd(); ++i) {
                p += Normal.logDensity(this.y[i], seg.getValue(i), sig);
            }
            p += 10.0 * Math.log(1.0 - Math.exp(minusBeta * seg.getWidth()));
        }
        if (this.segments.length > 1) {
            for (int i = 1; i < this.segments.length; ++i) {
                Double m0 = this.segments[i - 1].getSlope();
                Double m1 = this.segments[i].getSlope();
                if (m0 == null || m1 == null) continue;
                try {
                    double penalty = 10.0 / Math.abs(m1 - m0);
                    p -= penalty;
                    continue;
                }
                catch (Exception exc) {
                    System.out.println(exc.getMessage());
                }
            }
        }
        return p;
    }

    @Override
    public Object getVariance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getMean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ArrayList<CP_Parameter> getLeafChangePoints() {
        return this.cpList;
    }

    public CP_Segment[] getSegments() {
        return this.segments;
    }
}

