/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.util.ArrayList;
import java.util.Map;
import org.rhwlab.DAG.Function;
import org.rhwlab.DAG.changepoints.CP_Parameter;
import org.rhwlab.DAG.distributions.DiscreteDist;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.beans.EmbryoCell;

public class LeafChangePointCount
extends Function {
    int n;
    static double[] pdf = new double[]{100.0, 10.0, 1.0, 0.1};

    public LeafChangePointCount(String name, Model model, Map<String, CP_Parameter> cpMap, EmbryoCell leaf, int n) {
        super(name, model);
        this.n = n;
        this.setPrior(new DiscreteDist(pdf));
        this.setValue(new Integer(this.getAncestorChangePoints(cpMap, leaf).size()));
    }

    private ArrayList<CP_Parameter> getAncestorChangePoints(Map<String, CP_Parameter> cpMap, EmbryoCell cell) {
        EmbryoCell parent = cell.getParentCell();
        ArrayList<CP_Parameter> ret = parent != null ? this.getAncestorChangePoints(cpMap, parent) : new ArrayList();
        CP_Parameter cp = cpMap.get(cell.getName());
        if (cp != null) {
            ret.add(cp);
        }
        return ret;
    }

    @Override
    public double logConditionalProb() throws Exception {
        double p = 0.05 * super.logConditionalProb();
        return p;
    }

    @Override
    public void update() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

