/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.rhwlab.DAG.changepoints.CP_Parameter;
import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.parameters.NonNegative;
import org.rhwlab.beans.EmbryoCell;

public class ChangePointTreeRegion {
    double slope;
    double intercept;
    double minExp;
    NonNegative variance;
    SimpleRegression regress;
    double y0;
    int started;
    int ended;
    EmbryoCell cpCell;
    Map<String, CP_Parameter> cpMap;
    HashMap<String, ChangePointTreeRegion> childRegionMap = new HashMap();

    public ChangePointTreeRegion(EmbryoCell lineage, Map<String, CP_Parameter> cpMap) throws Exception {
        this(lineage.getEmbryo().minExpression(), lineage, cpMap, null);
    }

    public ChangePointTreeRegion(double minExp, EmbryoCell lineage, Map<String, CP_Parameter> cpMap, NonNegative variance) throws Exception {
        this(minExp, true, 0.0, lineage.getStartTime(), lineage, cpMap, variance);
        this.buildChildRegion(this);
        boolean iszodfhs = false;
    }

    public ChangePointTreeRegion(double minExp, double y0, double startAt, EmbryoCell cell, Map<String, CP_Parameter> cpMap, NonNegative variance) throws Exception {
        this(minExp, false, y0, startAt, cell, cpMap, variance);
        this.buildChildRegion(this);
        boolean asijdf = false;
    }

    public ChangePointTreeRegion(double minExp, boolean intercept, double y0, double startAt, EmbryoCell cell, Map<String, CP_Parameter> cpMap, NonNegative variance) throws Exception {
        this.regress = new SimpleRegression(intercept);
        this.y0 = y0;
        this.started = (int)Math.ceil(startAt);
        this.cpMap = cpMap;
        this.cpCell = cell;
        this.variance = variance;
        this.minExp = minExp;
        this.addCellRecursive(this.started, cell);
        this.slope = this.regress.getSlope();
        this.intercept = this.regress.getIntercept();
        boolean kjsdf = false;
    }

    private void buildChildRegion(ChangePointTreeRegion parentRegion) throws Exception {
        HashMap<String, ChangePointTreeRegion> tempMap = new HashMap<String, ChangePointTreeRegion>();
        for (String cellName : this.childRegionMap.keySet()) {
            EmbryoCell cell = this.cpCell.getDescendent(cellName);
            CP_Parameter cp = this.cpMap.get(cellName);
            double cpEmbryoTime = cell.embryoTime(((Double)cp.getValue()).doubleValue());
            double y0 = parentRegion.regressionValueAt(cpEmbryoTime);
            ChangePointTreeRegion childRegion = new ChangePointTreeRegion(this.minExp, y0, cpEmbryoTime, cell, this.cpMap, this.variance);
            tempMap.put(cellName, childRegion);
        }
        this.childRegionMap = tempMap;
    }

    public double logDensityRecursive() throws Exception {
        double p = this.logDensityNonRecursive();
        for (ChangePointTreeRegion region : this.childRegionMap.values()) {
            p += region.logDensityRecursive();
        }
        return p;
    }

    public double logDensityNonRecursive() throws Exception {
        EmbryoCell root = this.cpCell;
        double p = this.cellLogDensityRecursive(this.started, root);
        return p;
    }

    public double cellLogDensityRecursive(int startAt, EmbryoCell cell) throws Exception {
        double p = this.cellLogDensityNonRecursive(startAt, cell, cell.getEndTime());
        if (!cell.isLeaf()) {
            EmbryoCell less = (EmbryoCell)cell.getLessDaughter();
            CP_Parameter cp = this.cpMap.get(less.getName());
            if (cp == null) {
                this.cellLogDensityRecursive(less.getStartTime(), less);
            } else {
                double endAt = less.embryoTime(((Double)cp.getValue()).doubleValue());
                p += this.cellLogDensityNonRecursive(less.getStartTime(), less, (int)endAt);
            }
            EmbryoCell great = (EmbryoCell)cell.getGreaterDaughter();
            cp = this.cpMap.get(great.getName());
            if (cp == null) {
                this.cellLogDensityRecursive(great.getStartTime(), great);
            } else {
                double endAt = great.embryoTime(((Double)cp.getValue()).doubleValue());
                p += this.cellLogDensityNonRecursive(great.getStartTime(), great, (int)endAt);
            }
        }
        return p;
    }

    public double cellLogDensityNonRecursive(int startAt, EmbryoCell cell, int endAt) {
        double p = 0.0;
        double[] yValues = cell.getLogExpressionValues();
        int cellStartTime = cell.getStartTime();
        double sig = (Double)this.variance.getValue();
        for (int i = startAt; i <= Math.min(endAt, cell.getEndTime()); ++i) {
            int index = i - cellStartTime;
            double yReg = this.regressionValueAt(i);
            double v = Normal.logDensity(yValues[index], yReg, sig);
            p += v;
        }
        return p;
    }

    public double regressionValueAt(double x) {
        return this.y0 + this.regress.predict(x - (double)this.started);
    }

    private final void addCellRecursive(int startAt, EmbryoCell cell) throws Exception {
        this.addCellNonRecursive(startAt, cell, cell.getEndTime());
        if (!cell.isLeaf()) {
            EmbryoCell less = (EmbryoCell)cell.getLessDaughter();
            CP_Parameter cp = this.cpMap.get(less.getName());
            if (cp == null) {
                this.addCellRecursive(less.getStartTime(), less);
            } else {
                double endAt = less.embryoTime(((Double)cp.getValue()).doubleValue());
                this.addCellNonRecursive(less.getStartTime(), less, (int)endAt);
                this.childRegionMap.put(cp.getName(), null);
            }
            EmbryoCell great = (EmbryoCell)cell.getGreaterDaughter();
            cp = this.cpMap.get(great.getName());
            if (cp == null) {
                this.addCellRecursive(great.getStartTime(), great);
            } else {
                double endAt = great.embryoTime(((Double)cp.getValue()).doubleValue());
                this.addCellNonRecursive(great.getStartTime(), great, (int)endAt);
                this.childRegionMap.put(cp.getName(), null);
            }
        }
    }

    private void addCellNonRecursive(int startAt, EmbryoCell cell, int endAt) {
        double[] yValues = cell.getLogExpressionValues();
        double y = 0.0;
        int cellStartTime = cell.getStartTime();
        int end = Math.min(endAt, cell.getEndTime());
        for (int i = startAt; i <= end; ++i) {
            int index = i - cellStartTime;
            y = yValues[index] - this.y0;
            double x = i - this.started;
            this.regress.addData(x, y);
        }
        if (end > this.ended) {
            this.ended = end;
        }
    }

    public String regionID() {
        return String.format("Region: %s:::%s ", this.cpCell.getName(), this.cpCell.fromSeries());
    }

    public int getStarted() {
        return this.started;
    }

    public int getEnded() {
        return this.ended;
    }

    public Map<String, ChangePointTreeRegion> getChildrenRegions() {
        return this.childRegionMap;
    }
}

