/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.rhwlab.DAG.changepoints.CP_Segment;
import org.rhwlab.DAG.changepoints.TreeChangePoint;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.db.MySql;

public class ChangePointRun {
    String runID;
    String gene;
    String construct;
    Timestamp startedAt;
    ArrayList<String> seriesList = new ArrayList();
    Map<String, Double> sigmaMap;
    Map<String, TreeChangePoint> changePointMap = new HashMap<String, TreeChangePoint>();

    public ChangePointRun() {
        this.sigmaMap = new HashMap<String, Double>();
    }

    public ChangePointRun(String runID) throws Exception {
        this();
        this.runID = runID;
        String sql = String.format("Select * from ChangePointRun where RunID='%s'", runID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()) {
            this.gene = rs.getString("Gene");
            this.construct = rs.getString("Construct");
            this.startedAt = rs.getTimestamp("StartTime");
            sql = String.format("Select * from ChangePointSeries where RunID='%s'", runID);
            rs = MySql.getMySql().execute(sql);
            while (rs.next()) {
                String series = rs.getString("Series");
                this.seriesList.add(series);
                this.sigmaMap.put(series, new Double(rs.getDouble("Sigma")));
            }
            sql = String.format("Select * from ChangePointTree where RunID='%s'", runID);
            rs = MySql.getMySql().execute(sql);
            while (rs.next()) {
                String cell = rs.getString("Cell");
                if (runID.contains("his-72") && cell.contains("ABpra")) {
                    boolean bl = false;
                }
                TreeChangePoint cp = new TreeChangePoint(cell, rs.getDouble("SulstonTime"), rs.getDouble("Prob"));
                this.changePointMap.put(cell, cp);
            }
        }
    }

    public ChangePointRun(String gene, String construct, ArrayList<String> seriesList) {
        this();
        this.gene = gene;
        this.construct = construct;
        this.seriesList = seriesList;
        this.startedAt = new Timestamp(new Date().getTime());
        SimpleDateFormat simple = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
        this.runID = String.format("%s_%s_%s", this.gene, this.construct, simple.format(this.startedAt));
    }

    static List<ChangePointRun> plasmidRuns() throws Exception {
        ArrayList<ChangePointRun> ret = new ArrayList<ChangePointRun>();
        String sql = "select RunID from (select Gene,max(SeriesCount) MaxCount from ChangePointRun where Construct='Plasmid' group by Gene order by Gene) J join ChangePointRun R on R.Gene=J.Gene where J.MaxCount=R.SeriesCount";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()) {
            String runID = rs.getString("RunID");
            ChangePointRun run = new ChangePointRun(runID);
            ret.add(run);
        }
        return ret;
    }

    static List<ChangePointRun> latestPlasmidRuns() throws Exception {
        ArrayList<ChangePointRun> ret = new ArrayList<ChangePointRun>();
        String sql = "select RunID from (select Gene,max(StartTime) MaxTime from ChangePointRun where Construct='Plasmid' group by Gene order by Gene) J join ChangePointRun R on R.Gene=J.Gene where J.MaxTime=R.StartTime";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()) {
            String runID = rs.getString("RunID");
            ChangePointRun run = new ChangePointRun(runID);
            ret.add(run);
        }
        return ret;
    }

    public static CP_Segment[] changePointSegments(double[] y, EmbryoCell leaf, Map<String, TreeChangePoint> cps) throws Exception {
        ArrayList ancestors = leaf.getAncestorsInclusive();
        ArrayList<TreeChangePoint> cpList = new ArrayList<TreeChangePoint>();
        for (EmbryoCell ancestor : ancestors) {
            EmbryoCell cell;
            TreeChangePoint cp = cps.get(ancestor.getName());
            if (cp == null || !((cell = cp.cell.equals(leaf.getName()) ? leaf : leaf.getParentByName(cp.cell)).embryoTime(cp.time) <= (double)cell.getEndTime())) continue;
            cpList.add(cp);
        }
        CP_Segment[] ret = new CP_Segment[cpList.size() + 1];
        if (cpList.isEmpty()) {
            ret[0] = new CP_Segment(null, y, 0, y.length - 1, 1.0);
            return ret;
        }
        TreeChangePoint cp = (TreeChangePoint)cpList.get(0);
        EmbryoCell cell = cp.cell.equals(leaf.getName()) ? leaf : leaf.getParentByName(cp.cell);
        double embryoTime = cell.embryoTime(cp.time);
        int end = Math.min(y.length - 1, (int)embryoTime - 1);
        ret[0] = new CP_Segment(cp, y, 0, end, (double)end / (double)(y.length - 1));
        int start = end + 1;
        double yOff = ret[0].getValue(end + 1);
        double xOff = ret[0].getXEnd();
        for (int i = 1; i < cpList.size(); ++i) {
            CP_Segment seg;
            cp = (TreeChangePoint)cpList.get(i);
            cell = cp.cell.equals(leaf.getName()) ? leaf : leaf.getParentByName(cp.cell);
            embryoTime = (int)cell.embryoTime(cp.time);
            end = Math.min(y.length - 1, (int)embryoTime - 1);
            ret[i] = seg = new CP_Segment(cp, y, start, end, xOff, yOff, (double)(end - start) / (double)(y.length - 1));
            start = end + 1;
            yOff = ret[i].getValue(end + 1);
            xOff = ret[i].getXEnd();
        }
        ret[cpList.size()] = new CP_Segment(null, y, start, y.length - 1, xOff, yOff, 1.0 - (double)start / (double)(y.length - 1));
        return ret;
    }

    public static List<String> allRuns() throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        String sql = "Select distinct RunID from ChangePointRun order by RunID";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()) {
            ret.add(rs.getString("RunID"));
        }
        return ret;
    }

    public static List<String> allSeries() throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        String sql = "Select distinct Series from ChangePointSeries";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()) {
            ret.add(rs.getString("Series"));
        }
        return ret;
    }

    public static List<String> runsForSeries(String series) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        String sql = String.format("Select distinct RunID from ChangePointSeries where Series = '%s'", series);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()) {
            ret.add(rs.getString("RunID"));
        }
        return ret;
    }

    public void addChangePoint(TreeChangePoint cp) {
        this.changePointMap.put(cp.cell, cp);
    }

    public void addSigma(String series, double sigma) {
        this.sigmaMap.put(series, new Double(sigma));
    }

    public void saveRunDef() throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("insert into ChangePointRun (RunID,Gene,Construct,StartTime,SeriesCount) values (?,?,?,?,?)");
        state.setString(1, this.runID);
        state.setString(2, this.gene);
        state.setString(3, this.construct);
        state.setTimestamp(4, this.startedAt);
        state.setInt(5, this.seriesList.size());
        state.execute();
        state = MySql.getMySql().getStatement("insert into ChangePointSeries (RunID,Series) values (?,?)");
        for (String series : this.seriesList) {
            state.setString(1, this.runID);
            state.setString(2, series);
            state.execute();
        }
    }

    static void saveChangePoint(String runID, TreeChangePoint cp) throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("insert into ChangePointTree (RunID,Cell,SulstonTime,Prob) values (?,?,?,?)");
        state.setString(1, runID);
        state.setString(2, cp.cell);
        state.setDouble(3, cp.time);
        state.setDouble(4, cp.prob);
        state.execute();
    }

    public void saveChangePoints() throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("insert into ChangePointTree (RunID,Cell,SulstonTime,Prob) values (?,?,?,?)");
        for (TreeChangePoint cp : this.changePointMap.values()) {
            state.setString(1, this.runID);
            state.setString(2, cp.cell);
            state.setDouble(3, cp.time);
            state.setDouble(4, cp.prob);
            state.execute();
        }
    }

    public void saveSigmas() throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Update ChangePointSeries set Sigma = ? where RunID = ? and Series = ?");
        for (String series : this.seriesList) {
            Double sigma = this.sigmaMap.get(series);
            state.setString(1, this.runID);
            state.setString(2, series);
            state.setDouble(3, sigma);
            state.execute();
        }
    }

    public static void removeRun(String runID) throws Exception {
        String sql = String.format("Delete from ChangePointTree where RunID = '%s'", runID);
        MySql.getMySql().execute(sql);
        sql = String.format("Delete from ChangePointRun where RunID = '%s'", runID);
        MySql.getMySql().execute(sql);
        sql = String.format("Delete from ChangePointRunSeries where RunID = '%s'", runID);
        MySql.getMySql().execute(sql);
    }

    public String getRunID() {
        return this.runID;
    }

    public ArrayList<String> getSeriesList() {
        return this.seriesList;
    }

    public Map getChangePoints(double thresh) {
        TreeMap<String, TreeChangePoint> ret = new TreeMap<String, TreeChangePoint>();
        for (TreeChangePoint cp : this.changePointMap.values()) {
            if (cp.cell.contains("ABpra")) {
                boolean bl = false;
            }
            if (!(cp.prob >= thresh)) continue;
            ret.put(cp.cell, cp);
        }
        return ret;
    }

    public List getChangePoints(EmbryoCell cell, double thresh) {
        EmbryoCell parent = cell.getParentCell();
        ArrayList ret = parent != null ? (ArrayList)this.getChangePoints(parent, thresh) : new ArrayList();
        TreeChangePoint cellCP = this.getChangePoint(cell.getName(), thresh);
        if (cellCP != null) {
            ret.add(cellCP);
        }
        return ret;
    }

    public TreeChangePoint getChangePoint(String cell, double thresh) {
        TreeChangePoint cp = this.changePointMap.get(cell);
        if (cp != null && cp.prob >= thresh) {
            return cp;
        }
        return null;
    }

    public String getGene() {
        return this.gene;
    }

    public String getConstruct() {
        return this.construct;
    }

    public String toString() {
        return this.runID;
    }
}

