/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.rhwlab.DAG.changepoints.CP_Parameter;
import org.rhwlab.DAG.changepoints.TreeChangePoint;
import org.rhwlab.DAG.onsets.ResultStats;
import org.rhwlab.beans.EmbryoCell;

public class CP_Segment {
    TreeChangePoint changePoint;
    double delta;
    double value;
    int start;
    int end;
    double wid;
    SimpleRegression reg;
    double yOffset;
    double xOffset;

    public CP_Segment(TreeChangePoint cp, double[] y, int start, int end, double xOff, double yOff, double w) {
        this.changePoint = cp;
        this.yOffset = yOff;
        this.xOffset = xOff;
        this.start = start;
        this.end = end;
        this.wid = w;
        this.delta = 1.0 / (double)(y.length - 1);
        if (start < end) {
            this.reg = new SimpleRegression(false);
            for (int i = start; i <= end; ++i) {
                try {
                    double x = (double)i * this.delta - xOff;
                    double e = y[i] - yOff;
                    this.reg.addData(x, e);
                    continue;
                }
                catch (Exception exc) {
                    boolean bl = false;
                }
            }
        } else {
            this.value = y[end];
            this.reg = null;
        }
    }

    public CP_Segment(TreeChangePoint cp, double[] y, int start, int end, double w) {
        this.changePoint = cp;
        this.start = start;
        this.end = end;
        this.wid = w;
        this.yOffset = 0.0;
        this.xOffset = 0.0;
        this.delta = 1.0 / (double)(y.length - 1);
        if (start < end) {
            this.reg = new SimpleRegression(true);
            for (int i = start; i <= end; ++i) {
                this.reg.addData((double)i * this.delta, y[i]);
            }
        } else {
            this.value = y[start];
            this.reg = null;
        }
    }

    public double getValue(int index) {
        return this.getValue((double)index * this.delta);
    }

    public double getValue(double x) {
        if (this.reg == null) {
            return this.value;
        }
        return this.reg.predict(x - this.xOffset) + this.yOffset;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public double getXStart() {
        return this.xOffset;
    }

    public double getYStart() {
        return this.yOffset;
    }

    public double getXEnd() {
        return this.xOffset + this.wid;
    }

    public double getYEnd() {
        return this.getValue(this.getXEnd());
    }

    public static double[] dirichletForSulstonizedLeaf(EmbryoCell leaf, Map<String, ResultStats> cps) throws Exception {
        if (leaf.getName().startsWith("Cpppa")) {
            boolean bl = false;
        }
        ArrayList ancestors = leaf.getAncestorsInclusive();
        ArrayList<ResultStats> cpList = new ArrayList<ResultStats>();
        for (EmbryoCell ancestor : ancestors) {
            ResultStats stats = cps.get(ancestor.getName());
            if (stats == null) continue;
            cpList.add(stats);
        }
        double[] dirichlet = new double[cpList.size() + 1];
        if (cpList.isEmpty()) {
            dirichlet[0] = 1.0;
        } else {
            double start = ((EmbryoCell)ancestors.get(0)).getSulstonStart();
            double w = leaf.getSulstonEnd() - start;
            for (int i = 0; i < cpList.size(); ++i) {
                ResultStats cp = (ResultStats)cpList.get(i);
                dirichlet[i] = (Double.valueOf(cp.mu) - start) / w;
                start = cp.mu;
            }
            dirichlet[cpList.size()] = (leaf.getSulstonEnd() - start) / w;
        }
        return dirichlet;
    }

    public static double[] dirichletFromCPs(ArrayList<CP_Parameter> cpList, double[] y, EmbryoCell lineage) throws Exception {
        if (cpList.isEmpty()) {
            double[] dirichlet = new double[]{1.0};
            return dirichlet;
        }
        double w = y.length;
        ArrayList<Double> ret = new ArrayList<Double>();
        double start = 0.0;
        for (int i = 0; i < cpList.size(); ++i) {
            CP_Parameter cp = cpList.get(i);
            EmbryoCell embryoCell = lineage.getDescendent(cp.getName());
            double embryoTime = embryoCell.embryoTime(((Double)cp.getValue()).doubleValue());
            if (!(embryoTime >= 0.0) || !(embryoTime < w)) continue;
            ret.add(new Double(embryoTime - start) / w);
            start = embryoTime;
        }
        ret.add(new Double(w - start) / w);
        double[] dirichlet = new double[ret.size()];
        for (int i = 0; i < dirichlet.length; ++i) {
            dirichlet[i] = (Double)ret.get(i);
        }
        return dirichlet;
    }

    public static CP_Segment[] factory(double[] y, EmbryoCell leaf, Map<String, ResultStats> cps) throws Exception {
        ArrayList ancestors = leaf.getAncestorsInclusive();
        ArrayList<ResultStats> cpList = new ArrayList<ResultStats>();
        for (EmbryoCell ancestor : ancestors) {
            ResultStats stats = cps.get(ancestor.getName());
            if (stats == null) continue;
            cpList.add(stats);
        }
        CP_Segment[] ret = new CP_Segment[cpList.size() + 1];
        if (cpList.isEmpty()) {
            ret[0] = new CP_Segment(null, y, 0, y.length - 1, 1.0);
            return ret;
        }
        if (leaf.getName().equals("Cpaaaa")) {
            boolean ancestor = false;
        }
        ResultStats cp = (ResultStats)cpList.get(0);
        EmbryoCell cell = cp.cell.equals(leaf.getName()) ? leaf : leaf.getParentByName(cp.cell);
        double embryoTime = cell.embryoTime(cp.mu);
        int end = Math.min(y.length - 1, (int)embryoTime - 1);
        ret[0] = new CP_Segment(null, y, 0, end, (double)end / (double)(y.length - 1));
        int start = end + 1;
        double yOff = ret[0].getValue(end + 1);
        double xOff = ret[0].getXEnd();
        for (int i = 1; i < cpList.size(); ++i) {
            CP_Segment seg;
            cp = (ResultStats)cpList.get(i);
            cell = cp.cell.equals(leaf.getName()) ? leaf : leaf.getParentByName(cp.cell);
            embryoTime = (int)cell.embryoTime(cp.mu);
            end = Math.min(y.length - 1, (int)embryoTime - 1);
            ret[i] = seg = new CP_Segment(null, y, start, end, xOff, yOff, (double)(end - start) / (double)(y.length - 1));
            start = end + 1;
            yOff = ret[i].getValue(end + 1);
            xOff = ret[i].getXEnd();
        }
        ret[cpList.size()] = new CP_Segment(null, y, start, y.length - 1, xOff, yOff, 1.0 - (double)start / (double)(y.length - 1));
        return ret;
    }

    public static CP_Segment[] factory(double[] y, double[] dirichlet) {
        CP_Segment[] ret = new CP_Segment[dirichlet.length];
        int end = Math.min(y.length - 1, (int)((float)dirichlet[0] * (float)(y.length - 1)));
        ret[0] = new CP_Segment(null, y, 0, end, dirichlet[0]);
        int start = end + 1;
        for (int i = 1; i < ret.length; ++i) {
            double yOff = ret[i - 1].getYEnd();
            double xOff = ret[i - 1].getXEnd();
            end = Math.min(y.length - 1, (int)((float)(xOff + dirichlet[i]) * (float)(y.length - 1)));
            if (start >= y.length || end >= y.length) {
                end = start = y.length - 1;
            }
            ret[i] = new CP_Segment(null, y, start, end, xOff, yOff, dirichlet[i]);
            start = end + 1;
        }
        return ret;
    }

    public double getWidth() {
        return this.wid;
    }

    public TreeChangePoint getChangePoint() {
        return this.changePoint;
    }

    public Double getSlope() {
        if (this.reg == null) {
            return null;
        }
        return this.reg.getSlope();
    }
}

