/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG;

import java.io.PrintStream;
import java.util.ArrayList;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.pipeline.Pipeline;
import org.rhwlab.DAG.proposal.ProposalDistribution;

public abstract class Parameter
extends Node {
    Distribution prior;
    ProposalDistribution proposal;
    int accepted = 0;

    public Parameter() {
    }

    public Parameter(String name, Model model) {
        super(name, null, model, new ArrayList<Node>());
    }

    public Object propose() {
        if (Pipeline.tracing) {
            System.out.printf("Parameter.propose: name=%s\n", this.getName());
        }
        return this.proposal.sample(this.value);
    }

    public void setPrior(Distribution prior) {
        this.prior = prior;
    }

    public Distribution getPrior() {
        return this.prior;
    }

    public void setProposal(ProposalDistribution obj) {
        this.proposal = obj;
        if (this.getValue() == null) {
            this.setValue(this.proposal.sample(null));
        }
    }

    public ProposalDistribution getProposal() {
        return this.proposal;
    }

    @Override
    public double logConditionalProb() throws Exception {
        double p = 0.0;
        if (this.prior != null) {
            p = this.prior.logDensity(this.getValue());
        }
        if (Pipeline.tracing) {
            Object v = this.getValue();
            if (v instanceof Double) {
                System.out.printf("Parameter.logProg(out): name=%s , value =%f , prior=%f\n", this.getName(), (Double)this.getValue(), p);
            } else if (v instanceof double[]) {
                double[] vs = (double[])v;
                for (int i = 0; i < vs.length; ++i) {
                    System.out.printf("%f.2,", vs[i]);
                }
                System.out.println();
            }
        }
        if (p == Double.NaN) {
            boolean bl = false;
        }
        return p;
    }

    public void accepted() {
        ++this.accepted;
    }

    public int getAccepted() {
        return this.accepted;
    }

    public abstract Parameter copy(Model var1);

    @Override
    public abstract void reportValue(PrintStream var1, boolean var2);

    public abstract void dump(PrintStream var1);

    public final void adapt(int i) {
        this.proposal.adapt(i, this.accepted);
    }
}

