/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.rhwlab.DAG.Function;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.pipeline.Pipeline;

public abstract class Node {
    Model model;
    String name;
    protected Object value;
    ArrayList<Node> children = new ArrayList();
    ArrayList<Node> parents = new ArrayList();
    ArrayList<Function> listeners = new ArrayList();

    public Node() {
        this(null, null);
    }

    public Node(String name, Object value) {
        this(name, value, null);
    }

    public Node(String name, Object value, Model model) {
        this(name, value, model, new ArrayList<Node>());
    }

    public Node(String name, Object value, Model model, List<Node> parents) {
        this.name = name;
        this.value = value;
        this.setModel(model);
        if (parents != null) {
            for (Node parent : parents) {
                parent.children.add(this);
            }
        }
    }

    public Node(String name, Object value, Model model, Node parent) {
        this.name = name;
        this.value = value;
        this.children = new ArrayList();
        this.setModel(model);
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public void addParent(Node parent) {
        parent.children.add(this);
        this.parents.add(parent);
        if (this.model != null) {
            parent.setModel(this.model);
        }
    }

    public final void addListener(Function listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        ChangeEvent event = new ChangeEvent(this);
        for (Function fnc : this.listeners) {
            fnc.stateChanged(event);
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object v) {
        this.value = v;
        this.notifyListeners();
    }

    public double logBlanketPosteriorProb() throws Exception {
        if (Pipeline.tracing) {
            System.out.printf("Node.logBlanketProb(in): name=%s\n", this.getName());
        }
        double p = this.logConditionalProb();
        for (Node child : this.children) {
            p += child.logBlanketPosteriorProb();
        }
        if (Pipeline.tracing) {
            System.out.printf("Node.logBlanketProb(out): name=%s , p=%f\n", this.getName(), p);
        }
        return p;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setModel(Object obj) {
        if (obj != null && obj instanceof Model && this.model == null) {
            this.model = (Model)obj;
            this.model.addNode(this);
            for (Node par : this.parents) {
                par.setModel(this.model);
            }
        }
    }

    public abstract double logConditionalProb() throws Exception;

    public void reportValue(PrintStream stream, boolean first) {
        if (this.value == null) {
            boolean bl = false;
        }
        if (!first) {
            stream.print(",");
        }
        if (this.value instanceof double[]) {
            double[] v = (double[])this.getValue();
            stream.printf("%.4f", v[0]);
            for (int i = 1; i < v.length; ++i) {
                stream.printf(",%.4f", v[i]);
            }
        } else {
            stream.print(this.value);
        }
    }

    public List<Node> getParents() {
        return this.parents;
    }
}

