/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.models.Model;

public abstract class Function
extends Node
implements ChangeListener {
    Distribution prior;

    public Function() {
        this(null, null);
    }

    public Function(String name, Model model) {
        this(name, model, new ArrayList<Node>());
    }

    public Function(String name, Model model, List<Node> ps) {
        super(name, null, model);
        for (Node parent : ps) {
            this.addParent(parent);
        }
    }

    public Function(String name, Model model, Node parent) {
        super(name, null, model);
        this.addParent(parent);
    }

    @Override
    public void addParent(Node parent) {
        super.addParent(parent);
        parent.addListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.update();
    }

    @Override
    public double logConditionalProb() throws Exception {
        if (this.prior != null) {
            return this.prior.logDensity(this.getValue());
        }
        return 0.0;
    }

    public void setPrior(Distribution prior) {
        this.prior = prior;
    }

    public boolean canUpdate() {
        if (this.getValue() != null) {
            return true;
        }
        boolean ret = true;
        for (Node parent : this.parents) {
            if (parent.getValue() != null) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public void setParents(Object obj) {
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                this.addParent((Node)o);
            }
        } else {
            this.addParent((Node)obj);
        }
    }

    public void init() throws Exception {
        this.update();
    }

    public abstract void update();
}

