/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG;

import java.util.ArrayList;
import java.util.List;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.pipeline.Pipeline;

public class Data
extends Node {
    Distribution likelihood;

    public Data() {
    }

    public Data(String name, Object value, Model model, Distribution likelihood) {
        this(name, value, model, new ArrayList<Node>(), likelihood);
    }

    public Data(String name, Object value, Model model, Node parent, Distribution likelihood) {
        super(name, value, model, parent);
        this.likelihood = likelihood;
    }

    public Data(String name, Object value, Model model, List<Node> parents, Distribution likelihood) {
        super(name, value, model, parents);
        this.likelihood = likelihood;
    }

    @Override
    public double logConditionalProb() throws Exception {
        boolean bl;
        double p;
        if (Pipeline.tracing) {
            System.out.printf("Data.logConditionalProb(in): name=%s\n", this.getName());
        }
        if ((p = this.likelihood.logDensity(this.value)) == Double.NEGATIVE_INFINITY) {
            bl = false;
        }
        if (p == Double.NaN) {
            bl = false;
        }
        if (Pipeline.tracing) {
            System.out.printf("Data.logConditionalProb(out): name=%s,%f\n", this.getName(), p);
        }
        return p;
    }
}

