/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantFieldref;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;
import nl.tudelft.simulation.language.reflection.ClassUtil;

public class PUTSTATIC
extends VoidOperation {
    public static final int OP = 179;
    private int index = -1;
    private static final Map CACHE = new HashMap();

    public PUTSTATIC(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        try {
            Field field = null;
            if (!CACHE.containsKey(constantPool[this.index])) {
                ConstantFieldref constantFieldref = (ConstantFieldref)constantPool[this.index];
                Class referenceClass = constantFieldref.getConstantClass().getValue().getClassValue();
                field = ClassUtil.resolveField(referenceClass, constantFieldref.getConstantNameAndType().getName());
                ((AccessibleObject)field).setAccessible(true);
                CACHE.put(constantPool[this.index], field);
            } else {
                field = (Field)CACHE.get(constantPool[this.index]);
            }
            Object value = stack.pop();
            Object target = null;
            if (!field.getType().isPrimitive()) {
                field.set(target, value);
                return;
            }
            if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Byte.TYPE) || field.getType().equals(Character.TYPE) || field.getType().equals(Short.TYPE) || field.getType().equals(Integer.TYPE)) {
                field.setInt(target, (Integer)value);
                return;
            }
            if (field.getType().equals(Float.TYPE)) {
                field.setFloat(target, ((Float)value).floatValue());
                return;
            }
            if (field.getType().equals(Long.TYPE)) {
                field.setLong(target, (Long)value);
                return;
            }
            if (field.getType().equals(Double.TYPE)) {
                field.setDouble(target, (Double)value);
                return;
            }
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 179;
    }
}

