/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Normal;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.UnivariateFunction;
import jdistlib.math.opt.Optimization;
import jdistlib.rng.RandomEngine;

public class InvNormal
extends GenericDistribution {
    protected double mu;
    protected double sigma;

    public static final double density(double x, double mu, double sigma, boolean give_log) {
        if (Double.isNaN(mu) || Double.isNaN(sigma)) {
            return mu + sigma;
        }
        if (mu <= 0.0 || sigma <= 0.0) {
            return Double.NaN;
        }
        double v = (x / mu - 1.0) / sigma;
        x = -0.5 * Math.log(Math.PI * 2) - Math.log(sigma) - 1.0 * Math.log(x) - v * v / (2.0 * x);
        return give_log ? x : Math.exp(x);
    }

    public static final double cumulative(double q, double mu, double sigma, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(mu) || Double.isNaN(sigma)) {
            return mu + sigma;
        }
        if (mu <= 0.0 || sigma <= 0.0) {
            return Double.NaN;
        }
        double cdf1 = Normal.cumulative((q / mu - 1.0) / (sigma * Math.sqrt(q)), 0.0, 1.0, true, false);
        double lcdf2 = 2.0 / (mu * sigma * sigma) + Normal.cumulative(-(q / mu + 1.0) / (sigma * Math.sqrt(q)), 0.0, 1.0, true, true);
        q = cdf1 + Math.exp(lcdf2);
        if (!lower_tail) {
            q = 1.0 - q;
        }
        return log_p ? Math.log(q) : q;
    }

    public static final double quantile(double p, double mu, double sigma, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(mu) || Double.isNaN(sigma)) {
            return mu + sigma;
        }
        if (mu <= 0.0 || sigma <= 0.0 || p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (log_p) {
            p = Math.exp(p);
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        double ax = Double.MIN_NORMAL;
        double bx = mu;
        if (InvNormal.cumulative(mu, mu, sigma, true, false) < p) {
            ax = mu;
            int j = 1;
            while (!(InvNormal.cumulative(bx = mu + (double)j * sigma, mu, sigma, true, false) >= p)) {
                ++j;
            }
        }
        UnivariateFunction f = new UnivariateFunction(){
            double mu;
            double sigma;
            double p;

            public double eval(double x) {
                return InvNormal.cumulative(x, this.mu, this.sigma, true, false) - this.p;
            }

            public void setObjects(Object ... obj) {
            }

            public void setParameters(double ... params) {
                this.mu = params[0];
                this.sigma = params[1];
                this.p = params[2];
            }
        };
        f.setParameters(mu, sigma, p);
        return Optimization.zeroin(f, ax, bx, 0.0, 10000);
    }

    public static final double random(double mu, double sigma, RandomEngine random) {
        if (Double.isNaN(mu) || Double.isNaN(sigma)) {
            return mu + sigma;
        }
        if (mu <= 0.0 || sigma <= 0.0) {
            return Double.NaN;
        }
        return InvNormal.quantile(random.nextDouble(), mu, sigma, true, false);
    }

    public static final double[] random(int n, double mu, double sigma, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = InvNormal.random(mu, sigma, random);
            ++i;
        }
        return rand;
    }

    public InvNormal(double mu, double sigma) {
        this.mu = mu;
        this.sigma = sigma;
    }

    public double density(double x, boolean log) {
        return InvNormal.density(x, this.mu, this.sigma, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return InvNormal.cumulative(p, this.mu, this.sigma, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return InvNormal.quantile(q, this.mu, this.sigma, lower_tail, log_p);
    }

    public double random() {
        return InvNormal.random(this.mu, this.sigma, this.random);
    }
}

