/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.widget;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.intermine.webservice.client.core.ServiceFactory;

public class Widget {
    private final ServiceFactory factory;
    private final String name;
    private final String title;
    private final String description;
    private final String widgetType;
    private final String chartType;
    private final Set<String> targets;
    private final Set<String> filters;
    private final String xLabel;
    private final String yLabel;

    public Widget(ServiceFactory factory, String name, String title, String description, String widgetType, String chartType, Collection<String> targets, Collection<String> filters, String xLabel, String yLabel) {
        this.factory = factory;
        this.name = name;
        this.title = title;
        this.description = description;
        this.widgetType = widgetType;
        this.chartType = chartType;
        this.targets = Collections.unmodifiableSet(new HashSet<String>(targets));
        this.filters = Collections.unmodifiableSet(new HashSet<String>(filters));
        this.xLabel = xLabel;
        this.yLabel = yLabel;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWidgetType() {
        return this.widgetType;
    }

    public boolean isEnrichment() {
        return "enrichment".equals(this.widgetType);
    }

    public boolean isChart() {
        return "chart".equals(this.widgetType);
    }

    public String getChartType() {
        return this.chartType;
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public Set<String> getFilters() {
        return this.filters;
    }

    public String getXAxisLabel() {
        return this.xLabel;
    }

    public String getYAxisLabel() {
        return this.yLabel;
    }
}

