/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class URLParser {
    private URLParser() {
    }

    public static String parseServiceUrl(String url) throws MalformedURLException {
        URL webUrl = new URL(url);
        String port = webUrl.getPort() != -1 ? ":" + webUrl.getPort() : "";
        return webUrl.getProtocol() + "://" + webUrl.getHost() + port + webUrl.getPath();
    }

    public static Map<String, List<String>> parseParameterMap(String url) throws MalformedURLException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String query = new URL(url).getQuery();
        if (query != null) {
            String[] parts;
            for (String part : parts = query.split("&")) {
                if (URLParser.parseParameterName(part) == null) continue;
                URLParser.addParameter(map, URLParser.parseParameterName(part), URLParser.parseParameterValue(part));
            }
        }
        return map;
    }

    private static void addParameter(Map<String, List<String>> map, String name, String value) {
        List<String> values = map.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            map.put(name, values);
        }
        values.add(value);
    }

    private static String parseParameterValue(String str) {
        String[] parts = str.split("=", 2);
        if (parts.length == 2) {
            return parts[1];
        }
        if (parts.length == 1) {
            return "";
        }
        return null;
    }

    private static String parseParameterName(String str) {
        String[] parts = str.split("=", 2);
        if (parts.length >= 1) {
            return parts[0];
        }
        return null;
    }
}

