/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.intermine.webservice.client.core.ContentType;
import org.intermine.webservice.client.core.MultiPartRequest;
import org.intermine.webservice.client.core.Request;
import org.intermine.webservice.client.exceptions.BadRequestException;
import org.intermine.webservice.client.exceptions.InternalErrorException;
import org.intermine.webservice.client.exceptions.NotConnectedException;
import org.intermine.webservice.client.exceptions.NotImplementedException;
import org.intermine.webservice.client.exceptions.ResourceNotFoundException;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.exceptions.ServiceForbiddenException;
import org.intermine.webservice.client.exceptions.ServiceUnavailableException;

public class HttpConnection {
    private Request request;
    HttpMethodBase executedMethod;
    private int timeout;
    private boolean opened = false;

    public HttpConnection(Request request) {
        this.request = request;
    }

    public InputStream getResponseStream() {
        this.connect();
        try {
            return this.executedMethod.getResponseBodyAsStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Fatal transport error.", e);
        }
    }

    public void connect() {
        this.executeMethod();
        this.opened = true;
    }

    public String getResponseHeader(String name) {
        if (this.executedMethod == null) {
            this.throwNotConnectedException();
        }
        return this.executedMethod.getResponseHeader(name).getValue();
    }

    private void throwNotConnectedException() {
        throw new NotConnectedException();
    }

    public void close() {
        if (this.executedMethod != null) {
            this.executedMethod.releaseConnection();
            this.opened = false;
        }
    }

    private void executeMethod() {
        HttpClient client = new HttpClient();
        client.getParams().setConnectionManagerTimeout((long)this.timeout);
        String url = null;
        if (this.request.getType() == Request.RequestType.GET) {
            this.executedMethod = new GetMethod(this.request.getEncodedUrl());
        } else if (this.request.getType() == Request.RequestType.DELETE) {
            this.executedMethod = new DeleteMethod(this.request.getEncodedUrl());
        } else {
            PostMethod postMethod;
            if (this.request.getContentType() == ContentType.MULTI_PART_FORM) {
                postMethod = new PostMethod(this.request.getEncodedUrl());
                this.setMultiPartPostEntity(postMethod, (MultiPartRequest)this.request);
            } else {
                postMethod = new PostMethod(this.request.getServiceUrl());
                this.setPostMethodParameters(postMethod, this.request.getParameterMap());
            }
            this.executedMethod = postMethod;
        }
        this.executedMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        for (String name : this.request.getHeaders().keySet()) {
            this.executedMethod.setRequestHeader(name, this.request.getHeader(name));
        }
        try {
            client.executeMethod((HttpMethod)this.executedMethod);
            this.checkResponse();
        }
        catch (HttpException e) {
            throw new RuntimeException("Fatal protocol violation.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Fatal transport error connecting to " + url, e);
        }
    }

    private void setMultiPartPostEntity(PostMethod postMethod, MultiPartRequest req) {
        List<Part> parts = req.getParts();
        if (!parts.isEmpty()) {
            MultipartRequestEntity entity = new MultipartRequestEntity(req.getParts().toArray(new Part[1]), postMethod.getParams());
            postMethod.setRequestEntity((RequestEntity)entity);
        }
    }

    private void setPostMethodParameters(PostMethod postMethod, Map<String, List<String>> parameterMap) {
        for (String name : parameterMap.keySet()) {
            for (String value : parameterMap.get(name)) {
                postMethod.addParameter(name, value);
            }
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getResponseCode() {
        if (this.executedMethod == null) {
            this.throwNotConnectedException();
        }
        return this.executedMethod.getStatusCode();
    }

    public boolean isOpened() {
        return this.opened;
    }

    protected void checkResponse() {
        if (this.executedMethod.getStatusCode() >= 300) {
            try {
                this.handleErrorResponse();
            }
            catch (ServiceException e) {
                throw new ServiceException("Error while accessing " + this.request, e);
            }
            catch (IOException e) {
                throw new ServiceException("Error while accessing " + this.request, e);
            }
        }
    }

    protected void handleErrorResponse() throws IOException {
        String message = this.executedMethod.getResponseBodyAsString();
        switch (this.executedMethod.getStatusCode()) {
            case 404: {
                throw new ResourceNotFoundException(this);
            }
            case 400: {
                if (message != null) {
                    throw new BadRequestException(message);
                }
                throw new BadRequestException(this);
            }
            case 403: {
                if (message != null) {
                    throw new ServiceForbiddenException(message);
                }
                throw new ServiceForbiddenException(this);
            }
            case 501: {
                throw new NotImplementedException(this);
            }
            case 500: {
                if (message != null) {
                    throw new InternalErrorException(message);
                }
                throw new InternalErrorException(this);
            }
            case 503: {
                throw new ServiceUnavailableException(this);
            }
        }
        if (message != null) {
            throw new ServiceException(message);
        }
        throw new ServiceException(this);
    }

    public String getResponseBodyAsString() {
        if (this.executedMethod == null) {
            this.throwNotConnectedException();
        }
        String res = null;
        try {
            res = this.executedMethod.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        finally {
            this.executedMethod.releaseConnection();
        }
        return res;
    }

    public InputStream getResponseBodyAsStream() {
        if (this.executedMethod == null) {
            this.throwNotConnectedException();
        }
        try {
            return this.executedMethod.getResponseBodyAsStream();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }
}

