/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.services;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.intermine.webservice.client.core.ContentType;
import org.intermine.webservice.client.core.Request;
import org.intermine.webservice.client.core.RequestImpl;
import org.intermine.webservice.client.core.Service;
import org.intermine.webservice.client.core.ServiceFactory;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.util.HttpConnection;
import org.intermine.webservice.client.widget.Widget;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WidgetService
extends Service {
    private static final String SERVICE_RELATIVE_URL = "/widgets";

    public WidgetService(String rootUrl, String applicationName) {
        super(rootUrl, SERVICE_RELATIVE_URL, applicationName);
    }

    public List<Widget> getWidgets() {
        WidgetRequest request = new WidgetRequest(this.getUrl());
        return this.processWidgetRequest(request);
    }

    public Widget getWidget(String name) {
        List<Widget> widgets = this.getWidgets();
        for (Widget w : widgets) {
            if (!w.getName().equals(name)) continue;
            return w;
        }
        return null;
    }

    public List<Widget> getChartWidgets() {
        List<Widget> widgets = this.getWidgets();
        LinkedList<Widget> chartWidgets = new LinkedList<Widget>();
        for (Widget w : widgets) {
            if (!w.isChart()) continue;
            chartWidgets.add(w);
        }
        return chartWidgets;
    }

    public List<Widget> getEnrichmentWidgets() {
        List<Widget> widgets = this.getWidgets();
        LinkedList<Widget> enrichmentWidgets = new LinkedList<Widget>();
        for (Widget w : widgets) {
            if (!w.isEnrichment()) continue;
            enrichmentWidgets.add(w);
        }
        return enrichmentWidgets;
    }

    private List<Widget> processWidgetRequest(Request request) {
        HttpConnection connection = this.executeRequest(request);
        String body = connection.getResponseBodyAsString();
        try {
            JSONObject resultSet = new JSONObject(body);
            if (!resultSet.isNull("error")) {
                throw new ServiceException(resultSet.getString("error"));
            }
            JSONArray widgets = resultSet.getJSONArray("widgets");
            int length = widgets.length();
            ArrayList<Widget> ret = new ArrayList<Widget>();
            try {
                for (int i = 0; i < length; ++i) {
                    ret.add(this.parseWidget(this.getFactory(), widgets.getJSONObject(i)));
                }
            }
            catch (JSONException e) {
                throw new ServiceException("Error processing request: " + request + ", Incorrect JSON returned: '" + body + "'", e);
            }
            return ret;
        }
        catch (JSONException e) {
            throw new ServiceException("Error processing request: " + request + ", error parsing widget data: '" + body + "'", e);
        }
    }

    private Widget parseWidget(ServiceFactory factory, JSONObject json) throws JSONException {
        String name = json.getString("name");
        String title = json.getString("title");
        String description = json.getString("description");
        String widgetType = json.getString("widgetType");
        String chartType = json.optString("chartType", null);
        LinkedList<String> targets = new LinkedList<String>();
        JSONArray targetArray = json.getJSONArray("targets");
        int length = targetArray.length();
        for (int i = 0; i < length; ++i) {
            targets.add(targetArray.getString(i));
        }
        LinkedList<String> filters = new LinkedList<String>();
        JSONArray filterArray = json.getJSONArray("filters");
        length = filterArray.length();
        for (int i = 0; i < length; ++i) {
            filters.add(filterArray.getString(i));
        }
        JSONObject labels = json.optJSONObject("labels");
        String xLabel = labels == null ? null : labels.getString("x");
        String yLabel = labels == null ? null : labels.getString("y");
        return new Widget(factory, name, title, description, widgetType, chartType, targets, filters, xLabel, yLabel);
    }

    private static final class WidgetRequest
    extends RequestImpl {
        private WidgetRequest(String url) {
            super(Request.RequestType.GET, url, ContentType.APPLICATION_JSON);
        }
    }
}

