/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathException;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.template.xml.TemplateQueryBinding;
import org.intermine.webservice.client.core.ContentType;
import org.intermine.webservice.client.core.Request;
import org.intermine.webservice.client.core.RequestImpl;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.results.Page;
import org.intermine.webservice.client.results.RowResultSet;
import org.intermine.webservice.client.services.AbstractQueryService;
import org.intermine.webservice.client.template.TemplateParameter;
import org.intermine.webservice.client.util.HttpConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class TemplateService
extends AbstractQueryService<TemplateQuery> {
    private static final String SERVICE_RELATIVE_URL = "template/results";
    private static final String AVAILABLE_TEMPLATES = "/templates";

    public TemplateService(String rootUrl, String applicationName) {
        super(rootUrl, SERVICE_RELATIVE_URL, applicationName);
    }

    public Set<String> getTemplateNames() {
        RequestImpl request = new RequestImpl(Request.RequestType.GET, this.getRootUrl() + AVAILABLE_TEMPLATES, ContentType.TEXT_TAB);
        HttpConnection connection = this.executeRequest(request);
        HashSet<String> ret = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getResponseBodyAsStream()));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                ret.add(line);
            }
        }
        catch (IOException e) {
            throw new ServiceException("Reading from response stream failed", e);
        }
        finally {
            connection.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TemplateQuery> getTemplates() {
        Map res;
        this.getFactory().getModel();
        RequestImpl request = new RequestImpl(Request.RequestType.GET, this.getRootUrl() + AVAILABLE_TEMPLATES, ContentType.TEXT_XML);
        HttpConnection connection = this.executeRequest(request);
        try {
            res = TemplateQueryBinding.unmarshalTemplates((Reader)new InputStreamReader(connection.getResponseBodyAsStream()), (int)2);
        }
        finally {
            connection.close();
        }
        return res;
    }

    public TemplateQuery getTemplate(String name) {
        return this.getTemplates().get(name);
    }

    public Set<TemplateQuery> getTemplatesForType(String type) {
        if (type == null) {
            throw new NullPointerException("'type' is null in getTemplatesForType");
        }
        Model m = this.getFactory().getModel();
        Map<String, TemplateQuery> templates = this.getTemplates();
        HashSet<TemplateQuery> res = new HashSet<TemplateQuery>();
        block2: for (TemplateQuery tq : templates.values()) {
            for (PathConstraint c : tq.getConstraints().keySet()) {
                Path p;
                try {
                    p = tq.makePath(c.getPath());
                }
                catch (PathException e) {
                    throw new ServiceException(e);
                }
                ClassDescriptor cd = p.getLastClassDescriptor();
                if (!type.equals(cd.getUnqualifiedName()) && !m.getClassDescriptorByName(type).getAllSuperDescriptors().contains(cd)) continue;
                res.add(tq);
                continue block2;
            }
        }
        return res;
    }

    public int getCount(String templateName, List<TemplateParameter> parameters) {
        TemplateRequest request = new TemplateRequest(Request.RequestType.POST, this.getUrl(), ContentType.TEXT_COUNT);
        request.setName(templateName);
        request.setTemplateParameters(parameters);
        String body = this.getStringResponse(request);
        if (body.length() == 0) {
            throw new ServiceException("The server didn't return any results");
        }
        try {
            return Integer.parseInt(body);
        }
        catch (NumberFormatException e) {
            throw new ServiceException("The server returned an invalid result. It is not a number: " + body, e);
        }
    }

    @Override
    public int getCount(TemplateQuery template) {
        List<TemplateParameter> parameters = this.getParametersFor(template);
        return this.getCount(template.getName(), parameters);
    }

    private List<TemplateParameter> getParametersFor(TemplateQuery template) {
        ArrayList<TemplateParameter> params = new ArrayList<TemplateParameter>();
        for (PathConstraint pc : template.getEditableConstraints()) {
            if (template.getSwitchOffAbility(pc) == SwitchOffAbility.OFF) continue;
            TemplateParameter tp = new TemplateParameter(pc.getPath(), pc.getOp().toString(), PathConstraint.getValue((PathConstraint)pc));
            String extraValue = PathConstraint.getExtraValue((PathConstraint)pc);
            if (extraValue != null) {
                tp.setExtraValue(extraValue);
            }
            params.add(tp);
        }
        return params;
    }

    public List<List<String>> getAllResults(String templateName, List<TemplateParameter> parameters) {
        return this.getResults(templateName, parameters, Page.DEFAULT);
    }

    public List<List<String>> getResults(String templateName, List<TemplateParameter> parameters, Page page) {
        TemplateRequest request = new TemplateRequest(Request.RequestType.POST, this.getUrl(), ContentType.TEXT_XML);
        request.setName(templateName);
        request.setTemplateParameters(parameters);
        request.setPage(page);
        return this.getResponseTable(request).getData();
    }

    @Override
    public List<List<String>> getResults(TemplateQuery template, Page page) {
        List<TemplateParameter> parameters = this.getParametersFor(template);
        return this.getResults(template.getName(), parameters, page);
    }

    public List<JSONObject> getAllJSONResults(String templateName, List<TemplateParameter> parameters) throws JSONException {
        return this.getJSONResults(templateName, parameters, Page.DEFAULT);
    }

    public List<JSONObject> getJSONResults(String templateName, List<TemplateParameter> parameters, Page page) throws JSONException {
        TemplateRequest request = new TemplateRequest(Request.RequestType.POST, this.getUrl(), ContentType.APPLICATION_JSON_OBJ);
        request.setName(templateName);
        request.setTemplateParameters(parameters);
        request.setPage(page);
        return this.getJSONResponse(request).getObjects();
    }

    @Override
    public List<JSONObject> getJSONResults(TemplateQuery template, Page page) throws JSONException {
        List<TemplateParameter> parameters = this.getParametersFor(template);
        return this.getJSONResults(template.getName(), parameters, page);
    }

    public Iterator<List<String>> getAllRowsIterator(String templateName, List<TemplateParameter> parameters) {
        return this.getRowIterator(templateName, parameters, Page.DEFAULT);
    }

    public Iterator<List<String>> getRowIterator(String templateName, List<TemplateParameter> parameters, Page page) {
        TemplateRequest request = new TemplateRequest(Request.RequestType.POST, this.getUrl(), ContentType.TEXT_XML);
        request.setName(templateName);
        request.setTemplateParameters(parameters);
        request.setPage(page);
        return this.getResponseTable(request).getIterator();
    }

    @Override
    public Iterator<List<String>> getRowIterator(TemplateQuery template, Page page) {
        List<TemplateParameter> parameters = this.getParametersFor(template);
        return this.getRowIterator(template.getName(), parameters, page);
    }

    public List<List<Object>> getRowsAsLists(String name, List<TemplateParameter> params, Page page) {
        return this.getRows(name, params, page).getRowsAsLists();
    }

    public List<List<Object>> getRowsAsLists(String name, List<TemplateParameter> params) {
        return this.getRows(name, params, Page.DEFAULT).getRowsAsLists();
    }

    public List<Map<String, Object>> getRowsAsMaps(String name, List<TemplateParameter> params, Page page) {
        return this.getRows(name, params, page).getRowsAsMaps();
    }

    public List<Map<String, Object>> getRowsAsMaps(String name, List<TemplateParameter> params) {
        return this.getRows(name, params, Page.DEFAULT).getRowsAsMaps();
    }

    public Iterator<List<Object>> getRowListIterator(String name, List<TemplateParameter> params, Page page) {
        return this.getRows(name, params, page).getListIterator();
    }

    public Iterator<List<Object>> getRowListIterator(String name, List<TemplateParameter> params) {
        return this.getRows(name, params, Page.DEFAULT).getListIterator();
    }

    public Iterator<Map<String, Object>> getRowMapIterator(String name, List<TemplateParameter> params, Page page) {
        return this.getRows(name, params, page).getMapIterator();
    }

    public Iterator<Map<String, Object>> getRowMapIterator(String name, List<TemplateParameter> params) {
        return this.getRows(name, params, Page.DEFAULT).getMapIterator();
    }

    private RowResultSet getRows(String name, List<TemplateParameter> params, Page page) {
        TemplateQuery tq = this.getTemplate(name);
        if (tq == null) {
            throw new ServiceException("There is no template named " + name);
        }
        return this.getRows(name, params, tq.getView(), page);
    }

    @Override
    protected RowResultSet getRows(TemplateQuery query, Page page) {
        List<TemplateParameter> parameters = this.getParametersFor(query);
        return this.getRows(query.getName(), parameters, query.getView(), page);
    }

    private RowResultSet getRows(String name, List<TemplateParameter> params, List<String> views, Page page) {
        TemplateRequest request = new TemplateRequest(Request.RequestType.POST, this.getUrl(), ContentType.APPLICATION_JSON_ROW);
        request.setName(name);
        request.setTemplateParameters(params);
        return this.getRows(request, views);
    }

    protected static class TemplateRequest
    extends RequestImpl {
        public TemplateRequest(Request.RequestType type, String serviceUrl, ContentType contentType) {
            super(type, serviceUrl, contentType);
        }

        public void setName(String xml) {
            this.setParameter("name", xml);
        }

        public void setTemplateParameters(List<TemplateParameter> parameters) {
            for (int i = 0; i < parameters.size(); ++i) {
                TemplateParameter par = parameters.get(i);
                int index = i + 1;
                this.addParameter("constraint" + index, par.getPathId());
                this.addParameter("op" + index, par.getOperation());
                this.addParameter("value" + index, par.getValue());
                if (par.getExtraValue() != null) {
                    this.addParameter("extra" + index, par.getExtraValue());
                }
                if (par.getCode() == null) continue;
                this.addParameter("code" + index, par.getCode());
            }
        }
    }
}

