/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.services;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.webservice.client.core.ContentType;
import org.intermine.webservice.client.core.Request;
import org.intermine.webservice.client.core.RequestImpl;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.results.JSONResult;
import org.intermine.webservice.client.results.Page;
import org.intermine.webservice.client.results.RowResultSet;
import org.intermine.webservice.client.results.XMLTableResult;
import org.intermine.webservice.client.services.AbstractQueryService;
import org.intermine.webservice.client.services.ModelService;
import org.json.JSONException;
import org.json.JSONObject;

public class QueryService
extends AbstractQueryService<PathQuery> {
    private static final String SERVICE_RELATIVE_URL = "query/results";
    private static final Set<String> NUMERIC_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("int", "float", "double", "short", "long", "java.util.Integer", "java.util.Float", "java.util.Double", "java.util.Short", "java.util.Long", "java.util.BegDecimal")));

    public QueryService(String rootUrl, String applicationName) {
        super(rootUrl, SERVICE_RELATIVE_URL, applicationName);
    }

    public PathQuery createPathQuery(String queryXml) {
        ModelService modelService = new ModelService(this.getRootUrl(), this.getApplicationName());
        Model model = modelService.getModel();
        Model.addModel((String)model.getName(), (Model)model);
        return PathQueryBinding.unmarshalPathQuery((Reader)new StringReader(queryXml), (int)2);
    }

    @Override
    public int getCount(PathQuery query) {
        return this.getCount(query.toXml());
    }

    @Override
    public int getCount(String queryXml) {
        QueryRequest request = new QueryRequest(Request.RequestType.POST, this.getUrl(), ContentType.TEXT_COUNT);
        request.setQueryXml(queryXml);
        String body = this.getStringResponse(request);
        if (body.length() == 0) {
            throw new ServiceException("The server didn't return any results");
        }
        try {
            return Integer.parseInt(body);
        }
        catch (NumberFormatException e) {
            throw new ServiceException("The server returned an invalid result. It is not a number: " + body, e);
        }
    }

    @Override
    public List<JSONObject> getAllJSONResults(String queryXml) throws JSONException {
        return this.getJSONResults(queryXml, Page.DEFAULT);
    }

    @Override
    public List<JSONObject> getJSONResults(PathQuery query, Page page) throws JSONException {
        return this.getJSONResults(query.toXml(), page);
    }

    @Override
    public List<JSONObject> getJSONResults(String queryXml, Page page) throws JSONException {
        QueryRequest request = new QueryRequest(Request.RequestType.POST, this.getUrl(), ContentType.APPLICATION_JSON_OBJ);
        request.setQueryXml(queryXml);
        request.setPage(page);
        JSONResult response = this.getJSONResponse(request);
        return response.getObjects();
    }

    @Override
    public List<List<String>> getResults(PathQuery query, Page page) {
        return this.getResultInternal(query.toXml(), page).getData();
    }

    @Override
    public List<List<String>> getResults(String queryXml, Page page) {
        return this.getResultInternal(queryXml, page).getData();
    }

    @Override
    public List<List<String>> getAllResults(String queryXml) {
        return this.getResultInternal(queryXml, Page.DEFAULT).getData();
    }

    @Override
    public Iterator<List<String>> getRowIterator(PathQuery query, Page page) {
        return this.getResultInternal(query.toXml(), page).getIterator();
    }

    @Override
    public Iterator<List<String>> getRowIterator(String queryXml, Page page) {
        return this.getResultInternal(queryXml, page).getIterator();
    }

    public Iterator<List<String>> getAllRowIterator(String queryXml) {
        return this.getRowIterator(queryXml, Page.DEFAULT);
    }

    private XMLTableResult getResultInternal(String queryXml, Page page) {
        QueryRequest request = new QueryRequest(Request.RequestType.POST, this.getUrl(), ContentType.TEXT_XML);
        request.setPage(page);
        request.setQueryXml(queryXml);
        return this.getResponseTable(request);
    }

    @Override
    public List<List<Object>> getRowsAsLists(String query, Page page) {
        return this.getRows(query, page).getRowsAsLists();
    }

    @Override
    public List<List<Object>> getRowsAsLists(String query) {
        return this.getRows(query, Page.DEFAULT).getRowsAsLists();
    }

    @Override
    public List<Map<String, Object>> getRowsAsMaps(String query, Page page) {
        return this.getRows(query, page).getRowsAsMaps();
    }

    @Override
    public List<Map<String, Object>> getRowsAsMaps(String query) {
        return this.getRows(query, Page.DEFAULT).getRowsAsMaps();
    }

    @Override
    public Iterator<List<Object>> getRowListIterator(String query, Page page) {
        return this.getRows(query, page).getListIterator();
    }

    @Override
    public Iterator<List<Object>> getRowListIterator(String query) {
        return this.getRows(query, Page.DEFAULT).getListIterator();
    }

    @Override
    public Iterator<Map<String, Object>> getRowMapIterator(String query, Page page) {
        return this.getRows(query, page).getMapIterator();
    }

    @Override
    public Iterator<Map<String, Object>> getRowMapIterator(String query) {
        return this.getRows(query, Page.DEFAULT).getMapIterator();
    }

    @Override
    private RowResultSet getRows(String query, Page page) {
        PathQuery pq = this.createPathQuery(query);
        return this.getRows(pq, page);
    }

    @Override
    protected RowResultSet getRows(PathQuery query, Page page) {
        List views = query.getView();
        String queryXml = query.toXml(2);
        QueryRequest request = new QueryRequest(Request.RequestType.POST, this.getUrl(), ContentType.APPLICATION_JSON_ROW);
        request.setPage(page);
        request.setQueryXml(queryXml);
        return this.getRows(request, views);
    }

    public NumericSummary getNumericSummary(PathQuery query, String summaryPath) {
        try {
            if (!summaryPath.startsWith(query.getRootClass())) {
                summaryPath = query.getRootClass() + "." + summaryPath;
            }
        }
        catch (PathException e) {
            throw new ServiceException("Error with query", e);
        }
        Path p = null;
        try {
            p = query.makePath(summaryPath);
        }
        catch (PathException e) {
            throw new ServiceException("while requesting numeric summary information", e);
        }
        FieldDescriptor fd = p.getEndFieldDescriptor();
        if (!fd.isAttribute()) {
            throw new ServiceException(summaryPath + " does not describe an attribute");
        }
        String dataType = ((AttributeDescriptor)fd).getType();
        if (!NUMERIC_TYPES.contains(dataType)) {
            throw new ServiceException(summaryPath + " does not represent a numeric column");
        }
        QueryRequest request = new QueryRequest(Request.RequestType.POST, this.getUrl(), ContentType.APPLICATION_JSON_ROW);
        request.setQueryXml(query.toXml());
        request.setParameter("summaryPath", summaryPath);
        JSONResult response = this.getJSONResponse(request);
        try {
            return new NumericSummary(summaryPath, response.getObjects().get(0));
        }
        catch (JSONException e) {
            throw new ServiceException("Error parsing JSON response", e);
        }
    }

    public Map<String, Integer> getSummary(PathQuery query, String summaryPath) {
        return this.getSummary(query, summaryPath, Page.DEFAULT);
    }

    public Map<String, Integer> getSummary(PathQuery query, String summaryPath, Page page) {
        try {
            if (!summaryPath.startsWith(query.getRootClass())) {
                summaryPath = query.getRootClass() + "." + summaryPath;
            }
        }
        catch (PathException e) {
            throw new ServiceException("Error with query", e);
        }
        Path p = null;
        try {
            p = query.makePath(summaryPath);
        }
        catch (PathException e) {
            throw new ServiceException("while requesting numeric summary information", e);
        }
        FieldDescriptor fd = p.getEndFieldDescriptor();
        if (!fd.isAttribute()) {
            throw new ServiceException(summaryPath + " does not describe an attribute");
        }
        String dataType = ((AttributeDescriptor)fd).getType();
        if (NUMERIC_TYPES.contains(dataType)) {
            throw new ServiceException(summaryPath + " represents a numeric column");
        }
        QueryRequest request = new QueryRequest(Request.RequestType.POST, this.getUrl(), ContentType.APPLICATION_JSON_ROW);
        request.setQueryXml(query.toXml());
        request.setPage(page);
        request.setParameter("summaryPath", summaryPath);
        JSONResult response = this.getJSONResponse(request);
        LinkedHashMap<String, Integer> ret = new LinkedHashMap<String, Integer>();
        try {
            Iterator<JSONObject> it = response.getIterator();
            while (it.hasNext()) {
                JSONObject record = it.next();
                ret.put(record.getString("item"), record.getInt("count"));
            }
        }
        catch (JSONException e) {
            throw new ServiceException("Error parsing JSON response", e);
        }
        return ret;
    }

    public static final class NumericSummary {
        private final String column;
        private final double average;
        private final double max;
        private final double min;
        private final double standardDeviation;

        private NumericSummary(String name, JSONObject data) throws JSONException {
            this.column = name;
            this.average = data.getDouble("average");
            this.max = data.getDouble("max");
            this.min = data.getDouble("min");
            this.standardDeviation = data.getDouble("stdev");
        }

        public String getColumn() {
            return this.column;
        }

        public double getAverage() {
            return this.average;
        }

        public double getMax() {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }

        public double getStandardDeviation() {
            return this.standardDeviation;
        }
    }

    protected static class QueryRequest
    extends RequestImpl {
        public QueryRequest(Request.RequestType type, String serviceUrl, ContentType contentType) {
            super(type, serviceUrl, contentType);
        }

        public void setQueryXml(String xml) {
            this.setParameter("query", xml);
        }
    }
}

