/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.services;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.intermine.metadata.Model;
import org.intermine.modelproduction.xml.InterMineModelParser;
import org.intermine.webservice.client.core.ContentType;
import org.intermine.webservice.client.core.Request;
import org.intermine.webservice.client.core.RequestImpl;
import org.intermine.webservice.client.core.Service;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.util.HttpConnection;

public class ModelService
extends Service {
    private static final String SERVICE_RELATIVE_URL = "model";
    private static Map<String, Model> models = new HashMap<String, Model>();

    public ModelService(String rootUrl, String applicationName) {
        super(rootUrl, SERVICE_RELATIVE_URL, applicationName);
    }

    public Model getModel() {
        String key = this.getRootUrl();
        Model model = models.get(key);
        if (model == null) {
            model = this.fetchModel();
            model.setGeneratedClassesAvailable(false);
            models.put(key, model);
            Model.addModel((String)model.getName(), (Model)model);
        }
        return model;
    }

    private Model fetchModel() {
        String modelXml = this.getModelXml();
        Model model = null;
        try {
            model = new InterMineModelParser().process((Reader)new StringReader(modelXml));
        }
        catch (Exception e) {
            throw new ServiceException("Error occured during parsing model XML", e);
        }
        return model;
    }

    protected String getModelXml() {
        RequestImpl request = new RequestImpl(Request.RequestType.GET, this.getUrl(), ContentType.TEXT_PLAIN);
        HttpConnection connection = this.executeRequest(request);
        return connection.getResponseBodyAsString();
    }
}

