/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.services;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.client.core.ContentType;
import org.intermine.webservice.client.core.MultiPartRequest;
import org.intermine.webservice.client.core.Request;
import org.intermine.webservice.client.core.RequestImpl;
import org.intermine.webservice.client.core.Service;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.lists.ItemList;
import org.intermine.webservice.client.lists.Lists;
import org.intermine.webservice.client.results.Item;
import org.intermine.webservice.client.util.HttpConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListService
extends Service {
    private static final String SERVICE_RELATIVE_URL = "listswithobject/json";
    private static final String LISTS_PATH = "/lists/json";
    private static final String QUERY_LISTS_PATH = "/query/tolist/json";
    private static final String LIST_APPEND_PATH = "/lists/append/json";
    private static final String MERGE_PATH = "/lists/union/json";
    private static final String QUERY_APPEND_PATH = "/query/append/tolist/json";
    private static final String INTERSECT_PATH = "/lists/intersect/json";
    private static final String DIFF_PATH = "/lists/diff/json";
    private static final String SUBTRACT_PATH = "/lists/subtract/json";
    private static final String RENAME_PATH = "/lists/rename/json";
    private static final String TAGS = "/list/tags/json";

    public ListService(String rootUrl, String applicationName) {
        super(rootUrl, SERVICE_RELATIVE_URL, applicationName);
    }

    public List<ItemList> getListsWithObject(String publicId, String type) {
        ListRequest request = new ListRequest(Request.RequestType.POST, this.getUrl(), ContentType.APPLICATION_JSON);
        request.setPublicId(publicId);
        request.setObjectType(type);
        return this.processListsRequest(request);
    }

    public List<ItemList> getListsWithObject(int id) {
        ListRequest request = new ListRequest(Request.RequestType.POST, this.getUrl(), ContentType.APPLICATION_JSON);
        request.setDatabaseId(Integer.toString(id));
        return this.processListsRequest(request);
    }

    public Map<String, ItemList> getListMap() {
        List<ItemList> lists = this.getAccessibleLists();
        TreeMap<String, ItemList> listMap = new TreeMap<String, ItemList>();
        for (ItemList list : lists) {
            listMap.put(list.getName(), list);
        }
        return listMap;
    }

    public ItemList getList(String name) {
        return this.getListMap().get(name);
    }

    public List<ItemList> getAccessibleLists() {
        ListRequest request = new ListRequest(Request.RequestType.GET, this.getRootUrl() + LISTS_PATH, ContentType.APPLICATION_JSON);
        return this.processListsRequest(request);
    }

    public ItemList createList(ListCreationInfo info) {
        if (info.type == null) {
            return this.processListCreationRequest(this.getQueryToListRequest(info));
        }
        return this.processListCreationRequest(this.getIdsToListRequest(info));
    }

    public ItemList append(ItemList list, String ... ids) {
        CreationRequest request = new CreationRequest(this.getRootUrl() + LIST_APPEND_PATH);
        request.setParameter("name", list.getName());
        StringBuffer sb = new StringBuffer();
        for (String id : ids) {
            sb.append("\"" + id + "\"\n");
        }
        request.addContents(sb.toString());
        return this.processListCreationRequest(request);
    }

    public ItemList append(ItemList list, Collection<? extends String> ids) {
        return this.append(list, ids.toArray(new String[ids.size()]));
    }

    public ItemList append(ItemList list, PathQuery query) {
        ListRequest request = new ListRequest(Request.RequestType.POST, this.getRootUrl() + QUERY_APPEND_PATH, ContentType.APPLICATION_JSON);
        request.setParameter("listName", list.getName());
        request.setParameter("query", query.toXml());
        return this.processListCreationRequest(request);
    }

    public void deleteList(ItemList delendum) {
        ListRequest request = new ListRequest(Request.RequestType.DELETE, this.getRootUrl() + LISTS_PATH, ContentType.APPLICATION_JSON);
        request.addParameter("name", delendum.getName());
        HttpConnection con = this.executeRequest(request);
        String body = con.getResponseBodyAsString();
        ItemList deleted = Lists.parseListCreationInfo(this.getFactory(), body);
        if (!deleted.getName().equals(delendum.getName())) {
            throw new ServiceException("You asked me to delete " + delendum + ", but the server deleted " + deleted);
        }
    }

    public ItemList merge(ItemList ... lists) {
        return this.merge(new ListOperationInfo(), Arrays.asList(lists));
    }

    public ItemList merge(ListOperationInfo info, ItemList ... lists) {
        return this.merge(info, Arrays.asList(lists));
    }

    public ItemList merge(Collection<ItemList> lists) {
        return this.merge(new ListOperationInfo(), lists);
    }

    public ItemList merge(ListOperationInfo info, Collection<ItemList> lists) {
        ListRequest request = new ListRequest(Request.RequestType.POST, this.getRootUrl() + MERGE_PATH, ContentType.APPLICATION_JSON);
        return this.processCommutativeOperation(request, info, lists);
    }

    public ItemList intersect(ItemList ... lists) {
        return this.intersect(new ListOperationInfo(), Arrays.asList(lists));
    }

    public ItemList intersect(ListOperationInfo info, ItemList ... lists) {
        return this.intersect(info, Arrays.asList(lists));
    }

    public ItemList intersect(Collection<ItemList> lists) {
        return this.intersect(new ListOperationInfo(), lists);
    }

    public ItemList intersect(ListOperationInfo info, Collection<ItemList> lists) {
        ListRequest request = new ListRequest(Request.RequestType.POST, this.getRootUrl() + INTERSECT_PATH, ContentType.APPLICATION_JSON);
        return this.processCommutativeOperation(request, info, lists);
    }

    public ItemList diff(ItemList ... lists) {
        return this.diff(new ListOperationInfo(), Arrays.asList(lists));
    }

    public ItemList diff(ListOperationInfo info, ItemList ... lists) {
        return this.diff(info, Arrays.asList(lists));
    }

    public ItemList diff(Collection<ItemList> lists) {
        return this.diff(new ListOperationInfo(), lists);
    }

    public ItemList diff(ListOperationInfo info, Collection<ItemList> lists) {
        ListRequest request = new ListRequest(Request.RequestType.POST, this.getRootUrl() + DIFF_PATH, ContentType.APPLICATION_JSON);
        return this.processCommutativeOperation(request, info, lists);
    }

    public ItemList subtract(ListOperationInfo info, ItemList from, ItemList ... lists) {
        return this.subtract(info, Arrays.asList(from), Arrays.asList(lists));
    }

    public ItemList subtract(ListOperationInfo info, ItemList[] from, ItemList ... lists) {
        return this.subtract(info, Arrays.asList(from), Arrays.asList(lists));
    }

    public ItemList subtract(ItemList from, ItemList ... lists) {
        return this.subtract(Arrays.asList(from), Arrays.asList(lists));
    }

    public ItemList subtract(ItemList[] from, ItemList ... lists) {
        return this.subtract(Arrays.asList(from), Arrays.asList(lists));
    }

    public ItemList subtract(Collection<ItemList> from, Collection<ItemList> lists) {
        return this.subtract(new ListOperationInfo(), from, lists);
    }

    public ItemList subtract(ListOperationInfo info, Collection<ItemList> x, Collection<ItemList> y) {
        ListRequest request = new ListRequest(Request.RequestType.POST, this.getRootUrl() + SUBTRACT_PATH, ContentType.APPLICATION_JSON);
        this.applyListOperationParameters(request, info);
        request.setParameter("references", StringUtils.join((Collection)CollectionUtils.collect(x, (Transformer)TransformerUtils.invokerTransformer((String)"getName")), (char)';'));
        request.setParameter("subtract", StringUtils.join((Collection)CollectionUtils.collect(y, (Transformer)TransformerUtils.invokerTransformer((String)"getName")), (char)';'));
        return this.processListCreationRequest(request);
    }

    public ItemList rename(ItemList list, String newName) {
        ListRequest request = new ListRequest(Request.RequestType.POST, this.getRootUrl() + RENAME_PATH, ContentType.APPLICATION_JSON);
        request.setParameter("oldname", list.getName());
        request.setParameter("newname", newName);
        return this.processListCreationRequest(request);
    }

    public boolean contains(ItemList list, Item ... items) {
        PathQuery pq = new PathQuery(this.getFactory().getModel());
        pq.addView(list.getType() + ".id");
        HashSet<String> ids = new HashSet<String>();
        for (Item i : items) {
            ids.add(Integer.toString(i.getId()));
        }
        pq.addConstraint((PathConstraint)Constraints.oneOfValues((String)(list.getType() + ".id"), ids));
        pq.addConstraint((PathConstraint)Constraints.in((String)list.getType(), (String)list.getName()));
        int count = this.getFactory().getQueryService().getCount(pq);
        return ids.size() == count;
    }

    private List<ItemList> processListsRequest(Request request) {
        HttpConnection connection = this.executeRequest(request);
        String body = connection.getResponseBodyAsString();
        try {
            JSONObject resultSet = new JSONObject(body);
            if (!resultSet.isNull("error")) {
                throw new ServiceException(resultSet.getString("error"));
            }
            JSONArray lists = resultSet.getJSONArray("lists");
            int length = lists.length();
            ArrayList<ItemList> ret = new ArrayList<ItemList>();
            try {
                for (int i = 0; i < length; ++i) {
                    ret.add(Lists.parseList(this.getFactory(), lists.getJSONObject(i)));
                }
            }
            catch (JSONException e) {
                throw new ServiceException("Error processing request: " + request + ", Incorrect JSON returned: '" + body + "'", e);
            }
            return ret;
        }
        catch (JSONException e) {
            throw new ServiceException("Error processing request: " + request + ", error parsing list data: '" + body + "'", e);
        }
    }

    private Request getIdsToListRequest(ListCreationInfo info) {
        CreationRequest request = new CreationRequest(this.getRootUrl() + LISTS_PATH);
        this.applyListOperationParameters(request, info);
        request.setParameter("type", info.type);
        if (info.fileSrc != null) {
            try {
                request.addContents(info.fileSrc);
            }
            catch (FileNotFoundException e) {
                throw new ServiceException("while constructing list:", e);
            }
        } else if (info.ids != null) {
            request.addContents(info.ids);
        } else {
            throw new ServiceException("No content specified");
        }
        return request;
    }

    private Request getQueryToListRequest(ListCreationInfo info) {
        ListRequest request = new ListRequest(Request.RequestType.POST, this.getRootUrl() + QUERY_LISTS_PATH, ContentType.APPLICATION_JSON);
        request.setParameter("listName", info.name);
        request.setParameter("description", info.description);
        request.setParameter("query", info.querySrc.toXml());
        request.setParameter("tags", info.getTagString());
        return request;
    }

    private ItemList processCommutativeOperation(Request request, ListOperationInfo info, Collection<ItemList> lists) {
        this.applyListOperationParameters(request, info);
        request.setParameter("lists", StringUtils.join((Collection)CollectionUtils.collect(lists, (Transformer)TransformerUtils.invokerTransformer((String)"getName")), (char)';'));
        return this.processListCreationRequest(request);
    }

    private void applyListOperationParameters(Request request, ListOperationInfo info) {
        request.setParameter("name", info.name);
        request.setParameter("description", info.description);
        request.setParameter("tags", info.getTagString());
    }

    private ItemList processListCreationRequest(Request request) {
        HttpConnection con = this.executeRequest(request);
        String body = con.getResponseBodyAsString();
        ItemList created = Lists.parseListCreationInfo(this.getFactory(), body);
        ItemList onServer = this.getList(created.getName());
        onServer.addUnmatchedIds(created.getUnmatchedIdentifiers());
        return onServer;
    }

    public List<String> getTags(ItemList itemList) {
        RequestImpl request = new RequestImpl(Request.RequestType.GET, this.getRootUrl() + TAGS, ContentType.APPLICATION_JSON);
        request.setParameter("name", itemList.getName());
        return this.handleTagRequest(request);
    }

    public List<String> addTags(ItemList itemList, String ... newTags) {
        RequestImpl request = new RequestImpl(Request.RequestType.POST, this.getRootUrl() + TAGS, ContentType.APPLICATION_JSON);
        request.setParameter("name", itemList.getName());
        request.setParameter("tags", StringUtils.join((Object[])newTags, (char)';'));
        return this.handleTagRequest(request);
    }

    public List<String> removeTags(ItemList itemList, String ... removeThese) {
        RequestImpl request = new RequestImpl(Request.RequestType.DELETE, this.getRootUrl() + TAGS, ContentType.APPLICATION_JSON);
        request.setParameter("name", itemList.getName());
        request.setParameter("tags", StringUtils.join((Object[])removeThese, (char)';'));
        return this.handleTagRequest(request);
    }

    private List<String> handleTagRequest(Request request) {
        HttpConnection con = this.executeRequest(request);
        ArrayList<String> ret = new ArrayList<String>();
        String body = null;
        try {
            body = con.getResponseBodyAsString();
            JSONObject jo = new JSONObject(body);
            if (!jo.isNull("error")) {
                throw new ServiceException(jo.getString("error"));
            }
            JSONArray tags = jo.getJSONArray("tags");
            for (int i = 0; i < tags.length(); ++i) {
                ret.add(tags.getString(i));
            }
        }
        catch (JSONException e) {
            throw new ServiceException("while parsing response: " + body, e);
        }
        finally {
            con.close();
        }
        return ret;
    }

    public class ListCreationInfo
    extends ListOperationInfo {
        String type;
        String ids;
        File fileSrc;
        PathQuery querySrc;

        public ListCreationInfo(String type) {
            this.type = type;
        }

        public ListCreationInfo(PathQuery pq) {
            this.setContent(pq);
        }

        public ListCreationInfo(PathQuery pq, String name) {
            super(name);
            this.setContent(pq);
        }

        public ListCreationInfo(String type, String name) {
            super(name);
            this.type = type;
        }

        public ListCreationInfo(PathQuery pq, String name, String description) {
            super(name, description);
            this.setContent(pq);
        }

        public ListCreationInfo(String type, String name, String description) {
            super(name, description);
            this.type = type;
        }

        public ListCreationInfo(PathQuery pq, String name, String description, Collection<? extends String> tags) {
            super(name, description, tags);
            this.setContent(pq);
        }

        public ListCreationInfo(String type, String name, String description, Collection<? extends String> tags) {
            super(name, description, tags);
            this.type = type;
        }

        public void setContent(File ids) {
            this.fileSrc = ids;
        }

        public void setContent(InputStream is) throws IOException {
            this.ids = IOUtils.toString((InputStream)is);
        }

        public void setContent(Collection<String> ids) {
            StringBuffer sb = new StringBuffer();
            for (String s : ids) {
                sb.append("\"" + s + "\"\n");
            }
            this.ids = sb.toString();
        }

        public void setContent(String ... identifiers) {
            this.setContent(Arrays.asList(identifiers));
        }

        public void setContent(String ids) {
            this.ids = ids;
        }

        public void setContent(PathQuery pq) {
            this.querySrc = pq;
        }
    }

    public class ListOperationInfo {
        private static final String DEFAULT_DESCRIPTION = "Created with Java Webservice-Client";
        private static final String BASE_NAME = "my-list";
        String type;
        String name;
        String description = "Created with Java Webservice-Client";
        final Set<String> tags = new HashSet<String>();

        public ListOperationInfo() {
            this.name = this.getUnusedListName();
        }

        public ListOperationInfo(String name) {
            this.name = name;
        }

        public ListOperationInfo(String name, String description) {
            this(name);
            this.description = description;
        }

        public ListOperationInfo(String name, String description, Collection<? extends String> tags) {
            this(name, description);
            this.tags.addAll(tags);
        }

        public void addTag(String tag) {
            this.tags.add(tag);
        }

        public void addTags(Collection<? extends String> tags) {
            this.tags.addAll(tags);
        }

        public String getTagString() {
            return StringUtils.join(this.tags, (char)';');
        }

        protected String getUnusedListName() {
            Set<String> usedNames = ListService.this.getListMap().keySet();
            String newName = BASE_NAME;
            int counter = 0;
            while (usedNames.contains(newName)) {
                newName = "my-list-" + ++counter;
            }
            return newName;
        }
    }

    private static class CreationRequest
    extends MultiPartRequest {
        public CreationRequest(String url) {
            super(url);
        }

        public void addContents(File contents) throws FileNotFoundException {
            this.getParts().add((Part)new FilePart("identifiers", contents.getName(), contents));
        }

        public void addContents(String content) {
            this.getParts().add((Part)new FilePart("identifiers", (PartSource)new ByteArrayPartSource("ids.txt", content.getBytes())));
        }
    }

    private static class ListRequest
    extends RequestImpl {
        public ListRequest(Request.RequestType type, String serviceUrl, ContentType contentType) {
            super(type, serviceUrl, contentType);
        }

        public void setPublicId(String publicId) {
            this.setParameter("publicId", publicId);
        }

        public void setObjectType(String type) {
            this.setParameter("type", type);
        }

        public void setDatabaseId(String id) {
            this.setParameter("id", id);
        }
    }
}

