/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.services;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.intermine.webservice.client.core.Request;
import org.intermine.webservice.client.core.Service;
import org.intermine.webservice.client.results.JSONResult;
import org.intermine.webservice.client.results.Page;
import org.intermine.webservice.client.results.RowResultSet;
import org.intermine.webservice.client.results.XMLTableResult;
import org.intermine.webservice.client.util.HttpConnection;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractQueryService<T>
extends Service {
    public AbstractQueryService(String rootUrl, String serviceRelativeUrl, String applicationName) {
        super(rootUrl, serviceRelativeUrl, applicationName);
    }

    abstract Iterator<List<String>> getRowIterator(T var1, Page var2);

    abstract RowResultSet getRows(T var1, Page var2);

    abstract List<JSONObject> getJSONResults(T var1, Page var2) throws JSONException;

    abstract int getCount(T var1);

    abstract List<List<String>> getResults(T var1, Page var2);

    public List<List<String>> getAllResults(T query) {
        return this.getResults(query, Page.DEFAULT);
    }

    public List<JSONObject> getAllJSONResults(T query) throws JSONException {
        return this.getJSONResults(query, Page.DEFAULT);
    }

    public Iterator<List<String>> getAllRowsIterator(T query) {
        return this.getRowIterator(query, Page.DEFAULT);
    }

    public Iterator<Map<String, Object>> getRowMapIterator(T query) {
        return this.getRows(query, Page.DEFAULT).getMapIterator();
    }

    public Iterator<Map<String, Object>> getRowMapIterator(T query, Page page) {
        return this.getRows(query, page).getMapIterator();
    }

    public Iterator<List<Object>> getRowListIterator(T query) {
        return this.getRows(query, Page.DEFAULT).getListIterator();
    }

    public Iterator<List<Object>> getRowListIterator(T query, Page page) {
        return this.getRows(query, page).getListIterator();
    }

    public List<Map<String, Object>> getRowsAsMaps(T query) {
        return this.getRows(query, Page.DEFAULT).getRowsAsMaps();
    }

    public List<Map<String, Object>> getRowsAsMaps(T query, Page page) {
        return this.getRows(query, page).getRowsAsMaps();
    }

    public List<List<Object>> getRowsAsLists(T query) {
        return this.getRows(query, Page.DEFAULT).getRowsAsLists();
    }

    public List<List<Object>> getRowsAsLists(T query, Page page) {
        return this.getRows(query, page).getRowsAsLists();
    }

    protected XMLTableResult getResponseTable(Request request) {
        HttpConnection connection = this.executeRequest(request);
        return new XMLTableResult(connection);
    }

    protected RowResultSet getRows(Request request, List<String> views) {
        HttpConnection connection = this.executeRequest(request);
        return new RowResultSet(connection, views);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringResponse(Request request) {
        HttpConnection connection = this.executeRequest(request);
        String res = null;
        try {
            res = connection.getResponseBodyAsString().trim();
        }
        finally {
            connection.close();
        }
        return res;
    }

    protected JSONResult getJSONResponse(Request request) {
        HttpConnection connection = this.executeRequest(request);
        return new JSONResult(connection);
    }
}

