/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.results;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringEscapeUtils;
import org.intermine.webservice.client.exceptions.ResultException;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.exceptions.TransferInterruptedException;
import org.intermine.webservice.client.results.ResultSet;
import org.intermine.webservice.client.util.HttpConnection;

public class XMLTableResult
extends ResultSet {
    private XMLStreamReader xmlReader = null;

    public XMLTableResult(HttpConnection c) {
        super(c);
        this.init();
    }

    public XMLTableResult(String s) {
        super(s);
        this.init();
    }

    private void init() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.xmlReader = factory.createXMLStreamReader(this.getReader());
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Error parsing XML result response", e);
        }
    }

    @Override
    public List<List<String>> getData() {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        List<String> row = null;
        while ((row = this.getNextRow()) != null) {
            ret.add(row);
        }
        return ret;
    }

    private List<String> getNextRow() {
        ArrayList<String> row = new ArrayList<String>();
        boolean hasGotWholeRow = false;
        boolean hasGotWholeResultSet = false;
        String currentElemName = null;
        String errorMessage = null;
        String errorCause = null;
        String currentValue = null;
        try {
            while (this.xmlReader.hasNext()) {
                int eventType = this.xmlReader.getEventType();
                switch (eventType) {
                    case 1: {
                        currentElemName = this.xmlReader.getLocalName();
                        break;
                    }
                    case 2: {
                        String elemName = this.xmlReader.getLocalName();
                        if ("Result".equals(elemName)) {
                            hasGotWholeRow = true;
                            break;
                        }
                        if ("ResultSet".equals(elemName)) {
                            hasGotWholeResultSet = true;
                            break;
                        }
                        if (!"i".equals(elemName)) break;
                        row.add(currentValue);
                        currentValue = null;
                        break;
                    }
                    case 4: {
                        if ("i".equals(currentElemName)) {
                            String valueChunk = StringEscapeUtils.unescapeXml((String)this.xmlReader.getText());
                            if (currentValue == null) {
                                currentValue = valueChunk;
                                break;
                            }
                            currentValue = currentValue + valueChunk;
                            break;
                        }
                        if ("message".equals(currentElemName)) {
                            errorMessage = this.xmlReader.getText();
                            break;
                        }
                        if ("cause".equals(currentElemName)) {
                            errorCause = this.xmlReader.getText();
                            break;
                        }
                        String data = this.xmlReader.getText();
                        if (data == null || "".equals(data.trim())) break;
                        throw new ServiceException("Character data found in illegal place: " + currentElemName + ", '" + data + "'");
                    }
                }
                this.xmlReader.next();
                if (!hasGotWholeRow) continue;
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Error parsing XML result response", e);
        }
        if (errorMessage != null || errorCause != null) {
            throw new ResultException(errorMessage, errorCause);
        }
        if (!hasGotWholeRow && !hasGotWholeResultSet) {
            throw new TransferInterruptedException();
        }
        if (row.isEmpty()) {
            return null;
        }
        return row;
    }

    public Iterator<List<String>> getIterator() {
        return new TableIterator();
    }

    private class TableIterator
    implements Iterator<List<String>> {
        private List<String> next;

        public TableIterator() {
            this.next = XMLTableResult.this.getNextRow();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public List<String> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            List<String> tmp = this.next;
            this.next = XMLTableResult.this.getNextRow();
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

