/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.results;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.results.ResultSet;
import org.intermine.webservice.client.util.HttpConnection;

public class TabTableResult
extends ResultSet {
    public TabTableResult(HttpConnection c) {
        super(c);
    }

    public TabTableResult(String s) {
        super(s);
    }

    @Override
    public List<List<String>> getData() {
        String line;
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        while ((line = this.getNextLine()) != null) {
            ret.add(this.parseLine(line));
        }
        return ret;
    }

    private List<String> parseLine(String line) {
        String[] parts;
        if (line.startsWith("[ERROR]")) {
            throw new ServiceException(line);
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String part : parts = line.split("\t")) {
            ret.add(part);
        }
        return ret;
    }

    public Iterator<List<String>> getIterator() {
        return new TableIterator();
    }

    private class TableIterator
    implements Iterator<List<String>> {
        private List<String> next = this.parseNext();

        private List<String> parseNext() {
            String line = TabTableResult.this.getNextLine();
            if (line != null) {
                return TabTableResult.this.parseLine(line);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public List<String> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            List<String> tmp = this.next;
            this.next = this.parseNext();
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

