/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.results;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.results.ResultRowList;
import org.intermine.webservice.client.results.ResultRowMap;
import org.intermine.webservice.client.results.ResultSet;
import org.intermine.webservice.client.util.HttpConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class RowResultSet
extends ResultSet {
    private List<String> views;
    private final StringBuffer containerBuffer = new StringBuffer();

    public RowResultSet(HttpConnection connection, List<String> views) {
        super(connection);
        this.init(views);
    }

    public RowResultSet(String stringResults, List<String> views) {
        super(stringResults);
        this.init(views);
    }

    RowResultSet(InputStream is, List<String> views) {
        super(is);
        this.init(views);
    }

    private void init(List<String> views) {
        this.views = views;
    }

    @Override
    public List<List<String>> getData() {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        String rowData = null;
        while ((rowData = this.getNextRow()) != null) {
            ResultRowList r = new ResultRowList(rowData);
            ArrayList<String> row = new ArrayList<String>();
            for (Object o : r) {
                row.add(o.toString());
            }
            ret.add(row);
        }
        return ret;
    }

    public List<List<Object>> getRowsAsLists() {
        ArrayList<List<Object>> ret = new ArrayList<List<Object>>();
        String rowData = null;
        while ((rowData = this.getNextRow()) != null) {
            ret.add(new ResultRowList(rowData));
        }
        return ret;
    }

    public List<Map<String, Object>> getRowsAsMaps() {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        String rowData = null;
        while ((rowData = this.getNextRow()) != null) {
            ret.add(new ResultRowMap(rowData, this.views));
        }
        return ret;
    }

    private void checkContainerStatus() {
        String container = this.containerBuffer.toString();
        try {
            JSONObject parsed = new JSONObject(container);
            if (!parsed.getBoolean("wasSuccessful")) {
                throw new ServiceException(parsed.getString("error"));
            }
        }
        catch (JSONException e) {
            throw new ServiceException("Error parsing container - transmission may have been interrupted");
        }
    }

    private String getNextRow() {
        String nextLine = this.getNextLine();
        if (nextLine == null) {
            this.checkContainerStatus();
            return null;
        }
        if (!nextLine.startsWith("[")) {
            this.containerBuffer.append(nextLine);
            return this.getNextRow();
        }
        if (nextLine.endsWith(",")) {
            return nextLine.substring(0, nextLine.length() - 1);
        }
        return nextLine;
    }

    public Iterator<List<Object>> getListIterator() {
        return new RowListIterator();
    }

    public Iterator<Map<String, Object>> getMapIterator() {
        return new RowMapIterator();
    }

    private class RowListIterator
    implements Iterator<List<Object>> {
        private List<Object> next = this.nextRowList();

        private List<Object> nextRowList() {
            String line = RowResultSet.this.getNextRow();
            if (line != null) {
                return new ResultRowList(line);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public List<Object> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            List<Object> tmp = this.next;
            this.next = this.nextRowList();
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class RowMapIterator
    implements Iterator<Map<String, Object>> {
        private Map<String, Object> next = this.nextRowMap();

        private Map<String, Object> nextRowMap() {
            String line = RowResultSet.this.getNextRow();
            if (line != null) {
                return new ResultRowMap(line, (List<String>)RowResultSet.this.views);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map<String, Object> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Map<String, Object> tmp = this.next;
            this.next = this.nextRowMap();
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

