/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.results;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.util.HttpConnection;

public abstract class ResultSet {
    private HttpConnection connection = null;
    private String stringResults = null;
    private InputStream streamResults = null;
    private BufferedReader reader = null;

    public ResultSet(HttpConnection connection) {
        this.connection = connection;
        this.init();
    }

    public ResultSet(String stringResults) {
        this.stringResults = stringResults;
        this.init();
    }

    ResultSet(InputStream is) {
        this.streamResults = is;
        this.init();
    }

    private void init() {
        this.reader = this.getNewReader();
    }

    protected BufferedReader getReader() {
        return this.reader;
    }

    abstract List<List<String>> getData();

    private BufferedReader getNewReader() {
        if (this.connection != null) {
            return new BufferedReader(new InputStreamReader(this.connection.getResponseBodyAsStream()));
        }
        if (this.streamResults != null) {
            return new BufferedReader(new InputStreamReader(this.streamResults));
        }
        return new BufferedReader(new StringReader(this.stringResults));
    }

    public String getNextLine() {
        String nextLine = null;
        try {
            nextLine = this.reader.readLine();
        }
        catch (IOException e) {
            this.closeConnection();
            throw new ServiceException("Reading from response stream failed", e);
        }
        if (nextLine == null) {
            this.closeConnection();
        }
        return nextLine;
    }

    private void closeConnection() {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

