/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.results;

import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public class ResultRowMap
extends AbstractMap<String, Object> {
    private final JSONArray data;
    private final List<String> views;

    public ResultRowMap(JSONArray ja, List<String> views) {
        this.data = ja;
        this.views = views;
        this.verify();
    }

    public ResultRowMap(String json, List<String> views) {
        try {
            this.data = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
        this.views = views;
        this.verify();
    }

    private void verify() {
        if (this.data == null || this.views == null || this.data.length() != this.views.size()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        LinkedHashSet<Map.Entry<String, Object>> entries = new LinkedHashSet<Map.Entry<String, Object>>();
        for (int i = 0; i < this.data.length(); ++i) {
            Object val;
            String key = this.views.get(i);
            try {
                val = this.data.getJSONObject(i).isNull("value") ? null : this.data.getJSONObject(i).get("value");
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            entries.add(new RowEntry(key, val));
        }
        return entries;
    }

    private String getRoot() {
        return this.views.get(0).split("\\.")[0];
    }

    @Override
    public Object get(Object key) {
        String root;
        if (!this.views.contains(key) && !this.views.contains(key = (root = this.getRoot()) + "." + key)) {
            return null;
        }
        int i = this.views.indexOf(key);
        try {
            Object val = this.data.getJSONObject(i).isNull("value") ? null : this.data.getJSONObject(i).get("value");
            return val;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static class RowEntry
    extends AbstractMap.SimpleImmutableEntry<String, Object> {
        private static final long serialVersionUID = -8770402781429939453L;

        public RowEntry(String k, Object v) {
            super(k, v);
        }
    }
}

