/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.results;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.results.ResultSet;
import org.intermine.webservice.client.util.ErrorMessageParser;
import org.intermine.webservice.client.util.HttpConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONResult
extends ResultSet {
    public JSONResult(HttpConnection c) {
        super(c);
    }

    public JSONResult(String s) {
        super(s);
    }

    public List<JSONObject> getObjects() throws JSONException {
        JSONArray results = this.getResults();
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
        for (int index = 0; index < results.length(); ++index) {
            objects.add(results.getJSONObject(index));
        }
        return objects;
    }

    public JSONArray getResults() {
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = this.getNextLine()) != null) {
            sb.append(this.checkLineForErrors(line));
        }
        try {
            JSONObject resultSet = new JSONObject(sb.toString());
            JSONArray results = resultSet.getJSONArray("results");
            return results;
        }
        catch (JSONException e) {
            throw new ServiceException("Bad JSON: " + sb.toString(), e);
        }
    }

    private String checkLineForErrors(String line) {
        if (line.startsWith("<error>")) {
            throw new ServiceException(ErrorMessageParser.parseError(line));
        }
        return line;
    }

    public Iterator<JSONObject> getIterator() throws JSONException {
        return new JSONIterator();
    }

    @Override
    List<List<String>> getData() {
        throw new UnsupportedOperationException();
    }

    private class JSONIterator
    implements Iterator<JSONObject> {
        private JSONArray results;
        private int index = 0;

        public JSONIterator() {
            this.results = JSONResult.this.getResults();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.results.length();
        }

        @Override
        public JSONObject next() {
            JSONObject next;
            try {
                next = this.results.getJSONObject(this.index);
            }
            catch (JSONException e) {
                throw new RuntimeException("Problem parsing json object", e);
            }
            ++this.index;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

