/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.results;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.client.core.ServiceFactory;
import org.intermine.webservice.client.util.PQUtil;

public class Item {
    private final String type;
    private final Model model;
    private final Map<String, Object> properties;
    private ServiceFactory factory;

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    public Item(ServiceFactory factory, String type, Map<String, Object> properties) {
        assert (factory != null);
        assert (type != null);
        assert (properties != null);
        this.factory = factory;
        this.model = factory.getModel();
        this.type = type;
        this.properties = Collections.unmodifiableMap(properties);
    }

    public String getString(String key) {
        return (String)this.properties.get(key);
    }

    public Integer getInt(String key) {
        return (Integer)this.properties.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.properties.get(key);
    }

    public Float getFloat(String key) {
        return (Float)this.properties.get(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.properties.get(key);
    }

    public int getId() {
        return this.getInt("id");
    }

    public boolean equals(Object other) {
        if (other instanceof Item) {
            return this.getId() == ((Item)other).getId();
        }
        return false;
    }

    public Item getReference(String key) {
        ReferenceDescriptor rd = this.getReferenceDescriptor(key);
        List<Map<String, Object>> results = this.getReferenceData((FieldDescriptor)rd);
        if (results.isEmpty()) {
            return null;
        }
        String referencedType = rd.getReferencedClassDescriptor().getUnqualifiedName();
        Map<String, Object> result = results.get(0);
        return new Item(this.factory, referencedType, this.transformForReference(result));
    }

    public Set<Item> getCollection(String key) {
        ReferenceDescriptor rd = this.getReferenceDescriptor(key);
        List<Map<String, Object>> results = this.getReferenceData((FieldDescriptor)rd);
        String referencedType = rd.getReferencedClassDescriptor().getUnqualifiedName();
        HashSet<Item> ret = new HashSet<Item>();
        for (Map<String, Object> result : results) {
            ret.add(new Item(this.factory, referencedType, this.transformForReference(result)));
        }
        return ret;
    }

    private ReferenceDescriptor getReferenceDescriptor(String key) {
        ClassDescriptor thisCd = this.model.getClassDescriptorByName(this.type);
        FieldDescriptor fd = thisCd.getFieldDescriptorByName(key);
        if (fd == null) {
            throw new NoSuchElementException(key + " is not a field");
        }
        try {
            return (ReferenceDescriptor)fd;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(key + " does not represent a reference");
        }
    }

    private Map<String, Object> transformForReference(Map<String, Object> orig) {
        HashMap<String, Object> transformed = new HashMap<String, Object>();
        for (String k : orig.keySet()) {
            String newKey = k.substring(k.lastIndexOf(46) + 1);
            transformed.put(newKey, orig.get(k));
        }
        return transformed;
    }

    private List<Map<String, Object>> getReferenceData(FieldDescriptor fd) {
        PathQuery query = new PathQuery(this.model);
        query.addViews(PQUtil.getStar(this.model, this.type + "." + fd.getName()));
        query.addConstraint((PathConstraint)Constraints.eq((String)(this.type + ".id"), (String)Integer.toString(this.getId())));
        return this.factory.getQueryService().getRowsAsMaps(query);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + this.getId();
        return hash;
    }

    public boolean isa(String type) {
        if (this.type.equals(type)) {
            return true;
        }
        ClassDescriptor thisCd = this.model.getClassDescriptorByName(this.type);
        ClassDescriptor thatCd = this.model.getClassDescriptorByName(type);
        return thisCd.getAllSuperDescriptors().contains(thatCd);
    }

    public String toString() {
        return this.type + this.properties;
    }
}

