/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.lists;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.intermine.webservice.client.core.ServiceFactory;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.lists.ItemList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Lists {
    private static final SimpleDateFormat ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private Lists() {
    }

    public static ItemList parseList(ServiceFactory fac, JSONObject data) {
        try {
            String name = data.getString("name");
            String description = data.getString("description");
            String type = data.getString("type");
            String status = data.optString("status", null);
            int size = data.getInt("size");
            boolean authorized = data.getBoolean("authorized");
            Date createdAt = null;
            if (data.has("dateCreated")) {
                createdAt = ISO_8601_DATE_FORMAT.parse(data.getString("dateCreated"));
            }
            JSONArray tagArray = data.getJSONArray("tags");
            ArrayList<String> tags = new ArrayList<String>();
            int noOfTags = tagArray.length();
            for (int i = 0; i < noOfTags; ++i) {
                tags.add(tagArray.getString(i));
            }
            return new ItemList(fac, name, description, size, type, tags, authorized, createdAt, status);
        }
        catch (JSONException e) {
            throw new ServiceException("Error parsing '" + data.toString() + "'", e);
        }
        catch (ParseException e) {
            throw new ServiceException("Error parsing date '" + data.toString() + "'", e);
        }
    }

    public static ItemList parseListCreationInfo(ServiceFactory factory, String data) {
        try {
            JSONObject jo = new JSONObject(data);
            if (!jo.isNull("error")) {
                throw new ServiceException(jo.getString("error"));
            }
            String name = jo.getString("listName");
            int size = 0;
            ItemList il = new ItemList(factory, name, null, size, "dummy", null, true, new Date(), null);
            if (jo.has("unmatchedIdentifiers")) {
                JSONArray badIds = jo.getJSONArray("unmatchedIdentifiers");
                for (int i = 0; i < badIds.length(); ++i) {
                    il.addUnmatchedId(badIds.getString(i));
                }
            }
            return il;
        }
        catch (JSONException e) {
            throw new ServiceException("Error parsing '" + data + "'", e);
        }
    }
}

