/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.lists;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.client.core.ServiceFactory;
import org.intermine.webservice.client.results.Item;
import org.intermine.webservice.client.services.ListService;
import org.intermine.webservice.client.util.PQUtil;

public class ItemList
extends AbstractSet<Item>
implements Iterable<Item> {
    private final ServiceFactory services;
    private String name;
    private int size;
    private String type;
    private String description;
    private String status;
    private List<String> tags;
    private boolean authorized;
    private Date createdAt;
    private Set<String> unmatchedIds = new HashSet<String>();
    private List<Item> items = null;

    public Set<String> getUnmatchedIdentifiers() {
        return new HashSet<String>(this.unmatchedIds);
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    protected void addUnmatchedId(String id) {
        this.unmatchedIds.add(id);
    }

    public void addUnmatchedIds(Collection<String> ids) {
        this.unmatchedIds.addAll(ids);
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public Set<String> getTags() {
        return new HashSet<String>(this.tags);
    }

    public void updateTags() {
        this.tags = this.services.getListService().getTags(this);
    }

    public void addTags(String ... newTags) {
        this.tags = this.services.getListService().addTags(this, newTags);
    }

    public void removeTags(String ... removeThese) {
        this.tags = this.services.getListService().removeTags(this, removeThese);
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public int size() {
        return this.getSize();
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStatus() {
        return this.status;
    }

    ItemList(ServiceFactory fac, String name, String desc, int size, String type, List<String> tags, boolean authorized, Date createdAt, String status) {
        assert (name != null);
        assert (type != null);
        this.services = fac;
        this.name = name;
        this.description = desc;
        this.size = size;
        this.type = type;
        this.tags = tags;
        this.authorized = authorized;
        this.createdAt = createdAt;
        this.status = status;
    }

    @Override
    public String toString() {
        return this.name + " (" + this.description + " - " + this.size + " " + this.type + "s) created at: " + this.createdAt + ", tags: " + this.tags + ", authorized: " + this.authorized;
    }

    private List<Item> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
            for (Item i : this) {
                this.items.add(i);
            }
        }
        return this.items;
    }

    public Item get(int index) {
        return this.getItems().get(index);
    }

    private void update(ItemList updated) {
        this.items = null;
        this.size = updated.size();
        this.unmatchedIds.addAll(updated.getUnmatchedIdentifiers());
    }

    public void append(String ... ids) {
        this.update(this.services.getListService().append(this, ids));
    }

    public void append(Collection<? extends String> ids) {
        this.update(this.services.getListService().append(this, ids.toArray(new String[ids.size()])));
    }

    public void append(Item ... items) {
        this.appendItems(Arrays.asList(items));
    }

    public void append(PathQuery pq) {
        this.update(this.services.getListService().append(this, pq));
    }

    @Override
    public boolean add(Item i) {
        return this.addAll(Arrays.asList(i));
    }

    @Override
    public boolean addAll(Collection items) {
        int priorSize = this.getSize();
        this.appendItems(items);
        return priorSize != this.getSize();
    }

    private void appendItems(Iterable<Item> items) {
        PathQuery pq = new PathQuery(this.services.getModel());
        pq.addViews(new String[]{this.getType() + ".id"});
        HashSet<String> values = new HashSet<String>();
        for (Item i : items) {
            values.add(Integer.toString(i.getId()));
        }
        pq.addConstraint((PathConstraint)Constraints.oneOfValues((String)(this.getType() + ".id"), values));
        this.update(this.services.getListService().append(this, pq));
    }

    @Override
    public boolean remove(Object i) {
        int priorSize = this.getSize();
        if (i instanceof Item) {
            Item item = (Item)i;
            String path = item.getType() + ".id";
            PathQuery pq = new PathQuery(this.services.getModel());
            pq.addView(path);
            pq.addConstraint((PathConstraint)Constraints.eq((String)path, (String)Integer.toString(item.getId())));
            this.createListAndSubtract(pq);
        }
        return priorSize != this.getSize();
    }

    @Override
    public boolean removeAll(Collection c) {
        int priorSize = this.getSize();
        if (c instanceof ItemList) {
            ItemList res = this.subtract((ItemList)c);
            this.update(res);
            this.delete();
            res.rename(this.getName());
        } else if (!c.isEmpty()) {
            try {
                Item[] is = c.toArray(new Item[0]);
                String path = is[0].getType() + ".id";
                PathQuery pq = new PathQuery(this.services.getModel());
                pq.addView(path);
                pq.addConstraint((PathConstraint)Constraints.oneOfValues((String)path, (Collection)CollectionUtils.collect((Collection)CollectionUtils.collect(Arrays.asList(is), (Transformer)TransformerUtils.invokerTransformer((String)"getId")), (Transformer)TransformerUtils.stringValueTransformer())));
                this.createListAndSubtract(pq);
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return priorSize != this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createListAndSubtract(PathQuery pq) {
        ListService listService = this.services.getListService();
        listService.getClass();
        ListService.ListCreationInfo info = new ListService.ListCreationInfo(listService, pq);
        ItemList removalList = null;
        try {
            removalList = this.services.getListService().createList(info);
            ItemList res = this.subtract(removalList);
            this.update(res);
            this.delete();
            res.rename(this.getName());
        }
        finally {
            try {
                removalList.delete();
            }
            catch (Exception e) {}
        }
    }

    public void delete() {
        this.services.getListService().deleteList(this);
    }

    public ItemList subtract(ItemList ... lists) {
        return this.services.getListService().subtract(Collections.singleton(this), Arrays.asList(lists));
    }

    public ItemList subtract(ListService.ListOperationInfo info, ItemList ... lists) {
        return this.services.getListService().subtract(info, Collections.singleton(this), Arrays.asList(lists));
    }

    public ItemList subtract(Collection<ItemList> lists) {
        return this.services.getListService().subtract(Collections.singleton(this), lists);
    }

    public ItemList subtract(ListService.ListOperationInfo info, Collection<ItemList> lists) {
        return this.services.getListService().subtract(info, Collections.singleton(this), lists);
    }

    public void rename(String newName) {
        ItemList updated = this.services.getListService().rename(this, newName);
        this.name = updated.getName();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Item) {
            Item i = (Item)o;
            return this.containsAll(Arrays.asList(i));
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        Item[] candidates;
        if (c == null) {
            return false;
        }
        try {
            candidates = c.toArray(new Item[c.size()]);
        }
        catch (ArrayStoreException e) {
            return false;
        }
        return this.services.getListService().contains(this, candidates);
    }

    public List<Item> find(Map<String, Object> conditions) {
        ArrayList<Item> ret = new ArrayList<Item>();
        PathQuery q = new PathQuery(this.services.getModel());
        q.addViews(PQUtil.getStar(this.services.getModel(), this.type));
        q.addConstraint((PathConstraint)Constraints.in((String)this.type, (String)this.name));
        for (Map.Entry<String, Object> condition : conditions.entrySet()) {
            String path = this.type + "." + condition.getKey();
            if (condition.getValue() == null) {
                q.addConstraint((PathConstraint)Constraints.isNull((String)path));
                continue;
            }
            q.addConstraint((PathConstraint)Constraints.eq((String)path, (String)condition.getValue().toString()));
        }
        List<Map<String, Object>> results = this.services.getQueryService().getRowsAsMaps(q);
        for (Map<String, Object> result : results) {
            ret.add(new Item(this.services, this.type, result));
        }
        return ret;
    }

    @Override
    public Iterator<Item> iterator() {
        PathQuery pq = new PathQuery(this.services.getModel());
        pq.addViews(PQUtil.getStar(this.services.getModel(), this.getType()));
        pq.addConstraint((PathConstraint)Constraints.in((String)this.type, (String)this.name));
        Iterator<Map<String, Object>> it = this.services.getQueryService().getRowMapIterator(pq);
        return new ItemIterator(it);
    }

    private class ItemIterator
    implements Iterator<Item> {
        Iterator<Map<String, Object>> results;

        ItemIterator(Iterator<Map<String, Object>> results) {
            this.results = results;
        }

        @Override
        public boolean hasNext() {
            return this.results.hasNext();
        }

        @Override
        public Item next() {
            return new Item(ItemList.this.services, ItemList.this.type, this.results.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("removal is not supported");
        }
    }
}

