/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.exceptions;

import org.intermine.webservice.client.util.ErrorMessageParser;
import org.intermine.webservice.client.util.HttpConnection;

public class ServiceException
extends RuntimeException {
    private final int httpErrorCode;
    protected static final int ERROR_CODE = 500;
    private static final long serialVersionUID = 1L;

    public ServiceException(String message) {
        super(message);
        this.httpErrorCode = 500;
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
        this.httpErrorCode = 500;
    }

    public ServiceException(Throwable cause) {
        super(cause);
        this.httpErrorCode = 500;
    }

    public ServiceException(HttpConnection connection) {
        super(ErrorMessageParser.parseError(connection.getResponseBodyAsString()));
        this.httpErrorCode = connection.getResponseCode();
    }

    @Override
    public String getMessage() {
        if (super.getMessage() == null || super.getMessage().length() == 0) {
            return "Error code: " + this.getHttpErrorCode();
        }
        return super.getMessage();
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }
}

