/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.core;

import org.intermine.metadata.Model;
import org.intermine.webservice.client.core.Service;
import org.intermine.webservice.client.services.ListService;
import org.intermine.webservice.client.services.ModelService;
import org.intermine.webservice.client.services.QueryService;
import org.intermine.webservice.client.services.TemplateService;
import org.intermine.webservice.client.services.WidgetService;

public class ServiceFactory {
    private final String rootUrl;
    private String applicationName = "InterMine-WS-Client-Java-0.96";
    private final String userName;
    private final String userPass;
    private final String authToken;
    private QueryService qs;
    private TemplateService ts;
    private ListService ls;
    private ModelService ms;
    private WidgetService ws;

    public ServiceFactory(String rootUrl) {
        this.rootUrl = rootUrl;
        this.userName = null;
        this.userPass = null;
        this.authToken = null;
    }

    public ServiceFactory(String rootUrl, String token) {
        this.rootUrl = rootUrl;
        this.authToken = token;
        this.userName = null;
        this.userPass = null;
    }

    @Deprecated
    public ServiceFactory(String rootUrl, String userName, String userPass) {
        this.rootUrl = rootUrl;
        this.authToken = null;
        this.userName = userName;
        this.userPass = userPass;
    }

    public void setApplicationName(String name) {
        this.applicationName = name;
    }

    private void authoriseAndLink(Service s) {
        if (this.authToken != null) {
            s.setAuthentication(this.authToken);
        } else if (this.userName != null && this.userPass != null) {
            s.setAuthentication(this.userName, this.userPass);
        }
        s.setFactory(this);
    }

    public QueryService getQueryService() {
        if (this.qs == null) {
            this.qs = new QueryService(this.rootUrl, this.applicationName);
            this.authoriseAndLink(this.qs);
        }
        return this.qs;
    }

    public TemplateService getTemplateService() {
        if (this.ts == null) {
            this.ts = new TemplateService(this.rootUrl, this.applicationName);
            this.authoriseAndLink(this.ts);
        }
        return this.ts;
    }

    public ListService getListService() {
        if (this.ls == null) {
            this.ls = new ListService(this.rootUrl, this.applicationName);
            this.authoriseAndLink(this.ls);
        }
        return this.ls;
    }

    public ModelService getModelService() {
        if (this.ms == null) {
            this.ms = new ModelService(this.rootUrl, this.applicationName);
        }
        return this.ms;
    }

    public Model getModel() {
        return this.getModelService().getModel();
    }

    public Service getService(String serviceRelativeUrl, String applicationName) {
        Service x = new Service(this.rootUrl, serviceRelativeUrl, applicationName);
        this.authoriseAndLink(x);
        return x;
    }

    public WidgetService getWidgetService() {
        if (this.ws == null) {
            this.ws = new WidgetService(this.rootUrl, this.applicationName);
            this.authoriseAndLink(this.ws);
        }
        return this.ws;
    }
}

