/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.intermine.webservice.client.core.ContentType;
import org.intermine.webservice.client.core.Request;
import org.intermine.webservice.client.core.RequestImpl;
import org.intermine.webservice.client.core.ServiceFactory;
import org.intermine.webservice.client.core.Version;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.util.HttpConnection;

public class Service {
    private static final String VERSION_HEADER = "InterMine-Version";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String AUTHENTICATION_FIELD_NAME = "Authorization";
    protected URL resourceUrl;
    private String rootUrl;
    private String applicationName;
    private int timeout;
    private String userName;
    private String password;
    private String authToken;
    private ServiceFactory factory = null;

    public ServiceFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ServiceFactory factory) {
        this.factory = factory;
    }

    public Service(String rootUrl, String serviceRelativeUrl, String applicationName) {
        this.init(rootUrl, serviceRelativeUrl, applicationName);
    }

    private void init(String rootUrl, String serviceRelativeUrl, String applicationName) {
        this.rootUrl = rootUrl;
        this.applicationName = applicationName;
        if (!rootUrl.endsWith("/")) {
            rootUrl = rootUrl + "/";
        }
        try {
            this.resourceUrl = new URL(rootUrl + serviceRelativeUrl);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Deprecated
    public void setAuthentication(String userName, String password) {
        if (userName == null || password == null || userName.length() == 0 || password.length() == 0) {
            throw new ServiceException("User name or password or both are empty.");
        }
        this.userName = userName;
        this.password = password;
    }

    public void setAuthentication(String token) {
        if (token == null) {
            throw new ServiceException("authorization token cannot be null.");
        }
        this.authToken = token;
    }

    public HttpConnection executeRequest(Request request) {
        this.assureOutputFormatSpecified(request);
        request.setHeader(VERSION_HEADER, this.getVersion().toString());
        request.setHeader(USER_AGENT_HEADER, this.getApplicationName() + " " + "JavaLibrary/" + this.getVersion().toString());
        this.applyAuthentication(request);
        HttpConnection connection = new HttpConnection(request);
        connection.setTimeout(this.timeout);
        connection.connect();
        return connection;
    }

    private void applyAuthentication(Request request) {
        if (this.userName != null && this.password != null) {
            String authValue = this.userName + ":" + this.password;
            String encodedValue = new String(Base64.encodeBase64((byte[])authValue.getBytes()));
            request.setHeader(AUTHENTICATION_FIELD_NAME, encodedValue);
        } else if (this.authToken != null) {
            request.setAuthToken(this.authToken);
        }
    }

    protected void assureOutputFormatSpecified(Request request) {
        if (request.getParameter("format") == null && this.getFormatValue(request.getContentType()) != null) {
            request.setParameter("format", this.getFormatValue(request.getContentType()));
        }
    }

    private String getFormatValue(ContentType contentType) {
        if (contentType == ContentType.TEXT_TAB) {
            return "tab";
        }
        if (contentType == ContentType.APPLICATION_JSON_OBJ) {
            return "jsonobjects";
        }
        if (contentType == ContentType.APPLICATION_JSON_ROW) {
            return "jsonrows";
        }
        if (contentType == ContentType.TEXT_COUNT) {
            return "count";
        }
        if (contentType == ContentType.APPLICATION_JSON) {
            return "json";
        }
        if (contentType == ContentType.TEXT_XML) {
            return "xml";
        }
        return null;
    }

    public void setConnectionTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getUrl() {
        if (this.resourceUrl != null) {
            return this.resourceUrl.toString();
        }
        return null;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public Request createGetRequest(String url, ContentType contentType) {
        return new RequestImpl(Request.RequestType.GET, url, contentType);
    }

    public Request createPostRequest(String requestUrl, ContentType contentType) {
        return new RequestImpl(Request.RequestType.POST, requestUrl, contentType);
    }

    public Version getVersion() {
        return new Version("1.1");
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

