/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.core;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.webservice.client.core.ContentType;
import org.intermine.webservice.client.core.Request;
import org.intermine.webservice.client.exceptions.ServiceException;
import org.intermine.webservice.client.results.Page;
import org.intermine.webservice.client.util.URLParser;

public class RequestImpl
implements Request {
    protected static final String FORMAT_PARAMETER_JSON_OBJ = "jsonobjects";
    protected static final String FORMAT_PARAMETER_JSON_ROWS = "jsonrows";
    protected static final String FORMAT_PARAMETER_XML = "xml";
    protected static final String FORMAT_PARAMETER_COUNT = "count";
    private Request.RequestType type;
    private String serviceUrl;
    private ContentType contentType;
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private String authToken = null;

    public RequestImpl(Request.RequestType type, String url, ContentType contentType) {
        this.type = type;
        this.setUrl(url);
        this.contentType = contentType;
    }

    @Override
    public void addParameter(String name, String value) {
        List<String> values = this.getParameterValues(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.parameters.put(name, values);
        }
        values.add(value);
    }

    @Override
    public List<String> getParameterValues(String name) {
        return this.parameters.get(name);
    }

    @Override
    public String getParameter(String name) {
        List<String> pars = this.getParameterValues(name);
        if (pars != null && pars.size() > 0) {
            return pars.get(0);
        }
        return null;
    }

    @Override
    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    @Override
    public void setParameter(String name, String value) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.parameters.put(name, values);
        }
        values.clear();
        values.add(value);
    }

    @Override
    public Request.RequestType getType() {
        return this.type;
    }

    @Override
    public void setType(Request.RequestType type) {
        this.type = type;
    }

    @Override
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public void setServiceUrl(String url) {
        this.serviceUrl = url;
    }

    @Override
    public void setUrl(String url) {
        try {
            this.serviceUrl = URLParser.parseServiceUrl(url);
            this.parameters = URLParser.parseParameterMap(url);
        }
        catch (MalformedURLException e) {
            throw new ServiceException("Invalid url: " + url, e);
        }
    }

    public void setMaxCount(int maxCount) {
        this.setParameter("size", maxCount + "");
    }

    public void setStart(int start) {
        this.setParameter("start", start + "");
    }

    public void setFormat(String format) {
        this.setParameter("format", format);
    }

    public void setJSONFormat() {
        this.setFormat(FORMAT_PARAMETER_JSON_OBJ);
    }

    public void setJSONRowsFormat() {
        this.setFormat(FORMAT_PARAMETER_JSON_ROWS);
    }

    public void setXMLFormat() {
        this.setFormat(FORMAT_PARAMETER_XML);
    }

    public void setCountFormat() {
        this.setFormat(FORMAT_PARAMETER_COUNT);
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(this.parameters);
        if (this.authToken != null) {
            params.put("token", Collections.singletonList(this.authToken));
        }
        return Collections.unmodifiableMap(params);
    }

    @Override
    public String getEncodedUrl() {
        return this.getUrl(true);
    }

    @Override
    public String getUnencodedUrl() {
        return this.getUrl(false);
    }

    private String getUrl(boolean encode) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serviceUrl);
        String separator = "?";
        Map<String, List<String>> params = this.getParameterMap();
        for (String parName : params.keySet()) {
            for (String value : params.get(parName)) {
                sb.append(separator);
                if ("?".equals(separator)) {
                    separator = "&";
                }
                sb.append(parName);
                if (value.length() <= 0) continue;
                sb.append("=");
                sb.append(this.format(value, encode));
            }
        }
        return sb.toString();
    }

    private String format(String str, boolean encode) {
        if (encode) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ServiceException("URL encoding failed for string " + str, e);
            }
        }
        return str;
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public void setAuthToken(String token) {
        this.authToken = token;
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.serviceUrl + ", params: " + this.parameters + ", authorization-token: " + this.authToken + ", content-type: " + this.contentType.toString() + ", headers: " + this.headers;
    }

    @Override
    public void setPage(Page page) {
        this.setStart(page.getStart());
        if (page.getSize() != null) {
            this.setMaxCount(page.getSize());
        }
    }
}

