/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.client.core;

public final class ContentType {
    private String type;
    private String subType;
    private String charSet;
    private static final String UTF8_CHARSET = "UTF-8";
    public static final ContentType TEXT_XML = new ContentType("text", "xml", "UTF-8");
    public static final ContentType MULTI_PART_FORM = new ContentType("multipart", "form-data", "UTF-8");
    public static final ContentType TEXT_TAB = new ContentType("text", "tab-separated-values", "UTF-8");
    public static final ContentType TEXT_COUNT = new ContentType("text", "count", "UTF-8");
    public static final ContentType TEXT_PLAIN = new ContentType("text", "plain", "UTF-8");
    public static final ContentType APPLICATION_JSON = new ContentType("application", "json", "UTF-8");
    public static final ContentType APPLICATION_JSON_OBJ = new ContentType("application", "jsonobjects", "UTF-8");
    public static final ContentType APPLICATION_JSON_ROW = new ContentType("application", "jsonrows", "UTF-8");

    private ContentType(String type, String subType, String charSet) {
        this.type = type;
        this.subType = subType;
        this.charSet = charSet;
    }

    public String toString() {
        return this.type + "/" + this.subType + ";char-set:" + this.charSet;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }
}

