/*
 * Decompiled with CFR 0.152.
 */
package mmcorej;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import mmcorej.BooleanVector;
import mmcorej.CMMCore;
import mmcorej.CharVector;
import mmcorej.Configuration;
import mmcorej.DoubleVector;
import mmcorej.LongVector;
import mmcorej.MMEventCallback;
import mmcorej.Metadata;
import mmcorej.MetadataArrayTag;
import mmcorej.MetadataError;
import mmcorej.MetadataSingleTag;
import mmcorej.MetadataTag;
import mmcorej.PropertyBlock;
import mmcorej.PropertyPair;
import mmcorej.PropertySetting;
import mmcorej.StrMap;
import mmcorej.StrVector;
import mmcorej.UnsignedVector;
import mmcorej.pair_ss;

public class MMCoreJJNI {
    private static final String MM_PROPERTY_MMCOREJ_LIB_PATH = "mmcorej.library.path";
    private static final String MM_PROPERTY_MMCOREJ_LIB_STDERR_LOG = "mmcorej.library.loading.stderr.log";
    private static final String NATIVE_LIBRARY_NAME = "MMCoreJ_wrap";

    private static void logLibraryLoading(String message) {
        boolean useStdErr = true;
        String useStdErrProp = System.getProperty(MM_PROPERTY_MMCOREJ_LIB_STDERR_LOG, "0");
        if (useStdErrProp.equals("0") || useStdErrProp.equalsIgnoreCase("false") || useStdErrProp.equalsIgnoreCase("no")) {
            useStdErr = false;
        }
        if (useStdErr) {
            System.err.println("Load MMCoreJ_wrap: " + message);
        }
    }

    private static File getPreferredLibraryPath() {
        String path = System.getProperty(MM_PROPERTY_MMCOREJ_LIB_PATH);
        if (path != null && path.length() > 0) {
            return new File(path);
        }
        return null;
    }

    private static File getHardCodedLibraryPath() {
        String path = "/usr/local/lib/micro-manager";
        if ("/usr/local/lib/micro-manager" != null && "/usr/local/lib/micro-manager".length() > 0) {
            return new File("/usr/local/lib/micro-manager");
        }
        return null;
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    private static boolean loadNamedNativeLibrary(File dirPath, String libraryName) {
        String libraryPath = new File(dirPath, libraryName).getAbsolutePath();
        if (new File(libraryPath).exists()) {
            MMCoreJJNI.logLibraryLoading("Try loading: " + libraryPath);
            System.load(libraryPath);
            MMCoreJJNI.logLibraryLoading("Successfully loaded: " + libraryPath);
            return true;
        }
        MMCoreJJNI.logLibraryLoading("Skipping nonexistent candidate: " + libraryPath);
        return false;
    }

    private static boolean loadNativeLibrary(File dirPath) {
        String libraryName = System.mapLibraryName(NATIVE_LIBRARY_NAME);
        if (libraryName.endsWith(".dylib")) {
            String altLibraryName = "libMMCoreJ_wrap.jnilib";
            boolean ret = MMCoreJJNI.loadNamedNativeLibrary(dirPath, "libMMCoreJ_wrap.jnilib");
            if (ret) {
                return true;
            }
        }
        return MMCoreJJNI.loadNamedNativeLibrary(dirPath, libraryName);
    }

    private static boolean checkIfAlreadyLoaded() {
        boolean loaded = true;
        try {
            CMMCore.noop();
        }
        catch (UnsatisfiedLinkError e) {
            loaded = false;
        }
        if (loaded) {
            MMCoreJJNI.logLibraryLoading("Already loaded");
            return true;
        }
        return false;
    }

    private static boolean loadFromPathSetBySystemProperty() {
        File preferredPath = MMCoreJJNI.getPreferredLibraryPath();
        if (preferredPath != null) {
            MMCoreJJNI.logLibraryLoading("Try path given by mmcorej.library.path");
            MMCoreJJNI.loadNativeLibrary(preferredPath);
            return true;
        }
        return false;
    }

    private static boolean loadFromHardCodedPaths() {
        File hardCodedPath;
        ArrayList<File> searchPaths = new ArrayList<File>();
        searchPaths.addAll(FijiPaths.getPaths());
        if (MMCoreJJNI.isLinux() && (hardCodedPath = MMCoreJJNI.getHardCodedLibraryPath()) != null) {
            searchPaths.add(hardCodedPath);
        }
        MMCoreJJNI.logLibraryLoading("Will search in hard-coded paths:");
        for (File path : searchPaths) {
            MMCoreJJNI.logLibraryLoading("  " + path.getPath());
        }
        for (File path : searchPaths) {
            if (!MMCoreJJNI.loadNativeLibrary(path)) continue;
            return true;
        }
        return false;
    }

    public static final native long new_CharVector__SWIG_0();

    public static final native long new_CharVector__SWIG_1(long var0);

    public static final native long CharVector_size(long var0, CharVector var2);

    public static final native long CharVector_capacity(long var0, CharVector var2);

    public static final native void CharVector_reserve(long var0, CharVector var2, long var3);

    public static final native boolean CharVector_isEmpty(long var0, CharVector var2);

    public static final native void CharVector_clear(long var0, CharVector var2);

    public static final native void CharVector_add(long var0, CharVector var2, char var3);

    public static final native char CharVector_get(long var0, CharVector var2, int var3);

    public static final native void CharVector_set(long var0, CharVector var2, int var3, char var4);

    public static final native void delete_CharVector(long var0);

    public static final native long new_LongVector__SWIG_0();

    public static final native long new_LongVector__SWIG_1(long var0);

    public static final native long LongVector_size(long var0, LongVector var2);

    public static final native long LongVector_capacity(long var0, LongVector var2);

    public static final native void LongVector_reserve(long var0, LongVector var2, long var3);

    public static final native boolean LongVector_isEmpty(long var0, LongVector var2);

    public static final native void LongVector_clear(long var0, LongVector var2);

    public static final native void LongVector_add(long var0, LongVector var2, int var3);

    public static final native int LongVector_get(long var0, LongVector var2, int var3);

    public static final native void LongVector_set(long var0, LongVector var2, int var3, int var4);

    public static final native void delete_LongVector(long var0);

    public static final native long new_DoubleVector__SWIG_0();

    public static final native long new_DoubleVector__SWIG_1(long var0);

    public static final native long DoubleVector_size(long var0, DoubleVector var2);

    public static final native long DoubleVector_capacity(long var0, DoubleVector var2);

    public static final native void DoubleVector_reserve(long var0, DoubleVector var2, long var3);

    public static final native boolean DoubleVector_isEmpty(long var0, DoubleVector var2);

    public static final native void DoubleVector_clear(long var0, DoubleVector var2);

    public static final native void DoubleVector_add(long var0, DoubleVector var2, double var3);

    public static final native double DoubleVector_get(long var0, DoubleVector var2, int var3);

    public static final native void DoubleVector_set(long var0, DoubleVector var2, int var3, double var4);

    public static final native void delete_DoubleVector(long var0);

    public static final native long new_StrVector__SWIG_0();

    public static final native long new_StrVector__SWIG_1(long var0);

    public static final native long StrVector_size(long var0, StrVector var2);

    public static final native long StrVector_capacity(long var0, StrVector var2);

    public static final native void StrVector_reserve(long var0, StrVector var2, long var3);

    public static final native boolean StrVector_isEmpty(long var0, StrVector var2);

    public static final native void StrVector_clear(long var0, StrVector var2);

    public static final native void StrVector_add(long var0, StrVector var2, String var3);

    public static final native String StrVector_get(long var0, StrVector var2, int var3);

    public static final native void StrVector_set(long var0, StrVector var2, int var3, String var4);

    public static final native void delete_StrVector(long var0);

    public static final native long new_BooleanVector__SWIG_0();

    public static final native long new_BooleanVector__SWIG_1(long var0);

    public static final native long BooleanVector_size(long var0, BooleanVector var2);

    public static final native long BooleanVector_capacity(long var0, BooleanVector var2);

    public static final native void BooleanVector_reserve(long var0, BooleanVector var2, long var3);

    public static final native boolean BooleanVector_isEmpty(long var0, BooleanVector var2);

    public static final native void BooleanVector_clear(long var0, BooleanVector var2);

    public static final native void BooleanVector_add(long var0, BooleanVector var2, boolean var3);

    public static final native boolean BooleanVector_get(long var0, BooleanVector var2, int var3);

    public static final native void BooleanVector_set(long var0, BooleanVector var2, int var3, boolean var4);

    public static final native void delete_BooleanVector(long var0);

    public static final native long new_UnsignedVector__SWIG_0();

    public static final native long new_UnsignedVector__SWIG_1(long var0);

    public static final native long UnsignedVector_size(long var0, UnsignedVector var2);

    public static final native long UnsignedVector_capacity(long var0, UnsignedVector var2);

    public static final native void UnsignedVector_reserve(long var0, UnsignedVector var2, long var3);

    public static final native boolean UnsignedVector_isEmpty(long var0, UnsignedVector var2);

    public static final native void UnsignedVector_clear(long var0, UnsignedVector var2);

    public static final native void UnsignedVector_add(long var0, UnsignedVector var2, long var3);

    public static final native long UnsignedVector_get(long var0, UnsignedVector var2, int var3);

    public static final native void UnsignedVector_set(long var0, UnsignedVector var2, int var3, long var4);

    public static final native void delete_UnsignedVector(long var0);

    public static final native long new_pair_ss__SWIG_0();

    public static final native long new_pair_ss__SWIG_1(String var0, String var1);

    public static final native long new_pair_ss__SWIG_2(long var0, pair_ss var2);

    public static final native void pair_ss_first_set(long var0, pair_ss var2, String var3);

    public static final native String pair_ss_first_get(long var0, pair_ss var2);

    public static final native void pair_ss_second_set(long var0, pair_ss var2, String var3);

    public static final native String pair_ss_second_get(long var0, pair_ss var2);

    public static final native void delete_pair_ss(long var0);

    public static final native long new_StrMap__SWIG_0();

    public static final native long new_StrMap__SWIG_1(long var0, StrMap var2);

    public static final native long StrMap_size(long var0, StrMap var2);

    public static final native boolean StrMap_empty(long var0, StrMap var2);

    public static final native void StrMap_clear(long var0, StrMap var2);

    public static final native String StrMap_get(long var0, StrMap var2, String var3);

    public static final native void StrMap_set(long var0, StrMap var2, String var3, String var4);

    public static final native void StrMap_del(long var0, StrMap var2, String var3);

    public static final native boolean StrMap_has_key(long var0, StrMap var2, String var3);

    public static final native void delete_StrMap(long var0);

    public static final native int MM_CODE_OK_get();

    public static final native int MM_CODE_ERR_get();

    public static final native int DEVICE_OK_get();

    public static final native int DEVICE_ERR_get();

    public static final native int DEVICE_INVALID_PROPERTY_get();

    public static final native int DEVICE_INVALID_PROPERTY_VALUE_get();

    public static final native int DEVICE_DUPLICATE_PROPERTY_get();

    public static final native int DEVICE_INVALID_PROPERTY_TYPE_get();

    public static final native int DEVICE_NATIVE_MODULE_FAILED_get();

    public static final native int DEVICE_UNSUPPORTED_DATA_FORMAT_get();

    public static final native int DEVICE_INTERNAL_INCONSISTENCY_get();

    public static final native int DEVICE_NOT_SUPPORTED_get();

    public static final native int DEVICE_UNKNOWN_LABEL_get();

    public static final native int DEVICE_UNSUPPORTED_COMMAND_get();

    public static final native int DEVICE_UNKNOWN_POSITION_get();

    public static final native int DEVICE_NO_CALLBACK_REGISTERED_get();

    public static final native int DEVICE_SERIAL_COMMAND_FAILED_get();

    public static final native int DEVICE_SERIAL_BUFFER_OVERRUN_get();

    public static final native int DEVICE_SERIAL_INVALID_RESPONSE_get();

    public static final native int DEVICE_SERIAL_TIMEOUT_get();

    public static final native int DEVICE_SELF_REFERENCE_get();

    public static final native int DEVICE_NO_PROPERTY_DATA_get();

    public static final native int DEVICE_DUPLICATE_LABEL_get();

    public static final native int DEVICE_INVALID_INPUT_PARAM_get();

    public static final native int DEVICE_BUFFER_OVERFLOW_get();

    public static final native int DEVICE_NONEXISTENT_CHANNEL_get();

    public static final native int DEVICE_INVALID_PROPERTY_LIMTS_get();

    public static final native int DEVICE_SNAP_IMAGE_FAILED_get();

    public static final native int DEVICE_IMAGE_PARAMS_FAILED_get();

    public static final native int DEVICE_CORE_FOCUS_STAGE_UNDEF_get();

    public static final native int DEVICE_CORE_EXPOSURE_FAILED_get();

    public static final native int DEVICE_CORE_CONFIG_FAILED_get();

    public static final native int DEVICE_CAMERA_BUSY_ACQUIRING_get();

    public static final native int DEVICE_INCOMPATIBLE_IMAGE_get();

    public static final native int DEVICE_CAN_NOT_SET_PROPERTY_get();

    public static final native int DEVICE_CORE_CHANNEL_PRESETS_FAILED_get();

    public static final native int DEVICE_LOCALLY_DEFINED_ERROR_get();

    public static final native int DEVICE_NOT_CONNECTED_get();

    public static final native int DEVICE_COMM_HUB_MISSING_get();

    public static final native int DEVICE_DUPLICATE_LIBRARY_get();

    public static final native int DEVICE_PROPERTY_NOT_SEQUENCEABLE_get();

    public static final native int DEVICE_SEQUENCE_TOO_LARGE_get();

    public static final native int DEVICE_OUT_OF_MEMORY_get();

    public static final native int DEVICE_NOT_YET_IMPLEMENTED_get();

    public static final native int MaxStrLength_get();

    public static final native String g_Keyword_Name_get();

    public static final native String g_Keyword_Description_get();

    public static final native String g_Keyword_CameraName_get();

    public static final native String g_Keyword_CameraID_get();

    public static final native String g_Keyword_CameraChannelName_get();

    public static final native String g_Keyword_CameraChannelIndex_get();

    public static final native String g_Keyword_Binning_get();

    public static final native String g_Keyword_Exposure_get();

    public static final native String g_Keyword_ActualExposure_get();

    public static final native String g_Keyword_ActualInterval_ms_get();

    public static final native String g_Keyword_Interval_ms_get();

    public static final native String g_Keyword_Elapsed_Time_ms_get();

    public static final native String g_Keyword_PixelType_get();

    public static final native String g_Keyword_ReadoutTime_get();

    public static final native String g_Keyword_ReadoutMode_get();

    public static final native String g_Keyword_Gain_get();

    public static final native String g_Keyword_EMGain_get();

    public static final native String g_Keyword_Offset_get();

    public static final native String g_Keyword_CCDTemperature_get();

    public static final native String g_Keyword_CCDTemperatureSetPoint_get();

    public static final native String g_Keyword_State_get();

    public static final native String g_Keyword_Label_get();

    public static final native String g_Keyword_Position_get();

    public static final native String g_Keyword_Type_get();

    public static final native String g_Keyword_Delay_get();

    public static final native String g_Keyword_BaudRate_get();

    public static final native String g_Keyword_DataBits_get();

    public static final native String g_Keyword_StopBits_get();

    public static final native String g_Keyword_Parity_get();

    public static final native String g_Keyword_Handshaking_get();

    public static final native String g_Keyword_DelayBetweenCharsMs_get();

    public static final native String g_Keyword_Port_get();

    public static final native String g_Keyword_AnswerTimeout_get();

    public static final native String g_Keyword_Speed_get();

    public static final native String g_Keyword_CoreDevice_get();

    public static final native String g_Keyword_CoreInitialize_get();

    public static final native String g_Keyword_CoreCamera_get();

    public static final native String g_Keyword_CoreShutter_get();

    public static final native String g_Keyword_CoreXYStage_get();

    public static final native String g_Keyword_CoreFocus_get();

    public static final native String g_Keyword_CoreAutoFocus_get();

    public static final native String g_Keyword_CoreAutoShutter_get();

    public static final native String g_Keyword_CoreChannelGroup_get();

    public static final native String g_Keyword_CoreImageProcessor_get();

    public static final native String g_Keyword_CoreSLM_get();

    public static final native String g_Keyword_CoreGalvo_get();

    public static final native String g_Keyword_CoreTimeoutMs_get();

    public static final native String g_Keyword_Channel_get();

    public static final native String g_Keyword_Version_get();

    public static final native String g_Keyword_ColorMode_get();

    public static final native String g_Keyword_Transpose_SwapXY_get();

    public static final native String g_Keyword_Transpose_MirrorX_get();

    public static final native String g_Keyword_Transpose_MirrorY_get();

    public static final native String g_Keyword_Transpose_Correction_get();

    public static final native String g_Keyword_Closed_Position_get();

    public static final native String g_Keyword_HubID_get();

    public static final native String g_Keyword_Meatdata_Exposure_get();

    public static final native String g_Keyword_Metadata_Score_get();

    public static final native String g_Keyword_Metadata_ImageNumber_get();

    public static final native String g_Keyword_Metadata_StartTime_get();

    public static final native String g_Keyword_Metadata_ROI_X_get();

    public static final native String g_Keyword_Metadata_ROI_Y_get();

    public static final native String g_FieldDelimiters_get();

    public static final native String g_CFGCommand_Device_get();

    public static final native String g_CFGCommand_Label_get();

    public static final native String g_CFGCommand_Property_get();

    public static final native String g_CFGCommand_Configuration_get();

    public static final native String g_CFGCommand_ConfigGroup_get();

    public static final native String g_CFGCommand_Equipment_get();

    public static final native String g_CFGCommand_Delay_get();

    public static final native String g_CFGCommand_ImageSynchro_get();

    public static final native String g_CFGCommand_ConfigPixelSize_get();

    public static final native String g_CFGCommand_PixelSize_um_get();

    public static final native String g_CFGCommand_ParentID_get();

    public static final native String g_CFGCommand_FocusDirection_get();

    public static final native String g_CFGGroup_System_get();

    public static final native String g_CFGGroup_System_Startup_get();

    public static final native String g_CFGGroup_System_Shutdown_get();

    public static final native String g_CFGGroup_PixelSizeUm_get();

    public static final native int _DATABITS_5_get();

    public static final native int _DATABITS_6_get();

    public static final native int _DATABITS_7_get();

    public static final native int _DATABITS_8_get();

    public static final native int _FLOWCONTROL_NONE_get();

    public static final native int _FLOWCONTROL_RTSCTS_IN_get();

    public static final native int _FLOWCONTROL_RTSCTS_OUT_get();

    public static final native int _FLOWCONTROL_XONXOFF_IN_get();

    public static final native int _FLOWCONTROL_XONXOFF_OUT_get();

    public static final native int _PARITY_EVEN_get();

    public static final native int _PARITY_MARK_get();

    public static final native int _PARITY_NONE_get();

    public static final native int _PARITY_ODD_get();

    public static final native int _PARITY_SPACE_get();

    public static final native int _STOPBITS_1_get();

    public static final native int _STOPBITS_1_5_get();

    public static final native int _STOPBITS_2_get();

    public static final native int UnknownType_get();

    public static final native int Unimplemented_get();

    public static final native int Misconfigured_get();

    public static final native int CanNotCommunicate_get();

    public static final native int CanCommunicate_get();

    public static final native long new_PropertySetting__SWIG_0(String var0, String var1, String var2, boolean var3);

    public static final native long new_PropertySetting__SWIG_1(String var0, String var1, String var2);

    public static final native long new_PropertySetting__SWIG_2();

    public static final native void delete_PropertySetting(long var0);

    public static final native String PropertySetting_getDeviceLabel(long var0, PropertySetting var2);

    public static final native String PropertySetting_getPropertyName(long var0, PropertySetting var2);

    public static final native boolean PropertySetting_getReadOnly(long var0, PropertySetting var2);

    public static final native String PropertySetting_getPropertyValue(long var0, PropertySetting var2);

    public static final native String PropertySetting_getKey(long var0, PropertySetting var2);

    public static final native String PropertySetting_generateKey(String var0, String var1);

    public static final native String PropertySetting_getVerbose(long var0, PropertySetting var2);

    public static final native boolean PropertySetting_isEqualTo(long var0, PropertySetting var2, long var3, PropertySetting var5);

    public static final native long new_PropertyPair__SWIG_0(String var0, String var1);

    public static final native long new_PropertyPair__SWIG_1();

    public static final native void delete_PropertyPair(long var0);

    public static final native String PropertyPair_getPropertyName(long var0, PropertyPair var2);

    public static final native String PropertyPair_getPropertyValue(long var0, PropertyPair var2);

    public static final native long new_Configuration();

    public static final native void delete_Configuration(long var0);

    public static final native void Configuration_addSetting(long var0, Configuration var2, long var3, PropertySetting var5);

    public static final native void Configuration_deleteSetting(long var0, Configuration var2, String var3, String var4);

    public static final native boolean Configuration_isPropertyIncluded(long var0, Configuration var2, String var3, String var4);

    public static final native boolean Configuration_isSettingIncluded(long var0, Configuration var2, long var3, PropertySetting var5);

    public static final native boolean Configuration_isConfigurationIncluded(long var0, Configuration var2, long var3, Configuration var5);

    public static final native long Configuration_getSetting__SWIG_0(long var0, Configuration var2, long var3) throws Exception;

    public static final native long Configuration_getSetting__SWIG_1(long var0, Configuration var2, String var3, String var4);

    public static final native long Configuration_size(long var0, Configuration var2);

    public static final native String Configuration_getVerbose(long var0, Configuration var2);

    public static final native long new_PropertyBlock();

    public static final native void delete_PropertyBlock(long var0);

    public static final native void PropertyBlock_addPair(long var0, PropertyBlock var2, long var3, PropertyPair var5);

    public static final native long PropertyBlock_getPair(long var0, PropertyBlock var2, long var3) throws Exception;

    public static final native long PropertyBlock_size(long var0, PropertyBlock var2);

    public static final native String PropertyBlock_getValue(long var0, PropertyBlock var2, String var3) throws Exception;

    public static final native long new_CMMCore();

    public static final native void delete_CMMCore(long var0);

    public static final native void CMMCore_noop();

    public static final native void CMMCore_loadDevice(long var0, CMMCore var2, String var3, String var4, String var5) throws Exception;

    public static final native void CMMCore_unloadDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_unloadAllDevices(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_initializeAllDevices(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_initializeDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_reset(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_unloadLibrary(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_updateCoreProperties(long var0, CMMCore var2) throws Exception;

    public static final native String CMMCore_getCoreErrorText(long var0, CMMCore var2, int var3);

    public static final native String CMMCore_getVersionInfo(long var0, CMMCore var2);

    public static final native String CMMCore_getAPIVersionInfo(long var0, CMMCore var2);

    public static final native long CMMCore_getSystemState(long var0, CMMCore var2);

    public static final native void CMMCore_setSystemState(long var0, CMMCore var2, long var3, Configuration var5);

    public static final native long CMMCore_getConfigState(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native long CMMCore_getConfigGroupState(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_saveSystemState(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_loadSystemState(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_saveSystemConfiguration(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_loadSystemConfiguration(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_registerCallback(long var0, CMMCore var2, long var3, MMEventCallback var5);

    public static final native void CMMCore_setPrimaryLogFile__SWIG_0(long var0, CMMCore var2, String var3, boolean var4) throws Exception;

    public static final native void CMMCore_setPrimaryLogFile__SWIG_1(long var0, CMMCore var2, String var3) throws Exception;

    public static final native String CMMCore_getPrimaryLogFile(long var0, CMMCore var2);

    public static final native void CMMCore_logMessage__SWIG_0(long var0, CMMCore var2, String var3);

    public static final native void CMMCore_logMessage__SWIG_1(long var0, CMMCore var2, String var3, boolean var4);

    public static final native void CMMCore_enableDebugLog(long var0, CMMCore var2, boolean var3);

    public static final native boolean CMMCore_debugLogEnabled(long var0, CMMCore var2);

    public static final native void CMMCore_enableStderrLog(long var0, CMMCore var2, boolean var3);

    public static final native boolean CMMCore_stderrLogEnabled(long var0, CMMCore var2);

    public static final native int CMMCore_startSecondaryLogFile__SWIG_0(long var0, CMMCore var2, String var3, boolean var4, boolean var5, boolean var6) throws Exception;

    public static final native int CMMCore_startSecondaryLogFile__SWIG_1(long var0, CMMCore var2, String var3, boolean var4, boolean var5) throws Exception;

    public static final native int CMMCore_startSecondaryLogFile__SWIG_2(long var0, CMMCore var2, String var3, boolean var4) throws Exception;

    public static final native void CMMCore_stopSecondaryLogFile(long var0, CMMCore var2, int var3) throws Exception;

    public static final native long CMMCore_getDeviceAdapterSearchPaths(long var0, CMMCore var2);

    public static final native void CMMCore_setDeviceAdapterSearchPaths(long var0, CMMCore var2, long var3, StrVector var5);

    public static final native void CMMCore_addSearchPath(String var0);

    public static final native long CMMCore_getDeviceAdapterNames(long var0, CMMCore var2) throws Exception;

    public static final native long CMMCore_getDeviceLibraries() throws Exception;

    public static final native long CMMCore_getAvailableDevices(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getAvailableDeviceDescriptions(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getAvailableDeviceTypes(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getLoadedDevices(long var0, CMMCore var2);

    public static final native long CMMCore_getLoadedDevicesOfType(long var0, CMMCore var2, int var3);

    public static final native int CMMCore_getDeviceType(long var0, CMMCore var2, String var3) throws Exception;

    public static final native String CMMCore_getDeviceLibrary(long var0, CMMCore var2, String var3) throws Exception;

    public static final native String CMMCore_getDeviceName(long var0, CMMCore var2, String var3) throws Exception;

    public static final native String CMMCore_getDeviceDescription(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getDevicePropertyNames(long var0, CMMCore var2, String var3) throws Exception;

    public static final native boolean CMMCore_hasProperty(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native String CMMCore_getProperty(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native void CMMCore_setProperty__SWIG_0(long var0, CMMCore var2, String var3, String var4, String var5) throws Exception;

    public static final native void CMMCore_setProperty__SWIG_1(long var0, CMMCore var2, String var3, String var4, boolean var5) throws Exception;

    public static final native void CMMCore_setProperty__SWIG_2(long var0, CMMCore var2, String var3, String var4, int var5) throws Exception;

    public static final native void CMMCore_setProperty__SWIG_3(long var0, CMMCore var2, String var3, String var4, float var5) throws Exception;

    public static final native void CMMCore_setProperty__SWIG_4(long var0, CMMCore var2, String var3, String var4, double var5) throws Exception;

    public static final native long CMMCore_getAllowedPropertyValues(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native boolean CMMCore_isPropertyReadOnly(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native boolean CMMCore_isPropertyPreInit(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native boolean CMMCore_isPropertySequenceable(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native boolean CMMCore_hasPropertyLimits(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native double CMMCore_getPropertyLowerLimit(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native double CMMCore_getPropertyUpperLimit(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native int CMMCore_getPropertyType(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native void CMMCore_startPropertySequence(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native void CMMCore_stopPropertySequence(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native int CMMCore_getPropertySequenceMaxLength(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native void CMMCore_loadPropertySequence(long var0, CMMCore var2, String var3, String var4, long var5, StrVector var7) throws Exception;

    public static final native boolean CMMCore_deviceBusy(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_waitForDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_waitForConfig(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native boolean CMMCore_systemBusy(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_waitForSystem(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_waitForImageSynchro(long var0, CMMCore var2) throws Exception;

    public static final native boolean CMMCore_deviceTypeBusy(long var0, CMMCore var2, int var3) throws Exception;

    public static final native void CMMCore_waitForDeviceType(long var0, CMMCore var2, int var3) throws Exception;

    public static final native double CMMCore_getDeviceDelayMs(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setDeviceDelayMs(long var0, CMMCore var2, String var3, double var4) throws Exception;

    public static final native boolean CMMCore_usesDeviceDelay(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setTimeoutMs(long var0, CMMCore var2, int var3);

    public static final native int CMMCore_getTimeoutMs(long var0, CMMCore var2);

    public static final native void CMMCore_sleep(long var0, CMMCore var2, double var3);

    public static final native String CMMCore_getCameraDevice(long var0, CMMCore var2);

    public static final native String CMMCore_getShutterDevice(long var0, CMMCore var2);

    public static final native String CMMCore_getFocusDevice(long var0, CMMCore var2);

    public static final native String CMMCore_getXYStageDevice(long var0, CMMCore var2);

    public static final native String CMMCore_getAutoFocusDevice(long var0, CMMCore var2);

    public static final native String CMMCore_getImageProcessorDevice(long var0, CMMCore var2);

    public static final native String CMMCore_getSLMDevice(long var0, CMMCore var2);

    public static final native String CMMCore_getGalvoDevice(long var0, CMMCore var2);

    public static final native String CMMCore_getChannelGroup(long var0, CMMCore var2);

    public static final native void CMMCore_setCameraDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setShutterDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setFocusDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setXYStageDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setAutoFocusDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setImageProcessorDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setSLMDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setGalvoDevice(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setChannelGroup(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getSystemStateCache(long var0, CMMCore var2);

    public static final native void CMMCore_updateSystemStateCache(long var0, CMMCore var2);

    public static final native String CMMCore_getPropertyFromCache(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native String CMMCore_getCurrentConfigFromCache(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getConfigGroupStateFromCache(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_defineConfig__SWIG_0(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native void CMMCore_defineConfig__SWIG_1(long var0, CMMCore var2, String var3, String var4, String var5, String var6, String var7) throws Exception;

    public static final native void CMMCore_defineConfigGroup(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_deleteConfigGroup(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_renameConfigGroup(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native boolean CMMCore_isGroupDefined(long var0, CMMCore var2, String var3);

    public static final native boolean CMMCore_isConfigDefined(long var0, CMMCore var2, String var3, String var4);

    public static final native void CMMCore_setConfig(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native void CMMCore_deleteConfig__SWIG_0(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native void CMMCore_deleteConfig__SWIG_1(long var0, CMMCore var2, String var3, String var4, String var5, String var6) throws Exception;

    public static final native void CMMCore_renameConfig(long var0, CMMCore var2, String var3, String var4, String var5) throws Exception;

    public static final native long CMMCore_getAvailableConfigGroups(long var0, CMMCore var2);

    public static final native long CMMCore_getAvailableConfigs(long var0, CMMCore var2, String var3);

    public static final native String CMMCore_getCurrentConfig(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getConfigData(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native String CMMCore_getCurrentPixelSizeConfig__SWIG_0(long var0, CMMCore var2) throws Exception;

    public static final native String CMMCore_getCurrentPixelSizeConfig__SWIG_1(long var0, CMMCore var2, boolean var3) throws Exception;

    public static final native double CMMCore_getPixelSizeUm__SWIG_0(long var0, CMMCore var2);

    public static final native double CMMCore_getPixelSizeUm__SWIG_1(long var0, CMMCore var2, boolean var3);

    public static final native double CMMCore_getPixelSizeUmByID(long var0, CMMCore var2, String var3) throws Exception;

    public static final native double CMMCore_getMagnificationFactor(long var0, CMMCore var2);

    public static final native void CMMCore_setPixelSizeUm(long var0, CMMCore var2, String var3, double var4) throws Exception;

    public static final native void CMMCore_definePixelSizeConfig__SWIG_0(long var0, CMMCore var2, String var3, String var4, String var5, String var6) throws Exception;

    public static final native void CMMCore_definePixelSizeConfig__SWIG_1(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getAvailablePixelSizeConfigs(long var0, CMMCore var2);

    public static final native boolean CMMCore_isPixelSizeConfigDefined(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setPixelSizeConfig(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_renamePixelSizeConfig(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native void CMMCore_deletePixelSizeConfig(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getPixelSizeConfigData(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_definePropertyBlock(long var0, CMMCore var2, String var3, String var4, String var5);

    public static final native long CMMCore_getAvailablePropertyBlocks(long var0, CMMCore var2);

    public static final native long CMMCore_getPropertyBlockData(long var0, CMMCore var2, String var3);

    public static final native void CMMCore_setROI(long var0, CMMCore var2, int var3, int var4, int var5, int var6) throws Exception;

    public static final native void CMMCore_getROI__SWIG_0(long var0, CMMCore var2, int[] var3, int[] var4, int[] var5, int[] var6) throws Exception;

    public static final native void CMMCore_getROI__SWIG_1(long var0, CMMCore var2, String var3, int[] var4, int[] var5, int[] var6, int[] var7) throws Exception;

    public static final native void CMMCore_clearROI(long var0, CMMCore var2) throws Exception;

    public static final native boolean CMMCore_isMultiROISupported(long var0, CMMCore var2) throws Exception;

    public static final native boolean CMMCore_isMultiROIEnabled(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_setMultiROI(long var0, CMMCore var2, long var3, UnsignedVector var5, long var6, UnsignedVector var8, long var9, UnsignedVector var11, long var12, UnsignedVector var14) throws Exception;

    public static final native void CMMCore_getMultiROI(long var0, CMMCore var2, long var3, UnsignedVector var5, long var6, UnsignedVector var8, long var9, UnsignedVector var11, long var12, UnsignedVector var14) throws Exception;

    public static final native void CMMCore_setExposure__SWIG_0(long var0, CMMCore var2, double var3) throws Exception;

    public static final native void CMMCore_setExposure__SWIG_1(long var0, CMMCore var2, String var3, double var4) throws Exception;

    public static final native double CMMCore_getExposure(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_snapImage(long var0, CMMCore var2) throws Exception;

    public static final native Object CMMCore_getImage__SWIG_0(long var0, CMMCore var2) throws Exception;

    public static final native Object CMMCore_getImage__SWIG_1(long var0, CMMCore var2, long var3) throws Exception;

    public static final native long CMMCore_getImageWidth(long var0, CMMCore var2);

    public static final native long CMMCore_getImageHeight(long var0, CMMCore var2);

    public static final native long CMMCore_getBytesPerPixel(long var0, CMMCore var2);

    public static final native long CMMCore_getImageBitDepth(long var0, CMMCore var2);

    public static final native long CMMCore_getNumberOfComponents(long var0, CMMCore var2);

    public static final native long CMMCore_getNumberOfCameraChannels(long var0, CMMCore var2);

    public static final native String CMMCore_getCameraChannelName(long var0, CMMCore var2, long var3);

    public static final native int CMMCore_getImageBufferSize(long var0, CMMCore var2);

    public static final native void CMMCore_assignImageSynchro(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_removeImageSynchro(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_removeImageSynchroAll(long var0, CMMCore var2);

    public static final native void CMMCore_setAutoShutter(long var0, CMMCore var2, boolean var3);

    public static final native boolean CMMCore_getAutoShutter(long var0, CMMCore var2);

    public static final native void CMMCore_setShutterOpen__SWIG_0(long var0, CMMCore var2, boolean var3) throws Exception;

    public static final native boolean CMMCore_getShutterOpen__SWIG_0(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_setShutterOpen__SWIG_1(long var0, CMMCore var2, String var3, boolean var4) throws Exception;

    public static final native boolean CMMCore_getShutterOpen__SWIG_1(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_startSequenceAcquisition__SWIG_0(long var0, CMMCore var2, int var3, double var4, boolean var6) throws Exception;

    public static final native void CMMCore_startSequenceAcquisition__SWIG_1(long var0, CMMCore var2, String var3, int var4, double var5, boolean var7) throws Exception;

    public static final native void CMMCore_prepareSequenceAcquisition(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_startContinuousSequenceAcquisition(long var0, CMMCore var2, double var3) throws Exception;

    public static final native void CMMCore_stopSequenceAcquisition__SWIG_0(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_stopSequenceAcquisition__SWIG_1(long var0, CMMCore var2, String var3) throws Exception;

    public static final native boolean CMMCore_isSequenceRunning__SWIG_0(long var0, CMMCore var2);

    public static final native boolean CMMCore_isSequenceRunning__SWIG_1(long var0, CMMCore var2, String var3) throws Exception;

    public static final native Object CMMCore_getLastImage(long var0, CMMCore var2) throws Exception;

    public static final native Object CMMCore_popNextImage(long var0, CMMCore var2) throws Exception;

    public static final native Object CMMCore_getLastImageMD__SWIG_0(long var0, CMMCore var2, long var3, long var5, long var7, Metadata var9) throws Exception;

    public static final native Object CMMCore_popNextImageMD__SWIG_0(long var0, CMMCore var2, long var3, long var5, long var7, Metadata var9) throws Exception;

    public static final native Object CMMCore_getLastImageMD__SWIG_1(long var0, CMMCore var2, long var3, Metadata var5) throws Exception;

    public static final native Object CMMCore_getNBeforeLastImageMD(long var0, CMMCore var2, long var3, long var5, Metadata var7) throws Exception;

    public static final native Object CMMCore_popNextImageMD__SWIG_1(long var0, CMMCore var2, long var3, Metadata var5) throws Exception;

    public static final native int CMMCore_getRemainingImageCount(long var0, CMMCore var2);

    public static final native int CMMCore_getBufferTotalCapacity(long var0, CMMCore var2);

    public static final native int CMMCore_getBufferFreeCapacity(long var0, CMMCore var2);

    public static final native boolean CMMCore_isBufferOverflowed(long var0, CMMCore var2);

    public static final native void CMMCore_setCircularBufferMemoryFootprint(long var0, CMMCore var2, long var3) throws Exception;

    public static final native long CMMCore_getCircularBufferMemoryFootprint(long var0, CMMCore var2);

    public static final native void CMMCore_initializeCircularBuffer(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_clearCircularBuffer(long var0, CMMCore var2) throws Exception;

    public static final native boolean CMMCore_isExposureSequenceable(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_startExposureSequence(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_stopExposureSequence(long var0, CMMCore var2, String var3) throws Exception;

    public static final native int CMMCore_getExposureSequenceMaxLength(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_loadExposureSequence(long var0, CMMCore var2, String var3, long var4, DoubleVector var6) throws Exception;

    public static final native double CMMCore_getLastFocusScore(long var0, CMMCore var2);

    public static final native double CMMCore_getCurrentFocusScore(long var0, CMMCore var2);

    public static final native void CMMCore_enableContinuousFocus(long var0, CMMCore var2, boolean var3) throws Exception;

    public static final native boolean CMMCore_isContinuousFocusEnabled(long var0, CMMCore var2) throws Exception;

    public static final native boolean CMMCore_isContinuousFocusLocked(long var0, CMMCore var2) throws Exception;

    public static final native boolean CMMCore_isContinuousFocusDrive(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_fullFocus(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_incrementalFocus(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_setAutoFocusOffset(long var0, CMMCore var2, double var3) throws Exception;

    public static final native double CMMCore_getAutoFocusOffset(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_setState(long var0, CMMCore var2, String var3, int var4) throws Exception;

    public static final native int CMMCore_getState(long var0, CMMCore var2, String var3) throws Exception;

    public static final native int CMMCore_getNumberOfStates(long var0, CMMCore var2, String var3);

    public static final native void CMMCore_setStateLabel(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native String CMMCore_getStateLabel(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_defineStateLabel(long var0, CMMCore var2, String var3, int var4, String var5) throws Exception;

    public static final native long CMMCore_getStateLabels(long var0, CMMCore var2, String var3) throws Exception;

    public static final native int CMMCore_getStateFromLabel(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native long CMMCore_getStateLabelData(long var0, CMMCore var2, String var3, String var4);

    public static final native long CMMCore_getData(long var0, CMMCore var2, String var3);

    public static final native void CMMCore_setPosition__SWIG_0(long var0, CMMCore var2, String var3, double var4) throws Exception;

    public static final native void CMMCore_setPosition__SWIG_1(long var0, CMMCore var2, double var3) throws Exception;

    public static final native double CMMCore_getPosition__SWIG_0(long var0, CMMCore var2, String var3) throws Exception;

    public static final native double CMMCore_getPosition__SWIG_1(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_setRelativePosition__SWIG_0(long var0, CMMCore var2, String var3, double var4) throws Exception;

    public static final native void CMMCore_setRelativePosition__SWIG_1(long var0, CMMCore var2, double var3) throws Exception;

    public static final native void CMMCore_setOrigin__SWIG_0(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setOrigin__SWIG_1(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_setAdapterOrigin__SWIG_0(long var0, CMMCore var2, String var3, double var4) throws Exception;

    public static final native void CMMCore_setAdapterOrigin__SWIG_1(long var0, CMMCore var2, double var3) throws Exception;

    public static final native void CMMCore_setFocusDirection(long var0, CMMCore var2, String var3, int var4);

    public static final native int CMMCore_getFocusDirection(long var0, CMMCore var2, String var3) throws Exception;

    public static final native boolean CMMCore_isStageSequenceable(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_startStageSequence(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_stopStageSequence(long var0, CMMCore var2, String var3) throws Exception;

    public static final native int CMMCore_getStageSequenceMaxLength(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_loadStageSequence(long var0, CMMCore var2, String var3, long var4, DoubleVector var6) throws Exception;

    public static final native void CMMCore_setXYPosition__SWIG_0(long var0, CMMCore var2, String var3, double var4, double var6) throws Exception;

    public static final native void CMMCore_setXYPosition__SWIG_1(long var0, CMMCore var2, double var3, double var5) throws Exception;

    public static final native void CMMCore_setRelativeXYPosition__SWIG_0(long var0, CMMCore var2, String var3, double var4, double var6) throws Exception;

    public static final native void CMMCore_setRelativeXYPosition__SWIG_1(long var0, CMMCore var2, double var3, double var5) throws Exception;

    public static final native void CMMCore_getXYPosition__SWIG_0(long var0, CMMCore var2, String var3, double[] var4, double[] var5) throws Exception;

    public static final native void CMMCore_getXYPosition__SWIG_1(long var0, CMMCore var2, double[] var3, double[] var4) throws Exception;

    public static final native double CMMCore_getXPosition__SWIG_0(long var0, CMMCore var2, String var3) throws Exception;

    public static final native double CMMCore_getYPosition__SWIG_0(long var0, CMMCore var2, String var3) throws Exception;

    public static final native double CMMCore_getXPosition__SWIG_1(long var0, CMMCore var2) throws Exception;

    public static final native double CMMCore_getYPosition__SWIG_1(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_stop(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_home(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setOriginXY__SWIG_0(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setOriginXY__SWIG_1(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_setOriginX__SWIG_0(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setOriginX__SWIG_1(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_setOriginY__SWIG_0(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setOriginY__SWIG_1(long var0, CMMCore var2) throws Exception;

    public static final native void CMMCore_setAdapterOriginXY__SWIG_0(long var0, CMMCore var2, String var3, double var4, double var6) throws Exception;

    public static final native void CMMCore_setAdapterOriginXY__SWIG_1(long var0, CMMCore var2, double var3, double var5) throws Exception;

    public static final native boolean CMMCore_isXYStageSequenceable(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_startXYStageSequence(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_stopXYStageSequence(long var0, CMMCore var2, String var3) throws Exception;

    public static final native int CMMCore_getXYStageSequenceMaxLength(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_loadXYStageSequence(long var0, CMMCore var2, String var3, long var4, DoubleVector var6, long var7, DoubleVector var9) throws Exception;

    public static final native void CMMCore_setSerialProperties(long var0, CMMCore var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9) throws Exception;

    public static final native void CMMCore_setSerialPortCommand(long var0, CMMCore var2, String var3, String var4, String var5) throws Exception;

    public static final native String CMMCore_getSerialPortAnswer(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native void CMMCore_writeToSerialPort(long var0, CMMCore var2, String var3, long var4, CharVector var6) throws Exception;

    public static final native long CMMCore_readFromSerialPort(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setSLMImage__SWIG_0(long var0, CMMCore var2, String var3, byte[] var4) throws Exception;

    public static final native void CMMCore_setSLMImage__SWIG_1(long var0, CMMCore var2, String var3, int[] var4) throws Exception;

    public static final native void CMMCore_setSLMPixelsTo__SWIG_0(long var0, CMMCore var2, String var3, short var4) throws Exception;

    public static final native void CMMCore_setSLMPixelsTo__SWIG_1(long var0, CMMCore var2, String var3, short var4, short var5, short var6) throws Exception;

    public static final native void CMMCore_displaySLMImage(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setSLMExposure(long var0, CMMCore var2, String var3, double var4) throws Exception;

    public static final native double CMMCore_getSLMExposure(long var0, CMMCore var2, String var3) throws Exception;

    public static final native long CMMCore_getSLMWidth(long var0, CMMCore var2, String var3);

    public static final native long CMMCore_getSLMHeight(long var0, CMMCore var2, String var3);

    public static final native long CMMCore_getSLMNumberOfComponents(long var0, CMMCore var2, String var3);

    public static final native long CMMCore_getSLMBytesPerPixel(long var0, CMMCore var2, String var3);

    public static final native int CMMCore_getSLMSequenceMaxLength(long var0, CMMCore var2, String var3);

    public static final native void CMMCore_startSLMSequence(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_stopSLMSequence(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_loadSLMSequence(long var0, CMMCore var2, String var3, List<byte[]> var4) throws Exception;

    public static final native void CMMCore_pointGalvoAndFire(long var0, CMMCore var2, String var3, double var4, double var6, double var8) throws Exception;

    public static final native void CMMCore_setGalvoSpotInterval(long var0, CMMCore var2, String var3, double var4) throws Exception;

    public static final native void CMMCore_setGalvoPosition(long var0, CMMCore var2, String var3, double var4, double var6) throws Exception;

    public static final native void CMMCore_getGalvoPosition(long var0, CMMCore var2, String var3, double[] var4, double[] var5) throws Exception;

    public static final native void CMMCore_setGalvoIlluminationState(long var0, CMMCore var2, String var3, boolean var4) throws Exception;

    public static final native double CMMCore_getGalvoXRange(long var0, CMMCore var2, String var3) throws Exception;

    public static final native double CMMCore_getGalvoXMinimum(long var0, CMMCore var2, String var3) throws Exception;

    public static final native double CMMCore_getGalvoYRange(long var0, CMMCore var2, String var3) throws Exception;

    public static final native double CMMCore_getGalvoYMinimum(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_addGalvoPolygonVertex(long var0, CMMCore var2, String var3, int var4, double var5, double var7) throws Exception;

    public static final native void CMMCore_deleteGalvoPolygons(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_loadGalvoPolygons(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setGalvoPolygonRepetitions(long var0, CMMCore var2, String var3, int var4) throws Exception;

    public static final native void CMMCore_runGalvoPolygons(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_runGalvoSequence(long var0, CMMCore var2, String var3) throws Exception;

    public static final native String CMMCore_getGalvoChannel(long var0, CMMCore var2, String var3) throws Exception;

    public static final native boolean CMMCore_supportsDeviceDetection(long var0, CMMCore var2, String var3);

    public static final native int CMMCore_detectDevice(long var0, CMMCore var2, String var3);

    public static final native String CMMCore_getParentLabel(long var0, CMMCore var2, String var3) throws Exception;

    public static final native void CMMCore_setParentLabel(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native long CMMCore_getInstalledDevices(long var0, CMMCore var2, String var3) throws Exception;

    public static final native String CMMCore_getInstalledDeviceDescription(long var0, CMMCore var2, String var3, String var4) throws Exception;

    public static final native long CMMCore_getLoadedPeripheralDevices(long var0, CMMCore var2, String var3) throws Exception;

    public static final native String CMMCore_getUserId(long var0, CMMCore var2);

    public static final native String CMMCore_getHostName(long var0, CMMCore var2);

    public static final native long CMMCore_getMACAddresses(long var0, CMMCore var2);

    public static final native long new_MetadataError(String var0);

    public static final native void delete_MetadataError(long var0);

    public static final native String MetadataError_getMsg(long var0, MetadataError var2);

    public static final native void delete_MetadataTag(long var0);

    public static final native String MetadataTag_GetDevice(long var0, MetadataTag var2);

    public static final native String MetadataTag_GetName(long var0, MetadataTag var2);

    public static final native String MetadataTag_GetQualifiedName(long var0, MetadataTag var2);

    public static final native boolean MetadataTag_IsReadOnly(long var0, MetadataTag var2);

    public static final native void MetadataTag_SetDevice(long var0, MetadataTag var2, String var3);

    public static final native void MetadataTag_SetName(long var0, MetadataTag var2, String var3);

    public static final native void MetadataTag_SetReadOnly(long var0, MetadataTag var2, boolean var3);

    public static final native long MetadataTag_ToSingleTag(long var0, MetadataTag var2);

    public static final native long MetadataTag_ToArrayTag(long var0, MetadataTag var2);

    public static final native long MetadataTag_Clone(long var0, MetadataTag var2);

    public static final native String MetadataTag_Serialize(long var0, MetadataTag var2);

    public static final native boolean MetadataTag_Restore(long var0, MetadataTag var2, String var3);

    public static final native long new_MetadataSingleTag__SWIG_0();

    public static final native long new_MetadataSingleTag__SWIG_1(String var0, String var1, boolean var2);

    public static final native void delete_MetadataSingleTag(long var0);

    public static final native String MetadataSingleTag_GetValue(long var0, MetadataSingleTag var2);

    public static final native void MetadataSingleTag_SetValue(long var0, MetadataSingleTag var2, String var3);

    public static final native long MetadataSingleTag_ToSingleTag(long var0, MetadataSingleTag var2);

    public static final native long MetadataSingleTag_Clone(long var0, MetadataSingleTag var2);

    public static final native String MetadataSingleTag_Serialize(long var0, MetadataSingleTag var2);

    public static final native boolean MetadataSingleTag_Restore(long var0, MetadataSingleTag var2, String var3);

    public static final native long new_MetadataArrayTag();

    public static final native void delete_MetadataArrayTag(long var0);

    public static final native long MetadataArrayTag_ToArrayTag(long var0, MetadataArrayTag var2);

    public static final native void MetadataArrayTag_AddValue(long var0, MetadataArrayTag var2, String var3);

    public static final native void MetadataArrayTag_SetValue(long var0, MetadataArrayTag var2, String var3, long var4);

    public static final native String MetadataArrayTag_GetValue(long var0, MetadataArrayTag var2, long var3);

    public static final native long MetadataArrayTag_GetSize(long var0, MetadataArrayTag var2);

    public static final native long MetadataArrayTag_Clone(long var0, MetadataArrayTag var2);

    public static final native String MetadataArrayTag_Serialize(long var0, MetadataArrayTag var2);

    public static final native boolean MetadataArrayTag_Restore(long var0, MetadataArrayTag var2, String var3);

    public static final native long new_Metadata__SWIG_0();

    public static final native void delete_Metadata(long var0);

    public static final native long new_Metadata__SWIG_1(long var0, Metadata var2);

    public static final native void Metadata_Clear(long var0, Metadata var2);

    public static final native long Metadata_GetKeys(long var0, Metadata var2);

    public static final native boolean Metadata_HasTag(long var0, Metadata var2, String var3);

    public static final native long Metadata_GetSingleTag(long var0, Metadata var2, String var3) throws Exception;

    public static final native long Metadata_GetArrayTag(long var0, Metadata var2, String var3) throws Exception;

    public static final native void Metadata_SetTag(long var0, Metadata var2, long var3, MetadataTag var5);

    public static final native void Metadata_RemoveTag(long var0, Metadata var2, String var3);

    public static final native void Metadata_Merge(long var0, Metadata var2, long var3, Metadata var5);

    public static final native String Metadata_Serialize(long var0, Metadata var2);

    public static final native String Metadata_readLine(long var0, Metadata var2, long var3);

    public static final native boolean Metadata_Restore(long var0, Metadata var2, String var3);

    public static final native String Metadata_Dump(long var0, Metadata var2);

    public static final native long new_MMEventCallback();

    public static final native void delete_MMEventCallback(long var0);

    public static final native void MMEventCallback_onPropertiesChanged(long var0, MMEventCallback var2);

    public static final native void MMEventCallback_onPropertiesChangedSwigExplicitMMEventCallback(long var0, MMEventCallback var2);

    public static final native void MMEventCallback_onPropertyChanged(long var0, MMEventCallback var2, String var3, String var4, String var5);

    public static final native void MMEventCallback_onPropertyChangedSwigExplicitMMEventCallback(long var0, MMEventCallback var2, String var3, String var4, String var5);

    public static final native void MMEventCallback_onConfigGroupChanged(long var0, MMEventCallback var2, String var3, String var4);

    public static final native void MMEventCallback_onConfigGroupChangedSwigExplicitMMEventCallback(long var0, MMEventCallback var2, String var3, String var4);

    public static final native void MMEventCallback_onSystemConfigurationLoaded(long var0, MMEventCallback var2);

    public static final native void MMEventCallback_onSystemConfigurationLoadedSwigExplicitMMEventCallback(long var0, MMEventCallback var2);

    public static final native void MMEventCallback_onPixelSizeChanged(long var0, MMEventCallback var2, double var3);

    public static final native void MMEventCallback_onPixelSizeChangedSwigExplicitMMEventCallback(long var0, MMEventCallback var2, double var3);

    public static final native void MMEventCallback_onStagePositionChanged(long var0, MMEventCallback var2, String var3, double var4);

    public static final native void MMEventCallback_onStagePositionChangedSwigExplicitMMEventCallback(long var0, MMEventCallback var2, String var3, double var4);

    public static final native void MMEventCallback_onXYStagePositionChanged(long var0, MMEventCallback var2, String var3, double var4, double var6);

    public static final native void MMEventCallback_onXYStagePositionChangedSwigExplicitMMEventCallback(long var0, MMEventCallback var2, String var3, double var4, double var6);

    public static final native void MMEventCallback_onExposureChanged(long var0, MMEventCallback var2, String var3, double var4);

    public static final native void MMEventCallback_onExposureChangedSwigExplicitMMEventCallback(long var0, MMEventCallback var2, String var3, double var4);

    public static final native void MMEventCallback_onSLMExposureChanged(long var0, MMEventCallback var2, String var3, double var4);

    public static final native void MMEventCallback_onSLMExposureChangedSwigExplicitMMEventCallback(long var0, MMEventCallback var2, String var3, double var4);

    public static final native void MMEventCallback_director_connect(MMEventCallback var0, long var1, boolean var3, boolean var4);

    public static final native void MMEventCallback_change_ownership(MMEventCallback var0, long var1, boolean var3);

    public static final native long MetadataSingleTag_SWIGUpcast(long var0);

    public static final native long MetadataArrayTag_SWIGUpcast(long var0);

    public static void SwigDirector_MMEventCallback_onPropertiesChanged(MMEventCallback jself) {
        jself.onPropertiesChanged();
    }

    public static void SwigDirector_MMEventCallback_onPropertyChanged(MMEventCallback jself, String name, String propName, String propValue) {
        jself.onPropertyChanged(name, propName, propValue);
    }

    public static void SwigDirector_MMEventCallback_onConfigGroupChanged(MMEventCallback jself, String groupName, String newConfigName) {
        jself.onConfigGroupChanged(groupName, newConfigName);
    }

    public static void SwigDirector_MMEventCallback_onSystemConfigurationLoaded(MMEventCallback jself) {
        jself.onSystemConfigurationLoaded();
    }

    public static void SwigDirector_MMEventCallback_onPixelSizeChanged(MMEventCallback jself, double newPixelSizeUm) {
        jself.onPixelSizeChanged(newPixelSizeUm);
    }

    public static void SwigDirector_MMEventCallback_onStagePositionChanged(MMEventCallback jself, String name, double pos) {
        jself.onStagePositionChanged(name, pos);
    }

    public static void SwigDirector_MMEventCallback_onXYStagePositionChanged(MMEventCallback jself, String name, double xpos, double ypos) {
        jself.onXYStagePositionChanged(name, xpos, ypos);
    }

    public static void SwigDirector_MMEventCallback_onExposureChanged(MMEventCallback jself, String name, double newExposure) {
        jself.onExposureChanged(name, newExposure);
    }

    public static void SwigDirector_MMEventCallback_onSLMExposureChanged(MMEventCallback jself, String name, double newExposure) {
        jself.onSLMExposureChanged(name, newExposure);
    }

    private static final native void swig_module_init();

    static {
        MMCoreJJNI.logLibraryLoading("Start loading...");
        if (!(MMCoreJJNI.checkIfAlreadyLoaded() || MMCoreJJNI.loadFromPathSetBySystemProperty() || MMCoreJJNI.loadFromHardCodedPaths())) {
            MMCoreJJNI.logLibraryLoading("Falling back to loading using system default method");
            try {
                System.loadLibrary(NATIVE_LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError e) {
                MMCoreJJNI.logLibraryLoading("System default loading method failed");
            }
        }
        MMCoreJJNI.swig_module_init();
    }

    private static class FijiPaths {
        private FijiPaths() {
        }

        private static String URLtoFilePath(URL url) throws Exception {
            String url1 = URLDecoder.decode(url.getPath(), "UTF-8");
            String url2 = URLDecoder.decode(new URL(url1).getPath(), "UTF-8");
            return new File(url2).getAbsolutePath();
        }

        private static String getJarPath() {
            String classFile = "/mmcorej/CMMCore.class";
            try {
                String path = FijiPaths.URLtoFilePath(CMMCore.class.getResource(classFile));
                int bang = path.indexOf(33);
                if (bang >= 0) {
                    path = path.substring(0, bang);
                }
                return path;
            }
            catch (Exception e) {
                return "";
            }
        }

        private static String getPlatformString() {
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            return osName.startsWith("Mac") ? "macosx" : (osName.startsWith("Win") ? "win" : osName.toLowerCase()) + (osArch.indexOf("64") < 0 ? "32" : "64");
        }

        public static List<File> getPaths() {
            File jarDir = new File(FijiPaths.getJarPath()).getParentFile();
            File jarDirParent = jarDir.getParentFile();
            File jarDirGrandParent = jarDirParent.getParentFile();
            String fijiPlatform = FijiPaths.getPlatformString();
            File jarDirParentFiji = new File(new File(jarDirParent, "mm"), fijiPlatform);
            File jarDirGrandParentFiji = new File(new File(jarDirGrandParent, "mm"), fijiPlatform);
            ArrayList<File> searchPaths = new ArrayList<File>();
            searchPaths.add(jarDir);
            searchPaths.add(jarDirParent);
            searchPaths.add(jarDirParentFiji);
            searchPaths.add(jarDirGrandParent);
            searchPaths.add(jarDirGrandParentFiji);
            return searchPaths;
        }
    }
}

