/*
 * Decompiled with CFR 0.152.
 */
package mmcorej;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import mmcorej.CharVector;
import mmcorej.Configuration;
import mmcorej.DeviceDetectionStatus;
import mmcorej.DeviceType;
import mmcorej.DoubleVector;
import mmcorej.LongVector;
import mmcorej.MMCoreJJNI;
import mmcorej.MMEventCallback;
import mmcorej.Metadata;
import mmcorej.PropertyBlock;
import mmcorej.PropertySetting;
import mmcorej.PropertyType;
import mmcorej.StrVector;
import mmcorej.TaggedImage;
import mmcorej.UnsignedVector;
import org.json.JSONObject;

public class CMMCore {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CMMCore(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CMMCore obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MMCoreJJNI.delete_CMMCore(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    private JSONObject metadataToMap(Metadata md) {
        JSONObject tags = new JSONObject();
        for (String key : md.GetKeys()) {
            try {
                tags.put(key, md.GetSingleTag(key).GetValue());
            }
            catch (Exception exception) {}
        }
        return tags;
    }

    private String getROITag() throws Exception {
        String roi = "";
        int[] x = new int[1];
        int[] y = new int[1];
        int[] xSize = new int[1];
        int[] ySize = new int[1];
        this.getROI(x, y, xSize, ySize);
        roi = roi + x[0] + "-" + y[0] + "-" + xSize[0] + "-" + ySize[0];
        return roi;
    }

    private String getPixelType() {
        int depth = (int)this.getBytesPerPixel();
        switch (depth) {
            case 1: {
                return "GRAY8";
            }
            case 2: {
                return "GRAY16";
            }
            case 4: {
                return "RGB32";
            }
            case 8: {
                return "RGB64";
            }
        }
        return "";
    }

    private String getMultiCameraChannel(JSONObject tags, int cameraChannelIndex) {
        try {
            String camera = tags.getString("Core-Camera");
            String physCamKey = camera + "-Physical Camera " + (1 + cameraChannelIndex);
            if (tags.has(physCamKey)) {
                try {
                    return tags.getString(physCamKey);
                }
                catch (Exception e2) {
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private TaggedImage createTaggedImage(Object pixels, Metadata md, int cameraChannelIndex) throws Exception {
        String physicalCamera;
        TaggedImage image = this.createTaggedImage(pixels, md);
        JSONObject tags = image.tags;
        if (!tags.has("CameraChannelIndex")) {
            tags.put("CameraChannelIndex", cameraChannelIndex);
            tags.put("ChannelIndex", cameraChannelIndex);
        }
        if (!tags.has("Camera") && (physicalCamera = this.getMultiCameraChannel(tags, cameraChannelIndex)) != null) {
            tags.put("Camera", physicalCamera);
            tags.put("Channel", physicalCamera);
        }
        return image;
    }

    private TaggedImage createTaggedImage(Object pixels, Metadata md) throws Exception {
        JSONObject tags = this.metadataToMap(md);
        Configuration config = this.getSystemStateCache();
        int i = 0;
        while ((long)i < config.size()) {
            PropertySetting setting = config.getSetting(i);
            String key = setting.getDeviceLabel() + "-" + setting.getPropertyName();
            String value = setting.getPropertyValue();
            tags.put(key, value);
            ++i;
        }
        tags.put("BitDepth", this.getImageBitDepth());
        tags.put("PixelSizeUm", this.getPixelSizeUm(true));
        tags.put("ROI", this.getROITag());
        tags.put("Width", this.getImageWidth());
        tags.put("Height", this.getImageHeight());
        tags.put("PixelType", this.getPixelType());
        tags.put("Frame", 0);
        tags.put("FrameIndex", 0);
        tags.put("Position", "Default");
        tags.put("PositionIndex", 0);
        tags.put("Slice", 0);
        tags.put("SliceIndex", 0);
        String channel = this.getCurrentConfigFromCache(this.getPropertyFromCache("Core", "ChannelGroup"));
        if (channel == null || channel.length() == 0) {
            channel = "Default";
        }
        tags.put("Channel", channel);
        tags.put("ChannelIndex", 0);
        try {
            tags.put("Binning", this.getProperty(this.getCameraDevice(), "Binning"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TaggedImage(pixels, tags);
    }

    public TaggedImage getTaggedImage(int cameraChannelIndex) throws Exception {
        Metadata md = new Metadata();
        Object pixels = this.getImage(cameraChannelIndex);
        return this.createTaggedImage(pixels, md, cameraChannelIndex);
    }

    public TaggedImage getTaggedImage() throws Exception {
        return this.getTaggedImage(0);
    }

    public TaggedImage getLastTaggedImage(int cameraChannelIndex) throws Exception {
        Metadata md = new Metadata();
        Object pixels = this.getLastImageMD(cameraChannelIndex, 0L, md);
        return this.createTaggedImage(pixels, md, cameraChannelIndex);
    }

    public TaggedImage getLastTaggedImage() throws Exception {
        return this.getLastTaggedImage(0);
    }

    public TaggedImage getNBeforeLastTaggedImage(long n) throws Exception {
        Metadata md = new Metadata();
        Object pixels = this.getNBeforeLastImageMD(n, md);
        return this.createTaggedImage(pixels, md);
    }

    public TaggedImage popNextTaggedImage(int cameraChannelIndex) throws Exception {
        Metadata md = new Metadata();
        Object pixels = this.popNextImageMD(cameraChannelIndex, 0L, md);
        return this.createTaggedImage(pixels, md, cameraChannelIndex);
    }

    public TaggedImage popNextTaggedImage() throws Exception {
        return this.popNextTaggedImage(0);
    }

    public Rectangle getROI() throws Exception {
        int[][] a = new int[4][1];
        this.getROI(a[0], a[1], a[2], a[3]);
        return new Rectangle(a[0][0], a[1][0], a[2][0], a[3][0]);
    }

    public Rectangle getROI(String label) throws Exception {
        int[][] a = new int[4][1];
        this.getROI(label, a[0], a[1], a[2], a[3]);
        return new Rectangle(a[0][0], a[1][0], a[2][0], a[3][0]);
    }

    public List<Rectangle> getMultiROI() throws Exception {
        UnsignedVector xs = new UnsignedVector();
        UnsignedVector ys = new UnsignedVector();
        UnsignedVector widths = new UnsignedVector();
        UnsignedVector heights = new UnsignedVector();
        this.getMultiROI(xs, ys, widths, heights);
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        int i = 0;
        while ((long)i < xs.size()) {
            Rectangle r = new Rectangle((int)xs.get(i), (int)ys.get(i), (int)widths.get(i), (int)heights.get(i));
            result.add(r);
            ++i;
        }
        return result;
    }

    public void setMultiROI(List<Rectangle> rects) throws Exception {
        UnsignedVector xs = new UnsignedVector();
        UnsignedVector ys = new UnsignedVector();
        UnsignedVector widths = new UnsignedVector();
        UnsignedVector heights = new UnsignedVector();
        for (Rectangle r : rects) {
            xs.add(r.x);
            ys.add(r.y);
            widths.add(r.width);
            heights.add(r.height);
        }
        this.setMultiROI(xs, ys, widths, heights);
    }

    public Point2D.Double getXYStagePosition(String stage) throws Exception {
        double[][] p = new double[2][1];
        this.getXYPosition(stage, p[0], p[1]);
        return new Point2D.Double(p[0][0], p[1][0]);
    }

    public Point2D.Double getXYStagePosition() throws Exception {
        double[] x = new double[1];
        double[] y = new double[1];
        this.getXYPosition(x, y);
        return new Point2D.Double(x[0], y[0]);
    }

    public Point2D.Double getGalvoPosition(String galvoDevice) throws Exception {
        double[][] p = new double[2][1];
        this.getGalvoPosition(galvoDevice, p[0], p[1]);
        return new Point2D.Double(p[0][0], p[1][0]);
    }

    public CMMCore() {
        this(MMCoreJJNI.new_CMMCore(), true);
    }

    public static void noop() {
        MMCoreJJNI.CMMCore_noop();
    }

    public void loadDevice(String label, String moduleName, String deviceName) throws Exception {
        MMCoreJJNI.CMMCore_loadDevice(this.swigCPtr, this, label, moduleName, deviceName);
    }

    public void unloadDevice(String label) throws Exception {
        MMCoreJJNI.CMMCore_unloadDevice(this.swigCPtr, this, label);
    }

    public void unloadAllDevices() throws Exception {
        MMCoreJJNI.CMMCore_unloadAllDevices(this.swigCPtr, this);
    }

    public void initializeAllDevices() throws Exception {
        MMCoreJJNI.CMMCore_initializeAllDevices(this.swigCPtr, this);
    }

    public void initializeDevice(String label) throws Exception {
        MMCoreJJNI.CMMCore_initializeDevice(this.swigCPtr, this, label);
    }

    public void reset() throws Exception {
        MMCoreJJNI.CMMCore_reset(this.swigCPtr, this);
    }

    public void unloadLibrary(String moduleName) throws Exception {
        MMCoreJJNI.CMMCore_unloadLibrary(this.swigCPtr, this, moduleName);
    }

    public void updateCoreProperties() throws Exception {
        MMCoreJJNI.CMMCore_updateCoreProperties(this.swigCPtr, this);
    }

    public String getCoreErrorText(int code) {
        return MMCoreJJNI.CMMCore_getCoreErrorText(this.swigCPtr, this, code);
    }

    public String getVersionInfo() {
        return MMCoreJJNI.CMMCore_getVersionInfo(this.swigCPtr, this);
    }

    public String getAPIVersionInfo() {
        return MMCoreJJNI.CMMCore_getAPIVersionInfo(this.swigCPtr, this);
    }

    public Configuration getSystemState() {
        return new Configuration(MMCoreJJNI.CMMCore_getSystemState(this.swigCPtr, this), true);
    }

    public void setSystemState(Configuration conf) {
        MMCoreJJNI.CMMCore_setSystemState(this.swigCPtr, this, Configuration.getCPtr(conf), conf);
    }

    public Configuration getConfigState(String group, String config) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getConfigState(this.swigCPtr, this, group, config), true);
    }

    public Configuration getConfigGroupState(String group) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getConfigGroupState(this.swigCPtr, this, group), true);
    }

    public void saveSystemState(String fileName) throws Exception {
        MMCoreJJNI.CMMCore_saveSystemState(this.swigCPtr, this, fileName);
    }

    public void loadSystemState(String fileName) throws Exception {
        MMCoreJJNI.CMMCore_loadSystemState(this.swigCPtr, this, fileName);
    }

    public void saveSystemConfiguration(String fileName) throws Exception {
        MMCoreJJNI.CMMCore_saveSystemConfiguration(this.swigCPtr, this, fileName);
    }

    public void loadSystemConfiguration(String fileName) throws Exception {
        MMCoreJJNI.CMMCore_loadSystemConfiguration(this.swigCPtr, this, fileName);
    }

    public void registerCallback(MMEventCallback cb) {
        MMCoreJJNI.CMMCore_registerCallback(this.swigCPtr, this, MMEventCallback.getCPtr(cb), cb);
    }

    public void setPrimaryLogFile(String filename, boolean truncate) throws Exception {
        MMCoreJJNI.CMMCore_setPrimaryLogFile__SWIG_0(this.swigCPtr, this, filename, truncate);
    }

    public void setPrimaryLogFile(String filename) throws Exception {
        MMCoreJJNI.CMMCore_setPrimaryLogFile__SWIG_1(this.swigCPtr, this, filename);
    }

    public String getPrimaryLogFile() {
        return MMCoreJJNI.CMMCore_getPrimaryLogFile(this.swigCPtr, this);
    }

    public void logMessage(String msg) {
        MMCoreJJNI.CMMCore_logMessage__SWIG_0(this.swigCPtr, this, msg);
    }

    public void logMessage(String msg, boolean debugOnly) {
        MMCoreJJNI.CMMCore_logMessage__SWIG_1(this.swigCPtr, this, msg, debugOnly);
    }

    public void enableDebugLog(boolean enable) {
        MMCoreJJNI.CMMCore_enableDebugLog(this.swigCPtr, this, enable);
    }

    public boolean debugLogEnabled() {
        return MMCoreJJNI.CMMCore_debugLogEnabled(this.swigCPtr, this);
    }

    public void enableStderrLog(boolean enable) {
        MMCoreJJNI.CMMCore_enableStderrLog(this.swigCPtr, this, enable);
    }

    public boolean stderrLogEnabled() {
        return MMCoreJJNI.CMMCore_stderrLogEnabled(this.swigCPtr, this);
    }

    public int startSecondaryLogFile(String filename, boolean enableDebug, boolean truncate, boolean synchronous) throws Exception {
        return MMCoreJJNI.CMMCore_startSecondaryLogFile__SWIG_0(this.swigCPtr, this, filename, enableDebug, truncate, synchronous);
    }

    public int startSecondaryLogFile(String filename, boolean enableDebug, boolean truncate) throws Exception {
        return MMCoreJJNI.CMMCore_startSecondaryLogFile__SWIG_1(this.swigCPtr, this, filename, enableDebug, truncate);
    }

    public int startSecondaryLogFile(String filename, boolean enableDebug) throws Exception {
        return MMCoreJJNI.CMMCore_startSecondaryLogFile__SWIG_2(this.swigCPtr, this, filename, enableDebug);
    }

    public void stopSecondaryLogFile(int handle) throws Exception {
        MMCoreJJNI.CMMCore_stopSecondaryLogFile(this.swigCPtr, this, handle);
    }

    public StrVector getDeviceAdapterSearchPaths() {
        return new StrVector(MMCoreJJNI.CMMCore_getDeviceAdapterSearchPaths(this.swigCPtr, this), true);
    }

    public void setDeviceAdapterSearchPaths(StrVector paths) {
        MMCoreJJNI.CMMCore_setDeviceAdapterSearchPaths(this.swigCPtr, this, StrVector.getCPtr(paths), paths);
    }

    public static void addSearchPath(String path) {
        MMCoreJJNI.CMMCore_addSearchPath(path);
    }

    public StrVector getDeviceAdapterNames() throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getDeviceAdapterNames(this.swigCPtr, this), true);
    }

    public static StrVector getDeviceLibraries() throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getDeviceLibraries(), true);
    }

    public StrVector getAvailableDevices(String library) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailableDevices(this.swigCPtr, this, library), true);
    }

    public StrVector getAvailableDeviceDescriptions(String library) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailableDeviceDescriptions(this.swigCPtr, this, library), true);
    }

    public LongVector getAvailableDeviceTypes(String library) throws Exception {
        return new LongVector(MMCoreJJNI.CMMCore_getAvailableDeviceTypes(this.swigCPtr, this, library), true);
    }

    public StrVector getLoadedDevices() {
        return new StrVector(MMCoreJJNI.CMMCore_getLoadedDevices(this.swigCPtr, this), true);
    }

    public StrVector getLoadedDevicesOfType(DeviceType devType) {
        return new StrVector(MMCoreJJNI.CMMCore_getLoadedDevicesOfType(this.swigCPtr, this, devType.swigValue()), true);
    }

    public DeviceType getDeviceType(String label) throws Exception {
        return DeviceType.swigToEnum(MMCoreJJNI.CMMCore_getDeviceType(this.swigCPtr, this, label));
    }

    public String getDeviceLibrary(String label) throws Exception {
        return MMCoreJJNI.CMMCore_getDeviceLibrary(this.swigCPtr, this, label);
    }

    public String getDeviceName(String label) throws Exception {
        return MMCoreJJNI.CMMCore_getDeviceName(this.swigCPtr, this, label);
    }

    public String getDeviceDescription(String label) throws Exception {
        return MMCoreJJNI.CMMCore_getDeviceDescription(this.swigCPtr, this, label);
    }

    public StrVector getDevicePropertyNames(String label) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getDevicePropertyNames(this.swigCPtr, this, label), true);
    }

    public boolean hasProperty(String label, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_hasProperty(this.swigCPtr, this, label, propName);
    }

    public String getProperty(String label, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_getProperty(this.swigCPtr, this, label, propName);
    }

    public void setProperty(String label, String propName, String propValue) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_0(this.swigCPtr, this, label, propName, propValue);
    }

    public void setProperty(String label, String propName, boolean propValue) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_1(this.swigCPtr, this, label, propName, propValue);
    }

    public void setProperty(String label, String propName, int propValue) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_2(this.swigCPtr, this, label, propName, propValue);
    }

    public void setProperty(String label, String propName, float propValue) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_3(this.swigCPtr, this, label, propName, propValue);
    }

    public void setProperty(String label, String propName, double propValue) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_4(this.swigCPtr, this, label, propName, propValue);
    }

    public StrVector getAllowedPropertyValues(String label, String propName) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getAllowedPropertyValues(this.swigCPtr, this, label, propName), true);
    }

    public boolean isPropertyReadOnly(String label, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_isPropertyReadOnly(this.swigCPtr, this, label, propName);
    }

    public boolean isPropertyPreInit(String label, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_isPropertyPreInit(this.swigCPtr, this, label, propName);
    }

    public boolean isPropertySequenceable(String label, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_isPropertySequenceable(this.swigCPtr, this, label, propName);
    }

    public boolean hasPropertyLimits(String label, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_hasPropertyLimits(this.swigCPtr, this, label, propName);
    }

    public double getPropertyLowerLimit(String label, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_getPropertyLowerLimit(this.swigCPtr, this, label, propName);
    }

    public double getPropertyUpperLimit(String label, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_getPropertyUpperLimit(this.swigCPtr, this, label, propName);
    }

    public PropertyType getPropertyType(String label, String propName) throws Exception {
        return PropertyType.swigToEnum(MMCoreJJNI.CMMCore_getPropertyType(this.swigCPtr, this, label, propName));
    }

    public void startPropertySequence(String label, String propName) throws Exception {
        MMCoreJJNI.CMMCore_startPropertySequence(this.swigCPtr, this, label, propName);
    }

    public void stopPropertySequence(String label, String propName) throws Exception {
        MMCoreJJNI.CMMCore_stopPropertySequence(this.swigCPtr, this, label, propName);
    }

    public int getPropertySequenceMaxLength(String label, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_getPropertySequenceMaxLength(this.swigCPtr, this, label, propName);
    }

    public void loadPropertySequence(String label, String propName, StrVector eventSequence) throws Exception {
        MMCoreJJNI.CMMCore_loadPropertySequence(this.swigCPtr, this, label, propName, StrVector.getCPtr(eventSequence), eventSequence);
    }

    public boolean deviceBusy(String label) throws Exception {
        return MMCoreJJNI.CMMCore_deviceBusy(this.swigCPtr, this, label);
    }

    public void waitForDevice(String label) throws Exception {
        MMCoreJJNI.CMMCore_waitForDevice(this.swigCPtr, this, label);
    }

    public void waitForConfig(String group, String configName) throws Exception {
        MMCoreJJNI.CMMCore_waitForConfig(this.swigCPtr, this, group, configName);
    }

    public boolean systemBusy() throws Exception {
        return MMCoreJJNI.CMMCore_systemBusy(this.swigCPtr, this);
    }

    public void waitForSystem() throws Exception {
        MMCoreJJNI.CMMCore_waitForSystem(this.swigCPtr, this);
    }

    public void waitForImageSynchro() throws Exception {
        MMCoreJJNI.CMMCore_waitForImageSynchro(this.swigCPtr, this);
    }

    public boolean deviceTypeBusy(DeviceType devType) throws Exception {
        return MMCoreJJNI.CMMCore_deviceTypeBusy(this.swigCPtr, this, devType.swigValue());
    }

    public void waitForDeviceType(DeviceType devType) throws Exception {
        MMCoreJJNI.CMMCore_waitForDeviceType(this.swigCPtr, this, devType.swigValue());
    }

    public double getDeviceDelayMs(String label) throws Exception {
        return MMCoreJJNI.CMMCore_getDeviceDelayMs(this.swigCPtr, this, label);
    }

    public void setDeviceDelayMs(String label, double delayMs) throws Exception {
        MMCoreJJNI.CMMCore_setDeviceDelayMs(this.swigCPtr, this, label, delayMs);
    }

    public boolean usesDeviceDelay(String label) throws Exception {
        return MMCoreJJNI.CMMCore_usesDeviceDelay(this.swigCPtr, this, label);
    }

    public void setTimeoutMs(int timeoutMs) {
        MMCoreJJNI.CMMCore_setTimeoutMs(this.swigCPtr, this, timeoutMs);
    }

    public int getTimeoutMs() {
        return MMCoreJJNI.CMMCore_getTimeoutMs(this.swigCPtr, this);
    }

    public void sleep(double intervalMs) {
        MMCoreJJNI.CMMCore_sleep(this.swigCPtr, this, intervalMs);
    }

    public String getCameraDevice() {
        return MMCoreJJNI.CMMCore_getCameraDevice(this.swigCPtr, this);
    }

    public String getShutterDevice() {
        return MMCoreJJNI.CMMCore_getShutterDevice(this.swigCPtr, this);
    }

    public String getFocusDevice() {
        return MMCoreJJNI.CMMCore_getFocusDevice(this.swigCPtr, this);
    }

    public String getXYStageDevice() {
        return MMCoreJJNI.CMMCore_getXYStageDevice(this.swigCPtr, this);
    }

    public String getAutoFocusDevice() {
        return MMCoreJJNI.CMMCore_getAutoFocusDevice(this.swigCPtr, this);
    }

    public String getImageProcessorDevice() {
        return MMCoreJJNI.CMMCore_getImageProcessorDevice(this.swigCPtr, this);
    }

    public String getSLMDevice() {
        return MMCoreJJNI.CMMCore_getSLMDevice(this.swigCPtr, this);
    }

    public String getGalvoDevice() {
        return MMCoreJJNI.CMMCore_getGalvoDevice(this.swigCPtr, this);
    }

    public String getChannelGroup() {
        return MMCoreJJNI.CMMCore_getChannelGroup(this.swigCPtr, this);
    }

    public void setCameraDevice(String cameraLabel) throws Exception {
        MMCoreJJNI.CMMCore_setCameraDevice(this.swigCPtr, this, cameraLabel);
    }

    public void setShutterDevice(String shutterLabel) throws Exception {
        MMCoreJJNI.CMMCore_setShutterDevice(this.swigCPtr, this, shutterLabel);
    }

    public void setFocusDevice(String focusLabel) throws Exception {
        MMCoreJJNI.CMMCore_setFocusDevice(this.swigCPtr, this, focusLabel);
    }

    public void setXYStageDevice(String xyStageLabel) throws Exception {
        MMCoreJJNI.CMMCore_setXYStageDevice(this.swigCPtr, this, xyStageLabel);
    }

    public void setAutoFocusDevice(String focusLabel) throws Exception {
        MMCoreJJNI.CMMCore_setAutoFocusDevice(this.swigCPtr, this, focusLabel);
    }

    public void setImageProcessorDevice(String procLabel) throws Exception {
        MMCoreJJNI.CMMCore_setImageProcessorDevice(this.swigCPtr, this, procLabel);
    }

    public void setSLMDevice(String slmLabel) throws Exception {
        MMCoreJJNI.CMMCore_setSLMDevice(this.swigCPtr, this, slmLabel);
    }

    public void setGalvoDevice(String galvoLabel) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoDevice(this.swigCPtr, this, galvoLabel);
    }

    public void setChannelGroup(String channelGroup) throws Exception {
        MMCoreJJNI.CMMCore_setChannelGroup(this.swigCPtr, this, channelGroup);
    }

    public Configuration getSystemStateCache() {
        return new Configuration(MMCoreJJNI.CMMCore_getSystemStateCache(this.swigCPtr, this), true);
    }

    public void updateSystemStateCache() {
        MMCoreJJNI.CMMCore_updateSystemStateCache(this.swigCPtr, this);
    }

    public String getPropertyFromCache(String deviceLabel, String propName) throws Exception {
        return MMCoreJJNI.CMMCore_getPropertyFromCache(this.swigCPtr, this, deviceLabel, propName);
    }

    public String getCurrentConfigFromCache(String groupName) throws Exception {
        return MMCoreJJNI.CMMCore_getCurrentConfigFromCache(this.swigCPtr, this, groupName);
    }

    public Configuration getConfigGroupStateFromCache(String group) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getConfigGroupStateFromCache(this.swigCPtr, this, group), true);
    }

    public void defineConfig(String groupName, String configName) throws Exception {
        MMCoreJJNI.CMMCore_defineConfig__SWIG_0(this.swigCPtr, this, groupName, configName);
    }

    public void defineConfig(String groupName, String configName, String deviceLabel, String propName, String value) throws Exception {
        MMCoreJJNI.CMMCore_defineConfig__SWIG_1(this.swigCPtr, this, groupName, configName, deviceLabel, propName, value);
    }

    public void defineConfigGroup(String groupName) throws Exception {
        MMCoreJJNI.CMMCore_defineConfigGroup(this.swigCPtr, this, groupName);
    }

    public void deleteConfigGroup(String groupName) throws Exception {
        MMCoreJJNI.CMMCore_deleteConfigGroup(this.swigCPtr, this, groupName);
    }

    public void renameConfigGroup(String oldGroupName, String newGroupName) throws Exception {
        MMCoreJJNI.CMMCore_renameConfigGroup(this.swigCPtr, this, oldGroupName, newGroupName);
    }

    public boolean isGroupDefined(String groupName) {
        return MMCoreJJNI.CMMCore_isGroupDefined(this.swigCPtr, this, groupName);
    }

    public boolean isConfigDefined(String groupName, String configName) {
        return MMCoreJJNI.CMMCore_isConfigDefined(this.swigCPtr, this, groupName, configName);
    }

    public void setConfig(String groupName, String configName) throws Exception {
        MMCoreJJNI.CMMCore_setConfig(this.swigCPtr, this, groupName, configName);
    }

    public void deleteConfig(String groupName, String configName) throws Exception {
        MMCoreJJNI.CMMCore_deleteConfig__SWIG_0(this.swigCPtr, this, groupName, configName);
    }

    public void deleteConfig(String groupName, String configName, String deviceLabel, String propName) throws Exception {
        MMCoreJJNI.CMMCore_deleteConfig__SWIG_1(this.swigCPtr, this, groupName, configName, deviceLabel, propName);
    }

    public void renameConfig(String groupName, String oldConfigName, String newConfigName) throws Exception {
        MMCoreJJNI.CMMCore_renameConfig(this.swigCPtr, this, groupName, oldConfigName, newConfigName);
    }

    public StrVector getAvailableConfigGroups() {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailableConfigGroups(this.swigCPtr, this), true);
    }

    public StrVector getAvailableConfigs(String configGroup) {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailableConfigs(this.swigCPtr, this, configGroup), true);
    }

    public String getCurrentConfig(String groupName) throws Exception {
        return MMCoreJJNI.CMMCore_getCurrentConfig(this.swigCPtr, this, groupName);
    }

    public Configuration getConfigData(String configGroup, String configName) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getConfigData(this.swigCPtr, this, configGroup, configName), true);
    }

    public String getCurrentPixelSizeConfig() throws Exception {
        return MMCoreJJNI.CMMCore_getCurrentPixelSizeConfig__SWIG_0(this.swigCPtr, this);
    }

    public String getCurrentPixelSizeConfig(boolean cached) throws Exception {
        return MMCoreJJNI.CMMCore_getCurrentPixelSizeConfig__SWIG_1(this.swigCPtr, this, cached);
    }

    public double getPixelSizeUm() {
        return MMCoreJJNI.CMMCore_getPixelSizeUm__SWIG_0(this.swigCPtr, this);
    }

    public double getPixelSizeUm(boolean cached) {
        return MMCoreJJNI.CMMCore_getPixelSizeUm__SWIG_1(this.swigCPtr, this, cached);
    }

    public double getPixelSizeUmByID(String resolutionID) throws Exception {
        return MMCoreJJNI.CMMCore_getPixelSizeUmByID(this.swigCPtr, this, resolutionID);
    }

    public double getMagnificationFactor() {
        return MMCoreJJNI.CMMCore_getMagnificationFactor(this.swigCPtr, this);
    }

    public void setPixelSizeUm(String resolutionID, double pixSize) throws Exception {
        MMCoreJJNI.CMMCore_setPixelSizeUm(this.swigCPtr, this, resolutionID, pixSize);
    }

    public void definePixelSizeConfig(String resolutionID, String deviceLabel, String propName, String value) throws Exception {
        MMCoreJJNI.CMMCore_definePixelSizeConfig__SWIG_0(this.swigCPtr, this, resolutionID, deviceLabel, propName, value);
    }

    public void definePixelSizeConfig(String resolutionID) throws Exception {
        MMCoreJJNI.CMMCore_definePixelSizeConfig__SWIG_1(this.swigCPtr, this, resolutionID);
    }

    public StrVector getAvailablePixelSizeConfigs() {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailablePixelSizeConfigs(this.swigCPtr, this), true);
    }

    public boolean isPixelSizeConfigDefined(String resolutionID) throws Exception {
        return MMCoreJJNI.CMMCore_isPixelSizeConfigDefined(this.swigCPtr, this, resolutionID);
    }

    public void setPixelSizeConfig(String resolutionID) throws Exception {
        MMCoreJJNI.CMMCore_setPixelSizeConfig(this.swigCPtr, this, resolutionID);
    }

    public void renamePixelSizeConfig(String oldConfigName, String newConfigName) throws Exception {
        MMCoreJJNI.CMMCore_renamePixelSizeConfig(this.swigCPtr, this, oldConfigName, newConfigName);
    }

    public void deletePixelSizeConfig(String configName) throws Exception {
        MMCoreJJNI.CMMCore_deletePixelSizeConfig(this.swigCPtr, this, configName);
    }

    public Configuration getPixelSizeConfigData(String configName) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getPixelSizeConfigData(this.swigCPtr, this, configName), true);
    }

    public void definePropertyBlock(String blockName, String propertyName, String propertyValue) {
        MMCoreJJNI.CMMCore_definePropertyBlock(this.swigCPtr, this, blockName, propertyName, propertyValue);
    }

    public StrVector getAvailablePropertyBlocks() {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailablePropertyBlocks(this.swigCPtr, this), true);
    }

    public PropertyBlock getPropertyBlockData(String blockName) {
        return new PropertyBlock(MMCoreJJNI.CMMCore_getPropertyBlockData(this.swigCPtr, this, blockName), true);
    }

    public void setROI(int x, int y, int xSize, int ySize) throws Exception {
        MMCoreJJNI.CMMCore_setROI(this.swigCPtr, this, x, y, xSize, ySize);
    }

    public void getROI(int[] x, int[] y, int[] xSize, int[] ySize) throws Exception {
        MMCoreJJNI.CMMCore_getROI__SWIG_0(this.swigCPtr, this, x, y, xSize, ySize);
    }

    public void getROI(String label, int[] x, int[] y, int[] xSize, int[] ySize) throws Exception {
        MMCoreJJNI.CMMCore_getROI__SWIG_1(this.swigCPtr, this, label, x, y, xSize, ySize);
    }

    public void clearROI() throws Exception {
        MMCoreJJNI.CMMCore_clearROI(this.swigCPtr, this);
    }

    public boolean isMultiROISupported() throws Exception {
        return MMCoreJJNI.CMMCore_isMultiROISupported(this.swigCPtr, this);
    }

    public boolean isMultiROIEnabled() throws Exception {
        return MMCoreJJNI.CMMCore_isMultiROIEnabled(this.swigCPtr, this);
    }

    public void setMultiROI(UnsignedVector xs, UnsignedVector ys, UnsignedVector widths, UnsignedVector heights) throws Exception {
        MMCoreJJNI.CMMCore_setMultiROI(this.swigCPtr, this, UnsignedVector.getCPtr(xs), xs, UnsignedVector.getCPtr(ys), ys, UnsignedVector.getCPtr(widths), widths, UnsignedVector.getCPtr(heights), heights);
    }

    public void getMultiROI(UnsignedVector xs, UnsignedVector ys, UnsignedVector widths, UnsignedVector heights) throws Exception {
        MMCoreJJNI.CMMCore_getMultiROI(this.swigCPtr, this, UnsignedVector.getCPtr(xs), xs, UnsignedVector.getCPtr(ys), ys, UnsignedVector.getCPtr(widths), widths, UnsignedVector.getCPtr(heights), heights);
    }

    public void setExposure(double exp) throws Exception {
        MMCoreJJNI.CMMCore_setExposure__SWIG_0(this.swigCPtr, this, exp);
    }

    public void setExposure(String cameraLabel, double dExp) throws Exception {
        MMCoreJJNI.CMMCore_setExposure__SWIG_1(this.swigCPtr, this, cameraLabel, dExp);
    }

    public double getExposure() throws Exception {
        return MMCoreJJNI.CMMCore_getExposure(this.swigCPtr, this);
    }

    public void snapImage() throws Exception {
        MMCoreJJNI.CMMCore_snapImage(this.swigCPtr, this);
    }

    public Object getImage() throws Exception {
        return MMCoreJJNI.CMMCore_getImage__SWIG_0(this.swigCPtr, this);
    }

    public Object getImage(long numChannel) throws Exception {
        return MMCoreJJNI.CMMCore_getImage__SWIG_1(this.swigCPtr, this, numChannel);
    }

    public long getImageWidth() {
        return MMCoreJJNI.CMMCore_getImageWidth(this.swigCPtr, this);
    }

    public long getImageHeight() {
        return MMCoreJJNI.CMMCore_getImageHeight(this.swigCPtr, this);
    }

    public long getBytesPerPixel() {
        return MMCoreJJNI.CMMCore_getBytesPerPixel(this.swigCPtr, this);
    }

    public long getImageBitDepth() {
        return MMCoreJJNI.CMMCore_getImageBitDepth(this.swigCPtr, this);
    }

    public long getNumberOfComponents() {
        return MMCoreJJNI.CMMCore_getNumberOfComponents(this.swigCPtr, this);
    }

    public long getNumberOfCameraChannels() {
        return MMCoreJJNI.CMMCore_getNumberOfCameraChannels(this.swigCPtr, this);
    }

    public String getCameraChannelName(long channelNr) {
        return MMCoreJJNI.CMMCore_getCameraChannelName(this.swigCPtr, this, channelNr);
    }

    public int getImageBufferSize() {
        return MMCoreJJNI.CMMCore_getImageBufferSize(this.swigCPtr, this);
    }

    public void assignImageSynchro(String deviceLabel) throws Exception {
        MMCoreJJNI.CMMCore_assignImageSynchro(this.swigCPtr, this, deviceLabel);
    }

    public void removeImageSynchro(String deviceLabel) throws Exception {
        MMCoreJJNI.CMMCore_removeImageSynchro(this.swigCPtr, this, deviceLabel);
    }

    public void removeImageSynchroAll() {
        MMCoreJJNI.CMMCore_removeImageSynchroAll(this.swigCPtr, this);
    }

    public void setAutoShutter(boolean state) {
        MMCoreJJNI.CMMCore_setAutoShutter(this.swigCPtr, this, state);
    }

    public boolean getAutoShutter() {
        return MMCoreJJNI.CMMCore_getAutoShutter(this.swigCPtr, this);
    }

    public void setShutterOpen(boolean state) throws Exception {
        MMCoreJJNI.CMMCore_setShutterOpen__SWIG_0(this.swigCPtr, this, state);
    }

    public boolean getShutterOpen() throws Exception {
        return MMCoreJJNI.CMMCore_getShutterOpen__SWIG_0(this.swigCPtr, this);
    }

    public void setShutterOpen(String shutterLabel, boolean state) throws Exception {
        MMCoreJJNI.CMMCore_setShutterOpen__SWIG_1(this.swigCPtr, this, shutterLabel, state);
    }

    public boolean getShutterOpen(String shutterLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getShutterOpen__SWIG_1(this.swigCPtr, this, shutterLabel);
    }

    public void startSequenceAcquisition(int numImages, double intervalMs, boolean stopOnOverflow) throws Exception {
        MMCoreJJNI.CMMCore_startSequenceAcquisition__SWIG_0(this.swigCPtr, this, numImages, intervalMs, stopOnOverflow);
    }

    public void startSequenceAcquisition(String cameraLabel, int numImages, double intervalMs, boolean stopOnOverflow) throws Exception {
        MMCoreJJNI.CMMCore_startSequenceAcquisition__SWIG_1(this.swigCPtr, this, cameraLabel, numImages, intervalMs, stopOnOverflow);
    }

    public void prepareSequenceAcquisition(String cameraLabel) throws Exception {
        MMCoreJJNI.CMMCore_prepareSequenceAcquisition(this.swigCPtr, this, cameraLabel);
    }

    public void startContinuousSequenceAcquisition(double intervalMs) throws Exception {
        MMCoreJJNI.CMMCore_startContinuousSequenceAcquisition(this.swigCPtr, this, intervalMs);
    }

    public void stopSequenceAcquisition() throws Exception {
        MMCoreJJNI.CMMCore_stopSequenceAcquisition__SWIG_0(this.swigCPtr, this);
    }

    public void stopSequenceAcquisition(String cameraLabel) throws Exception {
        MMCoreJJNI.CMMCore_stopSequenceAcquisition__SWIG_1(this.swigCPtr, this, cameraLabel);
    }

    public boolean isSequenceRunning() {
        return MMCoreJJNI.CMMCore_isSequenceRunning__SWIG_0(this.swigCPtr, this);
    }

    public boolean isSequenceRunning(String cameraLabel) throws Exception {
        return MMCoreJJNI.CMMCore_isSequenceRunning__SWIG_1(this.swigCPtr, this, cameraLabel);
    }

    public Object getLastImage() throws Exception {
        return MMCoreJJNI.CMMCore_getLastImage(this.swigCPtr, this);
    }

    public Object popNextImage() throws Exception {
        return MMCoreJJNI.CMMCore_popNextImage(this.swigCPtr, this);
    }

    public Object getLastImageMD(long channel, long slice, Metadata md) throws Exception {
        return MMCoreJJNI.CMMCore_getLastImageMD__SWIG_0(this.swigCPtr, this, channel, slice, Metadata.getCPtr(md), md);
    }

    public Object popNextImageMD(long channel, long slice, Metadata md) throws Exception {
        return MMCoreJJNI.CMMCore_popNextImageMD__SWIG_0(this.swigCPtr, this, channel, slice, Metadata.getCPtr(md), md);
    }

    public Object getLastImageMD(Metadata md) throws Exception {
        return MMCoreJJNI.CMMCore_getLastImageMD__SWIG_1(this.swigCPtr, this, Metadata.getCPtr(md), md);
    }

    public Object getNBeforeLastImageMD(long n, Metadata md) throws Exception {
        return MMCoreJJNI.CMMCore_getNBeforeLastImageMD(this.swigCPtr, this, n, Metadata.getCPtr(md), md);
    }

    public Object popNextImageMD(Metadata md) throws Exception {
        return MMCoreJJNI.CMMCore_popNextImageMD__SWIG_1(this.swigCPtr, this, Metadata.getCPtr(md), md);
    }

    public int getRemainingImageCount() {
        return MMCoreJJNI.CMMCore_getRemainingImageCount(this.swigCPtr, this);
    }

    public int getBufferTotalCapacity() {
        return MMCoreJJNI.CMMCore_getBufferTotalCapacity(this.swigCPtr, this);
    }

    public int getBufferFreeCapacity() {
        return MMCoreJJNI.CMMCore_getBufferFreeCapacity(this.swigCPtr, this);
    }

    public boolean isBufferOverflowed() {
        return MMCoreJJNI.CMMCore_isBufferOverflowed(this.swigCPtr, this);
    }

    public void setCircularBufferMemoryFootprint(long sizeMB) throws Exception {
        MMCoreJJNI.CMMCore_setCircularBufferMemoryFootprint(this.swigCPtr, this, sizeMB);
    }

    public long getCircularBufferMemoryFootprint() {
        return MMCoreJJNI.CMMCore_getCircularBufferMemoryFootprint(this.swigCPtr, this);
    }

    public void initializeCircularBuffer() throws Exception {
        MMCoreJJNI.CMMCore_initializeCircularBuffer(this.swigCPtr, this);
    }

    public void clearCircularBuffer() throws Exception {
        MMCoreJJNI.CMMCore_clearCircularBuffer(this.swigCPtr, this);
    }

    public boolean isExposureSequenceable(String cameraLabel) throws Exception {
        return MMCoreJJNI.CMMCore_isExposureSequenceable(this.swigCPtr, this, cameraLabel);
    }

    public void startExposureSequence(String cameraLabel) throws Exception {
        MMCoreJJNI.CMMCore_startExposureSequence(this.swigCPtr, this, cameraLabel);
    }

    public void stopExposureSequence(String cameraLabel) throws Exception {
        MMCoreJJNI.CMMCore_stopExposureSequence(this.swigCPtr, this, cameraLabel);
    }

    public int getExposureSequenceMaxLength(String cameraLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getExposureSequenceMaxLength(this.swigCPtr, this, cameraLabel);
    }

    public void loadExposureSequence(String cameraLabel, DoubleVector exposureSequence_ms) throws Exception {
        MMCoreJJNI.CMMCore_loadExposureSequence(this.swigCPtr, this, cameraLabel, DoubleVector.getCPtr(exposureSequence_ms), exposureSequence_ms);
    }

    public double getLastFocusScore() {
        return MMCoreJJNI.CMMCore_getLastFocusScore(this.swigCPtr, this);
    }

    public double getCurrentFocusScore() {
        return MMCoreJJNI.CMMCore_getCurrentFocusScore(this.swigCPtr, this);
    }

    public void enableContinuousFocus(boolean enable) throws Exception {
        MMCoreJJNI.CMMCore_enableContinuousFocus(this.swigCPtr, this, enable);
    }

    public boolean isContinuousFocusEnabled() throws Exception {
        return MMCoreJJNI.CMMCore_isContinuousFocusEnabled(this.swigCPtr, this);
    }

    public boolean isContinuousFocusLocked() throws Exception {
        return MMCoreJJNI.CMMCore_isContinuousFocusLocked(this.swigCPtr, this);
    }

    public boolean isContinuousFocusDrive(String stageLabel) throws Exception {
        return MMCoreJJNI.CMMCore_isContinuousFocusDrive(this.swigCPtr, this, stageLabel);
    }

    public void fullFocus() throws Exception {
        MMCoreJJNI.CMMCore_fullFocus(this.swigCPtr, this);
    }

    public void incrementalFocus() throws Exception {
        MMCoreJJNI.CMMCore_incrementalFocus(this.swigCPtr, this);
    }

    public void setAutoFocusOffset(double offset) throws Exception {
        MMCoreJJNI.CMMCore_setAutoFocusOffset(this.swigCPtr, this, offset);
    }

    public double getAutoFocusOffset() throws Exception {
        return MMCoreJJNI.CMMCore_getAutoFocusOffset(this.swigCPtr, this);
    }

    public void setState(String stateDeviceLabel, int state) throws Exception {
        MMCoreJJNI.CMMCore_setState(this.swigCPtr, this, stateDeviceLabel, state);
    }

    public int getState(String stateDeviceLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getState(this.swigCPtr, this, stateDeviceLabel);
    }

    public int getNumberOfStates(String stateDeviceLabel) {
        return MMCoreJJNI.CMMCore_getNumberOfStates(this.swigCPtr, this, stateDeviceLabel);
    }

    public void setStateLabel(String stateDeviceLabel, String stateLabel) throws Exception {
        MMCoreJJNI.CMMCore_setStateLabel(this.swigCPtr, this, stateDeviceLabel, stateLabel);
    }

    public String getStateLabel(String stateDeviceLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getStateLabel(this.swigCPtr, this, stateDeviceLabel);
    }

    public void defineStateLabel(String stateDeviceLabel, int state, String stateLabel) throws Exception {
        MMCoreJJNI.CMMCore_defineStateLabel(this.swigCPtr, this, stateDeviceLabel, state, stateLabel);
    }

    public StrVector getStateLabels(String stateDeviceLabel) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getStateLabels(this.swigCPtr, this, stateDeviceLabel), true);
    }

    public int getStateFromLabel(String stateDeviceLabel, String stateLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getStateFromLabel(this.swigCPtr, this, stateDeviceLabel, stateLabel);
    }

    public PropertyBlock getStateLabelData(String stateDeviceLabel, String stateLabel) {
        return new PropertyBlock(MMCoreJJNI.CMMCore_getStateLabelData(this.swigCPtr, this, stateDeviceLabel, stateLabel), true);
    }

    public PropertyBlock getData(String stateDeviceLabel) {
        return new PropertyBlock(MMCoreJJNI.CMMCore_getData(this.swigCPtr, this, stateDeviceLabel), true);
    }

    public void setPosition(String stageLabel, double position) throws Exception {
        MMCoreJJNI.CMMCore_setPosition__SWIG_0(this.swigCPtr, this, stageLabel, position);
    }

    public void setPosition(double position) throws Exception {
        MMCoreJJNI.CMMCore_setPosition__SWIG_1(this.swigCPtr, this, position);
    }

    public double getPosition(String stageLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getPosition__SWIG_0(this.swigCPtr, this, stageLabel);
    }

    public double getPosition() throws Exception {
        return MMCoreJJNI.CMMCore_getPosition__SWIG_1(this.swigCPtr, this);
    }

    public void setRelativePosition(String stageLabel, double d) throws Exception {
        MMCoreJJNI.CMMCore_setRelativePosition__SWIG_0(this.swigCPtr, this, stageLabel, d);
    }

    public void setRelativePosition(double d) throws Exception {
        MMCoreJJNI.CMMCore_setRelativePosition__SWIG_1(this.swigCPtr, this, d);
    }

    public void setOrigin(String stageLabel) throws Exception {
        MMCoreJJNI.CMMCore_setOrigin__SWIG_0(this.swigCPtr, this, stageLabel);
    }

    public void setOrigin() throws Exception {
        MMCoreJJNI.CMMCore_setOrigin__SWIG_1(this.swigCPtr, this);
    }

    public void setAdapterOrigin(String stageLabel, double newZUm) throws Exception {
        MMCoreJJNI.CMMCore_setAdapterOrigin__SWIG_0(this.swigCPtr, this, stageLabel, newZUm);
    }

    public void setAdapterOrigin(double newZUm) throws Exception {
        MMCoreJJNI.CMMCore_setAdapterOrigin__SWIG_1(this.swigCPtr, this, newZUm);
    }

    public void setFocusDirection(String stageLabel, int sign) {
        MMCoreJJNI.CMMCore_setFocusDirection(this.swigCPtr, this, stageLabel, sign);
    }

    public int getFocusDirection(String stageLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getFocusDirection(this.swigCPtr, this, stageLabel);
    }

    public boolean isStageSequenceable(String stageLabel) throws Exception {
        return MMCoreJJNI.CMMCore_isStageSequenceable(this.swigCPtr, this, stageLabel);
    }

    public void startStageSequence(String stageLabel) throws Exception {
        MMCoreJJNI.CMMCore_startStageSequence(this.swigCPtr, this, stageLabel);
    }

    public void stopStageSequence(String stageLabel) throws Exception {
        MMCoreJJNI.CMMCore_stopStageSequence(this.swigCPtr, this, stageLabel);
    }

    public int getStageSequenceMaxLength(String stageLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getStageSequenceMaxLength(this.swigCPtr, this, stageLabel);
    }

    public void loadStageSequence(String stageLabel, DoubleVector positionSequence) throws Exception {
        MMCoreJJNI.CMMCore_loadStageSequence(this.swigCPtr, this, stageLabel, DoubleVector.getCPtr(positionSequence), positionSequence);
    }

    public void setXYPosition(String xyStageLabel, double x, double y) throws Exception {
        MMCoreJJNI.CMMCore_setXYPosition__SWIG_0(this.swigCPtr, this, xyStageLabel, x, y);
    }

    public void setXYPosition(double x, double y) throws Exception {
        MMCoreJJNI.CMMCore_setXYPosition__SWIG_1(this.swigCPtr, this, x, y);
    }

    public void setRelativeXYPosition(String xyStageLabel, double dx, double dy) throws Exception {
        MMCoreJJNI.CMMCore_setRelativeXYPosition__SWIG_0(this.swigCPtr, this, xyStageLabel, dx, dy);
    }

    public void setRelativeXYPosition(double dx, double dy) throws Exception {
        MMCoreJJNI.CMMCore_setRelativeXYPosition__SWIG_1(this.swigCPtr, this, dx, dy);
    }

    public void getXYPosition(String xyStageLabel, double[] x_stage, double[] y_stage) throws Exception {
        MMCoreJJNI.CMMCore_getXYPosition__SWIG_0(this.swigCPtr, this, xyStageLabel, x_stage, y_stage);
    }

    public void getXYPosition(double[] x_stage, double[] y_stage) throws Exception {
        MMCoreJJNI.CMMCore_getXYPosition__SWIG_1(this.swigCPtr, this, x_stage, y_stage);
    }

    public double getXPosition(String xyStageLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getXPosition__SWIG_0(this.swigCPtr, this, xyStageLabel);
    }

    public double getYPosition(String xyStageLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getYPosition__SWIG_0(this.swigCPtr, this, xyStageLabel);
    }

    public double getXPosition() throws Exception {
        return MMCoreJJNI.CMMCore_getXPosition__SWIG_1(this.swigCPtr, this);
    }

    public double getYPosition() throws Exception {
        return MMCoreJJNI.CMMCore_getYPosition__SWIG_1(this.swigCPtr, this);
    }

    public void stop(String xyOrZStageLabel) throws Exception {
        MMCoreJJNI.CMMCore_stop(this.swigCPtr, this, xyOrZStageLabel);
    }

    public void home(String xyOrZStageLabel) throws Exception {
        MMCoreJJNI.CMMCore_home(this.swigCPtr, this, xyOrZStageLabel);
    }

    public void setOriginXY(String xyStageLabel) throws Exception {
        MMCoreJJNI.CMMCore_setOriginXY__SWIG_0(this.swigCPtr, this, xyStageLabel);
    }

    public void setOriginXY() throws Exception {
        MMCoreJJNI.CMMCore_setOriginXY__SWIG_1(this.swigCPtr, this);
    }

    public void setOriginX(String xyStageLabel) throws Exception {
        MMCoreJJNI.CMMCore_setOriginX__SWIG_0(this.swigCPtr, this, xyStageLabel);
    }

    public void setOriginX() throws Exception {
        MMCoreJJNI.CMMCore_setOriginX__SWIG_1(this.swigCPtr, this);
    }

    public void setOriginY(String xyStageLabel) throws Exception {
        MMCoreJJNI.CMMCore_setOriginY__SWIG_0(this.swigCPtr, this, xyStageLabel);
    }

    public void setOriginY() throws Exception {
        MMCoreJJNI.CMMCore_setOriginY__SWIG_1(this.swigCPtr, this);
    }

    public void setAdapterOriginXY(String xyStageLabel, double newXUm, double newYUm) throws Exception {
        MMCoreJJNI.CMMCore_setAdapterOriginXY__SWIG_0(this.swigCPtr, this, xyStageLabel, newXUm, newYUm);
    }

    public void setAdapterOriginXY(double newXUm, double newYUm) throws Exception {
        MMCoreJJNI.CMMCore_setAdapterOriginXY__SWIG_1(this.swigCPtr, this, newXUm, newYUm);
    }

    public boolean isXYStageSequenceable(String xyStageLabel) throws Exception {
        return MMCoreJJNI.CMMCore_isXYStageSequenceable(this.swigCPtr, this, xyStageLabel);
    }

    public void startXYStageSequence(String xyStageLabel) throws Exception {
        MMCoreJJNI.CMMCore_startXYStageSequence(this.swigCPtr, this, xyStageLabel);
    }

    public void stopXYStageSequence(String xyStageLabel) throws Exception {
        MMCoreJJNI.CMMCore_stopXYStageSequence(this.swigCPtr, this, xyStageLabel);
    }

    public int getXYStageSequenceMaxLength(String xyStageLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getXYStageSequenceMaxLength(this.swigCPtr, this, xyStageLabel);
    }

    public void loadXYStageSequence(String xyStageLabel, DoubleVector xSequence, DoubleVector ySequence) throws Exception {
        MMCoreJJNI.CMMCore_loadXYStageSequence(this.swigCPtr, this, xyStageLabel, DoubleVector.getCPtr(xSequence), xSequence, DoubleVector.getCPtr(ySequence), ySequence);
    }

    public void setSerialProperties(String portName, String answerTimeout, String baudRate, String delayBetweenCharsMs, String handshaking, String parity, String stopBits) throws Exception {
        MMCoreJJNI.CMMCore_setSerialProperties(this.swigCPtr, this, portName, answerTimeout, baudRate, delayBetweenCharsMs, handshaking, parity, stopBits);
    }

    public void setSerialPortCommand(String portLabel, String command, String term) throws Exception {
        MMCoreJJNI.CMMCore_setSerialPortCommand(this.swigCPtr, this, portLabel, command, term);
    }

    public String getSerialPortAnswer(String portLabel, String term) throws Exception {
        return MMCoreJJNI.CMMCore_getSerialPortAnswer(this.swigCPtr, this, portLabel, term);
    }

    public void writeToSerialPort(String portLabel, CharVector data) throws Exception {
        MMCoreJJNI.CMMCore_writeToSerialPort(this.swigCPtr, this, portLabel, CharVector.getCPtr(data), data);
    }

    public CharVector readFromSerialPort(String portLabel) throws Exception {
        return new CharVector(MMCoreJJNI.CMMCore_readFromSerialPort(this.swigCPtr, this, portLabel), true);
    }

    public void setSLMImage(String slmLabel, byte[] pixels) throws Exception {
        MMCoreJJNI.CMMCore_setSLMImage__SWIG_0(this.swigCPtr, this, slmLabel, pixels);
    }

    public void setSLMImage(String slmLabel, int[] pixels) throws Exception {
        MMCoreJJNI.CMMCore_setSLMImage__SWIG_1(this.swigCPtr, this, slmLabel, pixels);
    }

    public void setSLMPixelsTo(String slmLabel, short intensity) throws Exception {
        MMCoreJJNI.CMMCore_setSLMPixelsTo__SWIG_0(this.swigCPtr, this, slmLabel, intensity);
    }

    public void setSLMPixelsTo(String slmLabel, short red, short green, short blue) throws Exception {
        MMCoreJJNI.CMMCore_setSLMPixelsTo__SWIG_1(this.swigCPtr, this, slmLabel, red, green, blue);
    }

    public void displaySLMImage(String slmLabel) throws Exception {
        MMCoreJJNI.CMMCore_displaySLMImage(this.swigCPtr, this, slmLabel);
    }

    public void setSLMExposure(String slmLabel, double exposure_ms) throws Exception {
        MMCoreJJNI.CMMCore_setSLMExposure(this.swigCPtr, this, slmLabel, exposure_ms);
    }

    public double getSLMExposure(String slmLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getSLMExposure(this.swigCPtr, this, slmLabel);
    }

    public long getSLMWidth(String slmLabel) {
        return MMCoreJJNI.CMMCore_getSLMWidth(this.swigCPtr, this, slmLabel);
    }

    public long getSLMHeight(String slmLabel) {
        return MMCoreJJNI.CMMCore_getSLMHeight(this.swigCPtr, this, slmLabel);
    }

    public long getSLMNumberOfComponents(String slmLabel) {
        return MMCoreJJNI.CMMCore_getSLMNumberOfComponents(this.swigCPtr, this, slmLabel);
    }

    public long getSLMBytesPerPixel(String slmLabel) {
        return MMCoreJJNI.CMMCore_getSLMBytesPerPixel(this.swigCPtr, this, slmLabel);
    }

    public int getSLMSequenceMaxLength(String slmLabel) {
        return MMCoreJJNI.CMMCore_getSLMSequenceMaxLength(this.swigCPtr, this, slmLabel);
    }

    public void startSLMSequence(String slmLabel) throws Exception {
        MMCoreJJNI.CMMCore_startSLMSequence(this.swigCPtr, this, slmLabel);
    }

    public void stopSLMSequence(String slmLabel) throws Exception {
        MMCoreJJNI.CMMCore_stopSLMSequence(this.swigCPtr, this, slmLabel);
    }

    public void loadSLMSequence(String slmLabel, List<byte[]> imageSequence) throws Exception {
        MMCoreJJNI.CMMCore_loadSLMSequence(this.swigCPtr, this, slmLabel, imageSequence);
    }

    public void pointGalvoAndFire(String galvoLabel, double x, double y, double pulseTime_us) throws Exception {
        MMCoreJJNI.CMMCore_pointGalvoAndFire(this.swigCPtr, this, galvoLabel, x, y, pulseTime_us);
    }

    public void setGalvoSpotInterval(String galvoLabel, double pulseTime_us) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoSpotInterval(this.swigCPtr, this, galvoLabel, pulseTime_us);
    }

    public void setGalvoPosition(String galvoLabel, double x, double y) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoPosition(this.swigCPtr, this, galvoLabel, x, y);
    }

    public void getGalvoPosition(String galvoLabel, double[] x_stage, double[] y_stage) throws Exception {
        MMCoreJJNI.CMMCore_getGalvoPosition(this.swigCPtr, this, galvoLabel, x_stage, y_stage);
    }

    public void setGalvoIlluminationState(String galvoLabel, boolean on) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoIlluminationState(this.swigCPtr, this, galvoLabel, on);
    }

    public double getGalvoXRange(String galvoLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getGalvoXRange(this.swigCPtr, this, galvoLabel);
    }

    public double getGalvoXMinimum(String galvoLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getGalvoXMinimum(this.swigCPtr, this, galvoLabel);
    }

    public double getGalvoYRange(String galvoLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getGalvoYRange(this.swigCPtr, this, galvoLabel);
    }

    public double getGalvoYMinimum(String galvoLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getGalvoYMinimum(this.swigCPtr, this, galvoLabel);
    }

    public void addGalvoPolygonVertex(String galvoLabel, int polygonIndex, double x, double y) throws Exception {
        MMCoreJJNI.CMMCore_addGalvoPolygonVertex(this.swigCPtr, this, galvoLabel, polygonIndex, x, y);
    }

    public void deleteGalvoPolygons(String galvoLabel) throws Exception {
        MMCoreJJNI.CMMCore_deleteGalvoPolygons(this.swigCPtr, this, galvoLabel);
    }

    public void loadGalvoPolygons(String galvoLabel) throws Exception {
        MMCoreJJNI.CMMCore_loadGalvoPolygons(this.swigCPtr, this, galvoLabel);
    }

    public void setGalvoPolygonRepetitions(String galvoLabel, int repetitions) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoPolygonRepetitions(this.swigCPtr, this, galvoLabel, repetitions);
    }

    public void runGalvoPolygons(String galvoLabel) throws Exception {
        MMCoreJJNI.CMMCore_runGalvoPolygons(this.swigCPtr, this, galvoLabel);
    }

    public void runGalvoSequence(String galvoLabel) throws Exception {
        MMCoreJJNI.CMMCore_runGalvoSequence(this.swigCPtr, this, galvoLabel);
    }

    public String getGalvoChannel(String galvoLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getGalvoChannel(this.swigCPtr, this, galvoLabel);
    }

    public boolean supportsDeviceDetection(String deviceLabel) {
        return MMCoreJJNI.CMMCore_supportsDeviceDetection(this.swigCPtr, this, deviceLabel);
    }

    public DeviceDetectionStatus detectDevice(String deviceLabel) {
        return DeviceDetectionStatus.swigToEnum(MMCoreJJNI.CMMCore_detectDevice(this.swigCPtr, this, deviceLabel));
    }

    public String getParentLabel(String peripheralLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getParentLabel(this.swigCPtr, this, peripheralLabel);
    }

    public void setParentLabel(String deviceLabel, String parentHubLabel) throws Exception {
        MMCoreJJNI.CMMCore_setParentLabel(this.swigCPtr, this, deviceLabel, parentHubLabel);
    }

    public StrVector getInstalledDevices(String hubLabel) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getInstalledDevices(this.swigCPtr, this, hubLabel), true);
    }

    public String getInstalledDeviceDescription(String hubLabel, String peripheralLabel) throws Exception {
        return MMCoreJJNI.CMMCore_getInstalledDeviceDescription(this.swigCPtr, this, hubLabel, peripheralLabel);
    }

    public StrVector getLoadedPeripheralDevices(String hubLabel) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getLoadedPeripheralDevices(this.swigCPtr, this, hubLabel), true);
    }

    public String getUserId() {
        return MMCoreJJNI.CMMCore_getUserId(this.swigCPtr, this);
    }

    public String getHostName() {
        return MMCoreJJNI.CMMCore_getHostName(this.swigCPtr, this);
    }

    public StrVector getMACAddresses() {
        return new StrVector(MMCoreJJNI.CMMCore_getMACAddresses(this.swigCPtr, this), true);
    }
}

