/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.template.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryHandler;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TemplateQueryHandler
extends PathQueryHandler {
    Map<String, TemplateQuery> templates;
    String templateName;
    String templateTitle;
    String templateComment;
    Map<PathConstraint, String> constraintDescriptions = new HashMap<PathConstraint, String>();
    List<PathConstraint> editableConstraints = new ArrayList<PathConstraint>();
    Map<PathConstraint, SwitchOffAbility> constraintSwitchables = new HashMap<PathConstraint, SwitchOffAbility>();

    public TemplateQueryHandler(Map<String, TemplateQuery> templates, int version) {
        super(new HashMap<String, PathQuery>(), version);
        this.templates = templates;
        this.reset();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if ("template".equals(qName)) {
            this.templateName = attrs.getValue("name");
            this.templateTitle = attrs.getValue("title");
            if (attrs.getValue("description") != null && this.templateTitle == null) {
                this.templateTitle = attrs.getValue("description");
            }
            this.templateComment = attrs.getValue("comment");
        } else if ("constraint".equals(qName)) {
            String path = attrs.getValue("path");
            if (this.currentNodePath != null) {
                if (path != null) {
                    throw new SAXException("Cannot set path in a constraint inside a node");
                }
                path = this.currentNodePath;
            }
            String code = attrs.getValue("code");
            String type = attrs.getValue("type");
            if (type != null) {
                this.query.addConstraint(new PathConstraintSubclass(path, type));
            } else {
                if ((path = path.replace(':', '.')) == null) {
                    throw new NullPointerException("Null path while processing template " + this.templateName);
                }
                this.constraintPath = path;
                this.constraintAttributes = new HashMap();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.constraintAttributes.put(attrs.getQName(i), attrs.getValue(i));
                }
                this.constraintValues = new LinkedHashSet();
                this.constraintCode = code;
            }
        } else {
            super.startElement(uri, localName, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("template".equals(qName)) {
            TemplateQuery t = new TemplateQuery(this.templateName, this.templateTitle, this.templateComment, this.query);
            t.setEditableConstraints(this.editableConstraints);
            for (Map.Entry<PathConstraint, String> entry : this.constraintDescriptions.entrySet()) {
                t.setConstraintDescription(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<PathConstraint, Object> entry : this.constraintSwitchables.entrySet()) {
                t.setSwitchOffAbility(entry.getKey(), (SwitchOffAbility)((Object)entry.getValue()));
            }
            this.templates.put(this.templateName, t);
            this.reset();
        } else if ("constraint".equals(qName) && this.constraintPath != null) {
            PathConstraint constraint = this.processConstraint(this.query, this.constraintPath, this.constraintAttributes, this.constraintValues);
            if (this.constraintCode == null) {
                this.query.addConstraint(constraint);
            } else {
                this.query.addConstraint(constraint, this.constraintCode);
            }
            String description = (String)this.constraintAttributes.get("description");
            String string = (String)this.constraintAttributes.get("editable");
            if ("true".equals(string)) {
                this.editableConstraints.add(constraint);
            }
            this.constraintDescriptions.put(constraint, description);
            String switchable = (String)this.constraintAttributes.get("switchable");
            if ("on".equals(switchable)) {
                this.constraintSwitchables.put(constraint, SwitchOffAbility.ON);
            } else if ("off".equals(switchable)) {
                this.constraintSwitchables.put(constraint, SwitchOffAbility.OFF);
            }
            this.constraintPath = null;
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    private void reset() {
        this.templateName = "";
        this.templateTitle = "";
        this.templateComment = "";
        this.editableConstraints.clear();
        this.constraintDescriptions.clear();
        this.constraintSwitchables.clear();
    }
}

