/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.template.xml;

import java.io.Reader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.template.xml.TemplateQueryHandler;
import org.intermine.util.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TemplateQueryBinding
extends PathQueryBinding {
    public static final TemplateQueryBinding INSTANCE = new TemplateQueryBinding();

    public static void marshal(TemplateQuery template, XMLStreamWriter writer, int version) {
        INSTANCE.doMarshal(template, writer, version);
    }

    public void doMarshal(TemplateQuery template, XMLStreamWriter writer, int version) {
        try {
            writer.writeCharacters("\n");
            writer.writeStartElement("template");
            writer.writeAttribute("name", template.getName());
            writer.writeAttribute("title", template.getTitle());
            if (template.getDescription() == null) {
                writer.writeAttribute("longDescription", "");
            } else {
                writer.writeAttribute("longDescription", template.getDescription());
            }
            if (template.getComment() == null) {
                writer.writeAttribute("comment", "");
            } else {
                writer.writeAttribute("comment", template.getComment());
            }
            this.doMarshal(template, template.getName(), template.getModel().getName(), writer, version);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doAdditionalConstraintStuff(PathQuery query, PathConstraint constraint, XMLStreamWriter writer) throws XMLStreamException {
        SwitchOffAbility switchOffAbility;
        TemplateQuery template = (TemplateQuery)query;
        if (template.isEditable(constraint)) {
            writer.writeAttribute("editable", "true");
        } else {
            writer.writeAttribute("editable", "false");
        }
        String description = template.getConstraintDescription(constraint);
        if (description != null) {
            writer.writeAttribute("description", description);
        }
        if (SwitchOffAbility.ON.equals((Object)(switchOffAbility = template.getSwitchOffAbility(constraint)))) {
            writer.writeAttribute("switchable", "on");
        } else if (SwitchOffAbility.OFF.equals((Object)switchOffAbility)) {
            writer.writeAttribute("switchable", "off");
        }
    }

    public static String marshal(TemplateQuery template, int version) {
        StringWriter sw = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(sw);
            TemplateQueryBinding.marshal(template, writer, version);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public static Map<String, TemplateQuery> unmarshalTemplates(Reader reader, int version) {
        LinkedHashMap<String, TemplateQuery> templates = new LinkedHashMap<String, TemplateQuery>();
        try {
            SAXParser.parse((InputSource)new InputSource(reader), (DefaultHandler)new TemplateQueryHandler((Map<String, TemplateQuery>)templates, version));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return templates;
    }
}

