/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.template;

import java.util.List;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.pathquery.PathConstraint;
import org.intermine.template.SwitchOffAbility;

public class TemplateValue {
    private ConstraintOp op;
    private PathConstraint constraint;
    private String value;
    private List<String> values;
    private String extraValue;
    private boolean bagConstraint = false;
    private boolean objectConstraint = false;
    private ValueType valueType;
    private SwitchOffAbility switchOffAbility;

    public TemplateValue(PathConstraint constraint, ConstraintOp op, ValueType valueType, SwitchOffAbility switchOffAbility) {
        this(constraint, op, null, valueType, null, null, switchOffAbility);
    }

    public TemplateValue(PathConstraint constraint, ConstraintOp op, String value, ValueType valueType, SwitchOffAbility switchOffAbility) {
        this(constraint, op, value, valueType, null, null, switchOffAbility);
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
    }

    public TemplateValue(PathConstraint constraint, ConstraintOp op, String value, ValueType valueType, String extraValue, SwitchOffAbility switchOffAbility) {
        this(constraint, op, value, valueType, extraValue, null, switchOffAbility);
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
    }

    public TemplateValue(PathConstraint constraint, ConstraintOp op, ValueType valueType, List<String> values, SwitchOffAbility switchOffAbility) {
        this(constraint, op, null, valueType, null, values, switchOffAbility);
        if (values == null) {
            throw new IllegalArgumentException("values must not be null");
        }
    }

    private TemplateValue(PathConstraint constraint, ConstraintOp op, String value, ValueType valueType, String extraValue, List<String> values, SwitchOffAbility switchOffAbility) {
        if (value != null && values != null) {
            throw new IllegalArgumentException("Cannot have both value and values");
        }
        this.constraint = constraint;
        this.op = op;
        this.value = value;
        this.valueType = valueType;
        this.values = values;
        this.extraValue = extraValue;
        this.switchOffAbility = switchOffAbility;
    }

    public String getExtraValue() {
        return this.extraValue;
    }

    public boolean isMultipleValue() {
        return this.values != null;
    }

    public List<String> getValues() {
        return this.values;
    }

    public ConstraintOp getOperation() {
        return this.op;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isBagConstraint() {
        return this.valueType == ValueType.BAG_VALUE;
    }

    public boolean isObjectConstraint() {
        return this.valueType == ValueType.OBJECT_VALUE;
    }

    public PathConstraint getConstraint() {
        return this.constraint;
    }

    public SwitchOffAbility getSwitchOffAbility() {
        return this.switchOffAbility;
    }

    public String toString() {
        return this.constraint.getPath() + " " + this.op + " " + this.value + " (" + this.extraValue + ", " + this.objectConstraint + ", " + this.bagConstraint + ") - " + (Object)((Object)this.switchOffAbility);
    }

    public static enum ValueType {
        SIMPLE_VALUE,
        BAG_VALUE,
        OBJECT_VALUE;

    }
}

