/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.xml.TemplateQueryBinding;

public class TemplateQuery
extends PathQuery {
    protected String name;
    protected String title;
    protected String comment;
    protected boolean edited = false;
    protected List<PathConstraint> editableConstraints = new ArrayList<PathConstraint>();
    protected Map<PathConstraint, String> constraintDescriptions = new HashMap<PathConstraint, String>();
    protected Map<PathConstraint, SwitchOffAbility> constraintSwitchOffAbility = new HashMap<PathConstraint, SwitchOffAbility>();

    public TemplateQuery(String name, String title, String comment, PathQuery query) {
        super(query);
        this.name = name;
        this.title = title;
        this.comment = comment;
    }

    public TemplateQuery(TemplateQuery prototype) {
        super(prototype);
        this.name = prototype.name;
        this.title = prototype.title;
        this.comment = prototype.comment;
        this.edited = prototype.edited;
        this.editableConstraints = new ArrayList<PathConstraint>(prototype.editableConstraints);
        this.constraintDescriptions = new HashMap<PathConstraint, String>(prototype.constraintDescriptions);
        this.constraintSwitchOffAbility = new HashMap<PathConstraint, SwitchOffAbility>(prototype.constraintSwitchOffAbility);
    }

    @Override
    public synchronized TemplateQuery clone() {
        return new TemplateQuery(this);
    }

    @Override
    public PathQuery getQueryToExecute() {
        TemplateQuery queryToExecute = this.clone();
        for (PathConstraint con : queryToExecute.getEditableConstraints()) {
            if (!SwitchOffAbility.OFF.equals((Object)this.getSwitchOffAbility(con))) continue;
            queryToExecute.removeConstraint(con);
        }
        return queryToExecute;
    }

    public synchronized void setEditable(PathConstraint constraint, boolean editable) {
        if (constraint == null) {
            throw new NullPointerException("Cannot set null constraint to be editable");
        }
        if (!this.getConstraints().containsKey(constraint)) {
            throw new NoSuchElementException("Constraint " + constraint + " is not in the query");
        }
        if (editable) {
            if (!this.editableConstraints.contains(constraint)) {
                this.editableConstraints.add(constraint);
            }
        } else {
            this.editableConstraints.remove(constraint);
        }
    }

    public synchronized boolean isEditable(PathConstraint constraint) {
        if (constraint == null) {
            throw new NullPointerException("Cannot fetch editable status of null constraint");
        }
        if (!this.getConstraints().containsKey(constraint)) {
            throw new NoSuchElementException("Constraint " + constraint + " is not in the query");
        }
        return this.editableConstraints.contains(constraint);
    }

    public synchronized boolean isOptional(PathConstraint constraint) {
        return !this.isRequired(constraint);
    }

    public synchronized boolean isRequired(PathConstraint constraint) {
        if (constraint == null) {
            throw new NullPointerException("Cannot fetch editable status of null constraint");
        }
        if (!this.getConstraints().containsKey(constraint)) {
            throw new NoSuchElementException("Constraint " + constraint + " is not in the query");
        }
        boolean isRequired = SwitchOffAbility.LOCKED.equals((Object)this.getSwitchOffAbility(constraint));
        return isRequired;
    }

    public synchronized void setEditableConstraints(List<PathConstraint> editable) {
        for (PathConstraint constraint : editable) {
            if (this.getConstraints().containsKey(constraint)) continue;
            throw new NoSuchElementException("Constraint " + constraint + " is not in the query");
        }
        this.sortConstraints(editable);
        this.editableConstraints = new ArrayList<PathConstraint>(editable);
    }

    public synchronized List<PathConstraint> getEditableConstraints(String path) {
        ArrayList<PathConstraint> ecs = new ArrayList<PathConstraint>();
        for (PathConstraint constraint : this.editableConstraints) {
            if (!path.equals(constraint.getPath())) continue;
            ecs.add(constraint);
        }
        return ecs;
    }

    public synchronized Map<PathConstraint, SwitchOffAbility> getConstraintSwitchOffAbility() {
        return Collections.unmodifiableMap(new HashMap<PathConstraint, SwitchOffAbility>(this.constraintSwitchOffAbility));
    }

    public synchronized void setConstraintDescription(PathConstraint constraint, String description) {
        if (constraint == null) {
            throw new NullPointerException("Cannot set description on null constraint");
        }
        if (!this.getConstraints().containsKey(constraint)) {
            throw new NoSuchElementException("Constraint " + constraint + " is not in the query");
        }
        if (description == null) {
            this.constraintDescriptions.remove(constraint);
        } else {
            this.constraintDescriptions.put(constraint, description);
        }
    }

    public synchronized String getConstraintDescription(PathConstraint constraint) {
        if (constraint == null) {
            throw new NullPointerException("Cannot set description on null constraint");
        }
        if (!this.getConstraints().containsKey(constraint)) {
            throw new NoSuchElementException("Constraint " + constraint + " is not in the query");
        }
        return this.constraintDescriptions.get(constraint);
    }

    public synchronized Map<PathConstraint, String> getConstraintDescriptions() {
        return Collections.unmodifiableMap(new HashMap<PathConstraint, String>(this.constraintDescriptions));
    }

    public synchronized void setSwitchOffAbility(PathConstraint constraint, SwitchOffAbility sbitchOffAbility) {
        if (constraint == null) {
            throw new NullPointerException("Cannot set sbitch-off-ability on null constraint");
        }
        if (sbitchOffAbility == null) {
            throw new NullPointerException("Cannot set null sbitch-off-ability on constraint " + constraint);
        }
        if (!this.getConstraints().containsKey(constraint)) {
            throw new NoSuchElementException("Constraint " + constraint + " is not in the query");
        }
        this.constraintSwitchOffAbility.put(constraint, sbitchOffAbility);
    }

    public synchronized SwitchOffAbility getSwitchOffAbility(PathConstraint constraint) {
        if (constraint == null) {
            throw new NullPointerException("Cannot set sbitch-off-ability on null constraint");
        }
        if (!this.getConstraints().containsKey(constraint)) {
            throw new NoSuchElementException("Constraint " + constraint + " is not in the query");
        }
        SwitchOffAbility sbitchOffAbility = this.constraintSwitchOffAbility.get(constraint);
        if (sbitchOffAbility == null) {
            return SwitchOffAbility.LOCKED;
        }
        return sbitchOffAbility;
    }

    public synchronized List<PathConstraint> getEditableConstraints() {
        return Collections.unmodifiableList(new ArrayList<PathConstraint>(this.editableConstraints));
    }

    public synchronized List<PathConstraint> getModifiableEditableConstraints() {
        return new ArrayList<PathConstraint>(this.editableConstraints);
    }

    @Override
    public synchronized void replaceConstraint(PathConstraint old, PathConstraint replacement) {
        SwitchOffAbility sbitchOffAbility;
        String description;
        super.replaceConstraint(old, replacement);
        if (this.editableConstraints.contains(old)) {
            if (replacement instanceof PathConstraintSubclass || replacement instanceof PathConstraintLoop) {
                this.editableConstraints.remove(this.editableConstraints.indexOf(old));
            } else {
                this.editableConstraints.set(this.editableConstraints.indexOf(old), replacement);
            }
        }
        if ((description = this.constraintDescriptions.remove(old)) != null) {
            this.constraintDescriptions.put(replacement, description);
        }
        if ((sbitchOffAbility = this.constraintSwitchOffAbility.remove(old)) != null) {
            this.constraintSwitchOffAbility.put(replacement, sbitchOffAbility);
        }
    }

    @Override
    public synchronized void removeConstraint(PathConstraint constraint) {
        super.removeConstraint(constraint);
        this.editableConstraints.remove(constraint);
        this.constraintDescriptions.remove(constraint);
        this.constraintSwitchOffAbility.remove(constraint);
    }

    @Override
    public synchronized void clearConstraints() {
        this.editableConstraints.clear();
        this.constraintDescriptions.clear();
        this.constraintSwitchOffAbility.clear();
    }

    public TemplateQuery cloneWithoutEditableConstraints() {
        TemplateQuery clone = this.clone();
        ArrayList<PathConstraint> editable = new ArrayList<PathConstraint>(clone.editableConstraints);
        for (PathConstraint constraint : editable) {
            clone.removeConstraint(constraint);
        }
        return clone;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getComment() {
        return this.comment;
    }

    public synchronized List<String> getEditablePaths() {
        ArrayList<String> editablePaths = new ArrayList<String>();
        for (PathConstraint constraint : this.editableConstraints) {
            if (editablePaths.contains(constraint.getPath())) continue;
            editablePaths.add(constraint.getPath());
        }
        return editablePaths;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public synchronized String toXml(int version) {
        StringWriter sw = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(sw);
            TemplateQueryBinding.marshal(this, writer, version);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    @Override
    public synchronized String toString() {
        String res = super.toString();
        res = this.getClass().getName() + "{ name: " + this.getName() + ", title: " + this.getTitle() + ", comment: " + this.getComment() + ", description: " + this.getDescription() + ", " + res + "}";
        return res;
    }

    public synchronized String toJSON() {
        StringBuffer sb = new StringBuffer("{");
        this.addJsonProperty(sb, "name", this.getName());
        this.addJsonProperty(sb, "title", this.getTitle());
        this.addJsonProperty(sb, "description", this.getDescription());
        this.addJsonProperty(sb, "comment", this.getComment());
        this.addJsonProperty(sb, "view", this.getView());
        sb.append(",\"constraints\":[");
        Iterator<PathConstraint> iter = this.getEditableConstraints().iterator();
        Map<PathConstraint, String> codeForConstraint = this.getConstraints();
        while (iter.hasNext()) {
            PathConstraint pc = iter.next();
            StringBuffer pcw = new StringBuffer("{");
            this.addJsonProperty(pcw, "path", pc.getPath());
            this.addJsonProperty(pcw, "op", pc.getOp().toString());
            this.addJsonProperty(pcw, "value", PathConstraint.getValue(pc));
            this.addJsonProperty(pcw, "code", codeForConstraint.get(pc));
            this.addJsonProperty(pcw, "extraValue", PathConstraint.getExtraValue(pc));
            pcw.append("}");
            sb.append(pcw.toString());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    private void addJsonProperty(StringBuffer sb, String key, Object value) {
        if (value != null) {
            if (!sb.toString().endsWith("{")) {
                sb.append(",");
            }
            sb.append(this.formatKVPair(key, value));
        }
    }

    private String formatKVPair(String key, Object value) {
        if (value instanceof List) {
            StringBuffer sb = new StringBuffer("[");
            boolean needsSep = false;
            for (Object obj : (List)value) {
                if (needsSep) {
                    sb.append(",");
                }
                sb.append("\"" + StringEscapeUtils.escapeJava((String)obj.toString()) + "\"");
                needsSep = true;
            }
            sb.append("]");
            return "\"" + key + "\":" + sb.toString();
        }
        if (value instanceof String) {
            String newValue = StringEscapeUtils.escapeJava((String)((String)value));
            return "\"" + key + "\":\"" + newValue + "\"";
        }
        throw new IllegalArgumentException(value + " must be either String or a list of strings");
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof TemplateQuery) {
            return ((TemplateQuery)other).toXml().equals(this.toXml());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toXml().hashCode();
    }
}

