/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.metadata.Model;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.pathquery.OuterJoinStatus;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintIds;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PathQueryHandler
extends DefaultHandler {
    private final Map<String, PathQuery> queries;
    private String queryName;
    protected PathQuery query;
    protected String constraintLogic = null;
    protected String currentNodePath = null;
    private Model model = null;
    protected int version;
    private List<PathConstraintSubclass> questionableSubclasses;
    public static final Set<String> ATTRIBUTE_TYPES = new HashSet<String>(Arrays.asList("boolean", "float", "double", "short", "int", "long", "Boolean", "Float", "Double", "Short", "Integer", "Long", "BigDecimal", "Date", "String"));
    private StringBuilder valueBuffer = null;
    protected String constraintPath = null;
    protected Map<String, String> constraintAttributes = null;
    protected Collection<String> constraintValues = null;
    protected String constraintCode = null;
    private static final Logger LOG = Logger.getLogger(PathQueryHandler.class);

    public PathQueryHandler(Map<String, PathQuery> queries, int version) {
        this.queries = queries;
        this.version = version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (this.valueBuffer != null) {
            throw new SAXException("Cannot have any tags inside a value tag");
        }
        if (this.constraintPath != null && !"value".equals(qName)) {
            throw new SAXException("Cannot have anything other than value tag inside a constraint");
        }
        if ("query-list".equals(qName)) return;
        if ("query".equals(qName)) {
            this.queryName = this.validateName(attrs.getValue("name"));
            try {
                this.model = Model.getInstanceByName((String)attrs.getValue("model"));
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            this.query = new PathQuery(this.model);
            if (attrs.getValue("title") != null && !attrs.getValue("title").isEmpty()) {
                this.query.setTitle(attrs.getValue("title"));
            }
            if (attrs.getValue("longDescription") != null) {
                this.query.setDescription(attrs.getValue("longDescription"));
            }
            if (attrs.getValue("view") != null) {
                String view = attrs.getValue("view");
                if (view.contains(":")) {
                    String[] viewPathArray;
                    for (String viewPath : viewPathArray = PathQuery.SPACE_SPLITTER.split(view.trim())) {
                        this.setOuterJoins(this.query, viewPath);
                    }
                    view = view.replace(':', '.');
                }
                this.query.addViewSpaceSeparated(view);
            }
            if (attrs.getValue("sortOrder") != null && !StringUtils.isBlank((String)attrs.getValue("sortOrder"))) {
                this.query.addOrderBySpaceSeparated(attrs.getValue("sortOrder"));
            }
            this.constraintLogic = attrs.getValue("constraintLogic");
            this.questionableSubclasses = new ArrayList<PathConstraintSubclass>();
            return;
        }
        if ("node".equals(qName)) {
            String type;
            this.currentNodePath = attrs.getValue("path");
            if (this.currentNodePath.contains(":")) {
                this.setOuterJoins(this.query, this.currentNodePath);
                this.currentNodePath = this.currentNodePath.replace(':', '.');
            }
            if ((type = attrs.getValue("type")) == null || ATTRIBUTE_TYPES.contains(type) || !this.currentNodePath.contains(".") && !this.currentNodePath.contains(":")) return;
            PathConstraintSubclass subclass = new PathConstraintSubclass(this.currentNodePath, type);
            this.query.addConstraint(subclass);
            this.questionableSubclasses.add(subclass);
            return;
        }
        if ("constraint".equals(qName)) {
            String path = attrs.getValue("path");
            if (this.currentNodePath != null) {
                if (path != null) {
                    throw new SAXException("Cannot set path in a constraint inside a node");
                }
                path = this.currentNodePath;
            }
            String code = attrs.getValue("code");
            String type = attrs.getValue("type");
            if (type != null) {
                this.query.addConstraint(new PathConstraintSubclass(path, type));
                return;
            } else {
                this.constraintPath = path = path.replace(':', '.');
                this.constraintAttributes = new HashMap<String, String>();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.constraintAttributes.put(attrs.getQName(i), attrs.getValue(i));
                }
                this.constraintValues = new LinkedHashSet<String>();
                this.constraintCode = code;
            }
            return;
        }
        if ("pathDescription".equals(qName)) {
            String pathString = attrs.getValue("pathString");
            String description = attrs.getValue("description");
            if (pathString.endsWith(".")) {
                throw new SAXException("Invalid path '" + pathString + "' for description: " + description);
            }
            String pathToCheck = pathString + ".";
            for (String viewString : this.query.getView()) {
                if (!viewString.startsWith(pathToCheck)) continue;
                this.query.setDescription(pathString, description);
                return;
            }
            return;
        }
        if ("join".equals(qName)) {
            String pathString = attrs.getValue("path");
            String type = attrs.getValue("style");
            if ("INNER".equals(type.toUpperCase())) {
                this.query.setOuterJoinStatus(pathString, OuterJoinStatus.INNER);
                return;
            } else {
                if (!"OUTER".equals(type.toUpperCase())) throw new SAXException("Unknown join style " + type + " for path " + pathString);
                this.query.setOuterJoinStatus(pathString, OuterJoinStatus.OUTER);
            }
            return;
        } else {
            if (!"value".equals(qName)) return;
            this.valueBuffer = new StringBuilder();
        }
    }

    public PathConstraint processConstraint(PathQuery q, String path, Map<String, String> attrs, Collection<String> values) throws SAXException {
        if (path == null) {
            throw new SAXException("Bad constraint: Path is null. " + q.toString());
        }
        ConstraintOp constraintOp = ConstraintOp.getConstraintOp((String)attrs.get("op"));
        if (ConstraintOp.CONTAINS.equals(constraintOp)) {
            constraintOp = ConstraintOp.CONTAINS;
        }
        if (ConstraintOp.DOES_NOT_CONTAIN.equals(constraintOp)) {
            constraintOp = ConstraintOp.DOES_NOT_CONTAIN;
        }
        if (PathConstraintAttribute.VALID_OPS.contains(constraintOp)) {
            boolean isLoop = false;
            if (PathConstraintLoop.VALID_OPS.contains(constraintOp)) {
                try {
                    Path constraintPath2 = q.makePath(path);
                    if (!constraintPath2.endIsAttribute()) {
                        isLoop = true;
                    }
                }
                catch (PathException e) {
                    LOG.error((Object)("Cannot recognise path in constraint: " + path), (Throwable)e);
                }
            }
            if (isLoop) {
                String loopPath = attrs.get("loopPath");
                if (loopPath == null) {
                    loopPath = attrs.get("value");
                }
                loopPath = loopPath.replace(':', '.');
                return new PathConstraintLoop(path, constraintOp, loopPath);
            }
            String constraintValue = attrs.get("value");
            return new PathConstraintAttribute(path, constraintOp, constraintValue);
        }
        if (PathConstraintNull.VALID_OPS.contains(constraintOp)) {
            return new PathConstraintNull(path, constraintOp);
        }
        if (PathConstraintBag.VALID_OPS.contains(constraintOp)) {
            String bag = attrs.get("value");
            String ids = attrs.get("ids");
            if (bag != null) {
                return new PathConstraintBag(path, constraintOp, bag);
            }
            if (ids != null) {
                String[] idArray = ids.split(",");
                LinkedHashSet<Integer> idsCollection = new LinkedHashSet<Integer>();
                for (String id : idArray) {
                    try {
                        idsCollection.add(Integer.valueOf(id.trim()));
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("List of IDs contains invalid integer: " + id, e);
                    }
                }
                return new PathConstraintIds(path, constraintOp, idsCollection);
            }
            throw new SAXException("Invalid query: operation was: " + constraintOp + " but no bag or ids were provided (from text \"" + attrs.get("op") + "\", attributes: " + attrs + ")");
        }
        if (PathConstraintMultiValue.VALID_OPS.contains(constraintOp)) {
            LinkedHashSet<String> valuesCollection = new LinkedHashSet<String>();
            for (String value : values) {
                valuesCollection.add(value.trim());
            }
            return new PathConstraintMultiValue(path, constraintOp, valuesCollection);
        }
        if (ConstraintOp.LOOKUP.equals(constraintOp)) {
            String lookup = attrs.get("value");
            String extraValue = attrs.get("extraValue");
            return new PathConstraintLookup(path, lookup, extraValue);
        }
        throw new SAXException("Invalid operation type: " + constraintOp + " (from text \"" + attrs.get("op") + "\", attributes: " + attrs + ")");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("query".equals(qName)) {
            if (this.constraintLogic != null) {
                this.query.setConstraintLogic(this.constraintLogic);
            }
            if (this.query.isValid()) {
                try {
                    Map<String, String> subClasses = this.query.getSubclasses();
                    for (PathConstraintSubclass subclass : this.questionableSubclasses) {
                        HashMap<String, String> trimmedSubclasses = new HashMap<String, String>(subClasses);
                        trimmedSubclasses.remove(subclass.getPath());
                        Path path = new Path(this.model, subclass.getPath(), trimmedSubclasses);
                        if (!path.getEndClassDescriptor().getUnqualifiedName().equals(subclass.getType())) continue;
                        this.query.removeConstraint(subclass);
                    }
                }
                catch (PathException e) {
                    throw new Error("Error", e);
                }
            }
            this.queries.put(this.queryName, this.query);
        } else if ("node".equals(qName)) {
            this.currentNodePath = null;
        } else if ("constraint".equals(qName) && this.constraintPath != null) {
            PathConstraint constraint = this.processConstraint(this.query, this.constraintPath, this.constraintAttributes, this.constraintValues);
            if (this.constraintCode == null) {
                this.query.addConstraint(constraint);
            } else {
                this.query.addConstraint(constraint, this.constraintCode);
            }
            this.constraintPath = null;
        } else if ("value".equals(qName)) {
            if (this.valueBuffer == null || this.valueBuffer.length() < 1) {
                throw new NullPointerException("No value provided in value tag. Failed for template query: " + this.queryName + " on constraint: " + this.constraintPath);
            }
            this.constraintValues.add(this.valueBuffer.toString());
            this.valueBuffer = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.valueBuffer != null) {
            this.valueBuffer.append(ch, start, length);
        }
    }

    protected List<String> toStrings(List<Object> list) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object o : list) {
            strings.add(o.toString());
        }
        return strings;
    }

    protected String validateName(String name) {
        String validatedName = name;
        if (name == null || name.length() == 0) {
            validatedName = "unnamed_query";
        }
        if (this.queries.containsKey(validatedName)) {
            int i = 1;
            while (true) {
                String testName;
                if (!this.queries.containsKey(testName = validatedName + "_" + i)) {
                    return testName;
                }
                ++i;
            }
        }
        return validatedName;
    }

    protected void setOuterJoins(PathQuery query, String path) {
        int from = 0;
        while (path.indexOf(58, from) != -1) {
            int colonPos = path.indexOf(58, from);
            int nextDot = path.replace(':', '.').indexOf(46, colonPos + 1);
            String outerJoin = nextDot == -1 ? path : path.substring(0, nextDot);
            query.setOuterJoinStatus(outerJoin.replace(':', '.'), OuterJoinStatus.OUTER);
            from = colonPos + 1;
        }
    }
}

