/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.io.Reader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.OrderElement;
import org.intermine.pathquery.OuterJoinStatus;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintIds;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryHandler;
import org.intermine.util.SAXParser;
import org.intermine.util.StringUtil;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class PathQueryBinding {
    public static final PathQueryBinding INSTANCE = new PathQueryBinding();

    public static String marshal(PathQuery query, String queryName, String modelName, int version) {
        StringWriter sw = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(sw);
            PathQueryBinding.marshal(query, queryName, modelName, writer, version);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public static void marshal(PathQuery query, String queryName, String modelName, XMLStreamWriter writer, int version) {
        INSTANCE.doMarshal(query, queryName, modelName, writer, version);
    }

    public void doMarshal(PathQuery query, String queryName, String modelName, XMLStreamWriter writer, int version) {
        try {
            writer.writeStartElement("query");
            writer.writeAttribute("name", queryName);
            writer.writeAttribute("model", modelName);
            writer.writeAttribute("view", StringUtil.join(query.getView(), (String)" "));
            if (query.getDescription() != null) {
                writer.writeAttribute("longDescription", query.getDescription());
            }
            StringBuilder sort = new StringBuilder();
            boolean needComma = false;
            for (OrderElement oe : query.getOrderBy()) {
                if (needComma) {
                    sort.append(" ");
                }
                needComma = true;
                sort.append(oe.getOrderPath() + (oe.getDirection().equals((Object)OrderDirection.ASC) ? " asc" : " desc"));
            }
            String sortString = sort.toString();
            if (!"".equals(sortString)) {
                writer.writeAttribute("sortOrder", sortString);
            }
            String logic = query.getConstraintLogic();
            boolean hasMultipleConstraints = false;
            if (logic != null && logic.length() > 1) {
                writer.writeAttribute("constraintLogic", query.getConstraintLogic());
                hasMultipleConstraints = true;
            }
            this.marshalPathQueryJoinStyle(query, writer);
            this.marshalPathQueryDescriptions(query, writer);
            this.marshalPathQueryConstraints(query, writer, hasMultipleConstraints);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void marshalPathQueryJoinStyle(PathQuery query, XMLStreamWriter writer) throws XMLStreamException {
        for (Map.Entry<String, OuterJoinStatus> entry : query.getOuterJoinStatus().entrySet()) {
            writer.writeEmptyElement("join");
            writer.writeAttribute("path", entry.getKey());
            writer.writeAttribute("style", entry.getValue().toString());
        }
    }

    private void marshalPathQueryDescriptions(PathQuery query, XMLStreamWriter writer) throws XMLStreamException {
        for (Map.Entry<String, String> entry : query.getDescriptions().entrySet()) {
            String path = entry.getKey();
            String description = entry.getValue();
            writer.writeEmptyElement("pathDescription");
            writer.writeAttribute("pathString", path);
            writer.writeAttribute("description", description);
        }
    }

    private void marshalPathQueryConstraints(PathQuery query, XMLStreamWriter writer, boolean hasMultipleConstraints) throws XMLStreamException {
        for (Map.Entry<PathConstraint, String> constraint : query.getConstraints().entrySet()) {
            boolean emptyElement = true;
            if (constraint.getKey() instanceof PathConstraintMultiValue) {
                emptyElement = false;
            }
            if (emptyElement) {
                writer.writeEmptyElement("constraint");
            } else {
                writer.writeStartElement("constraint");
            }
            writer.writeAttribute("path", constraint.getKey().getPath());
            if (constraint.getValue() != null && hasMultipleConstraints) {
                writer.writeAttribute("code", constraint.getValue());
            }
            this.doAdditionalConstraintStuff(query, constraint.getKey(), writer);
            if (constraint.getKey() instanceof PathConstraintAttribute) {
                writer.writeAttribute("op", "" + constraint.getKey().getOp());
                String outputValue = ((PathConstraintAttribute)constraint.getKey()).getValue();
                writer.writeAttribute("value", "" + outputValue);
            } else if (constraint.getKey() instanceof PathConstraintNull) {
                writer.writeAttribute("op", "" + constraint.getKey().getOp());
            } else if (constraint.getKey() instanceof PathConstraintSubclass) {
                writer.writeAttribute("type", ((PathConstraintSubclass)constraint.getKey()).getType());
            } else if (constraint.getKey() instanceof PathConstraintBag) {
                writer.writeAttribute("op", "" + constraint.getKey().getOp());
                writer.writeAttribute("value", ((PathConstraintBag)constraint.getKey()).getBag());
            } else if (constraint.getKey() instanceof PathConstraintIds) {
                writer.writeAttribute("op", "" + constraint.getKey().getOp());
                StringBuilder sb = new StringBuilder();
                boolean needComma = false;
                for (Integer id : ((PathConstraintIds)constraint.getKey()).getIds()) {
                    if (needComma) {
                        sb.append(", ");
                    }
                    needComma = true;
                    sb.append("" + id);
                }
                writer.writeAttribute("ids", sb.toString());
            } else if (constraint.getKey() instanceof PathConstraintMultiValue) {
                writer.writeAttribute("op", "" + constraint.getKey().getOp());
                for (String value : ((PathConstraintMultiValue)constraint.getKey()).getValues()) {
                    if (!value.equals(value.trim())) {
                        throw new XMLStreamException("Value in MultiValue starts or ends with whitespace - this query cannot be represented in XML");
                    }
                    writer.writeStartElement("value");
                    writer.writeCharacters(value);
                    writer.writeEndElement();
                }
            } else if (constraint.getKey() instanceof PathConstraintLoop) {
                writer.writeAttribute("op", "" + constraint.getKey().getOp());
                writer.writeAttribute("loopPath", ((PathConstraintLoop)constraint.getKey()).getLoopPath());
            } else if (constraint.getKey() instanceof PathConstraintLookup) {
                writer.writeAttribute("op", "" + constraint.getKey().getOp());
                writer.writeAttribute("value", ((PathConstraintLookup)constraint.getKey()).getValue());
                String extraValue = ((PathConstraintLookup)constraint.getKey()).getExtraValue();
                if (extraValue != null) {
                    writer.writeAttribute("extraValue", extraValue);
                }
            } else {
                throw new IllegalStateException("Unrecognised constraint type " + constraint.getKey().getClass().getName());
            }
            if (emptyElement) continue;
            writer.writeEndElement();
        }
    }

    public void doAdditionalConstraintStuff(PathQuery query, PathConstraint constraint, XMLStreamWriter writer) throws XMLStreamException {
    }

    public static Map<String, PathQuery> unmarshalPathQueries(Reader reader, int version) {
        LinkedHashMap<String, PathQuery> queries = new LinkedHashMap<String, PathQuery>();
        try {
            SAXParser.parse((InputSource)new InputSource(reader), (DefaultHandler)new PathQueryHandler(queries, version));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return queries;
    }

    public static PathQuery unmarshalPathQuery(Reader reader, int version) {
        Map<String, PathQuery> map = PathQueryBinding.unmarshalPathQueries(reader, version);
        if (map.size() != 0) {
            return map.values().iterator().next();
        }
        return null;
    }
}

